<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$neuro_presets = apply_filters( 'neuro_element_presets', neuro_element_presets() );

$neuro_block_supports = array(
	'core/navigation'          => array(
		'elements' => array(
			'WRAPPER'              => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Navigation Wrapper',
					'selector' => '.wp-block-navigation',
				)
			),
			'CONTAINER'            => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Navigation Container',
					'selector' => '.wp-block-navigation__responsive-container.is-menu-open',
				)
			),
			'ITEM'                 => neuro_block_add_to_preset(
				$neuro_presets['LIST_ITEM'],
				array(
					'label'    => 'Navigation Item',
					'selector' => '.wp-block-navigation-item',
				)
			),
			'LINK'                 => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Navigation Link',
					'selector' => '.wp-block-navigation-item__content',
				)
			),
			'LABEL'                => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Navigation Label',
					'selector' => '.wp-block-navigation-item__label',
				)
			),
			'RESPONSIVE_OPEN'      => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Responsive Open Button',
					'selector' => '.wp-block-navigation__responsive-container-open',
				)
			),
			'RESPONSIVE_CONTAINER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Responsive Container',
					'selector' => '.wp-block-navigation__responsive-container',
				)
			),
			'RESPONSIVE_CLOSE'     => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Responsive Close Button',
					'selector' => '.wp-block-navigation__responsive-container-close',
				)
			),
			'LINKS'                => $neuro_presets['LINKS'],
		),
	),

	'core/site-logo'           => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Site Logo Wrapper',
					'selector' => '.wp-block-site-logo',
				)
			),
			'LINK'    => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Site Logo Link',
					'selector' => '.custom-logo-link',
				)
			),
			'IMAGE'   => neuro_block_add_to_preset(
				$neuro_presets['IMAGE'],
				array(
					'label'    => 'Site Logo Image',
					'selector' => '.custom-logo',
				)
			),
		),
	),

	'core/site-title'          => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Site Title',
					'selector' => '.wp-block-site-title',
				)
			),
			'LINK'    => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Site Title Link',
					'selector' => 'a',
				)
			),
		),
	),

	'core/site-tagline'        => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Site Tagline',
					'selector' => '.wp-block-site-tagline',
				)
			),
		),
	),

	'core/query'               => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Query Wrapper',
					'selector' => '.wp-block-query',
				)
			),
			'LINKS'   => $neuro_presets['LINKS'],
		),
	),

	'core/post-template'       => array(
		'elements' => array(
			'WRAPPER'   => neuro_block_add_to_preset(
				$neuro_presets['LIST_WRAPPER'],
				array(
					'label'    => 'Post Template Wrapper',
					'selector' => '.wp-block-post-template',
				)
			),
			'POST_ITEM' => neuro_block_add_to_preset(
				$neuro_presets['LIST_ITEM'],
				array(
					'label'    => 'Post Item',
					'selector' => 'li',
				)
			),
			'LINKS'     => $neuro_presets['LINKS'],
		),
	),

	'core/post-featured-image' => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['FIGURE'],
				array(
					'label'    => 'Post Featured Image Wrapper',
					'selector' => '.wp-block-post-featured-image',
				)
			),
			'IMAGE'   => neuro_block_add_to_preset(
				$neuro_presets['IMAGE'],
				array(
					'label'    => 'Post Featured Image',
					'selector' => 'img',
				)
			),
		),
	),

	'core/post-date'           => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Date',
					'selector' => '.wp-block-post-date',
				)
			),
			'TIME'    => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Date Time',
					'selector' => 'time',
				)
			),
		),
	),

	'core/post-title'          => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Title',
					'selector' => '.wp-block-post-title',
				)
			),
			'LINK'    => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Title Link',
					'selector' => 'a',
				)
			),
		),
	),

	'core/post-excerpt'        => array(
		'elements' => array(
			'WRAPPER'   => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Excerpt Wrapper',
					'selector' => '.wp-block-post-excerpt',
				)
			),
			'EXCERPT'   => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Excerpt Content',
					'selector' => '.wp-block-post-excerpt__excerpt',
				)
			),
			'MORE_TEXT' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Excerpt More Text',
					'selector' => '.wp-block-post-excerpt__more-text',
				)
			),
			'MORE_LINK' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Excerpt More Link',
					'selector' => '.wp-block-post-excerpt__more-link',
				)
			),
		),
	),

	'core/post-author'         => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Author Wrapper',
					'selector' => '.wp-block-post-author',
				)
			),
			'AVATAR'  => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Author Avatar',
					'selector' => '.wp-block-post-author__avatar',
				)
			),
			'IMAGE'   => neuro_block_add_to_preset(
				$neuro_presets['IMAGE'],
				array(
					'label'    => 'Post Author Avatar Image',
					'selector' => '.wp-block-post-author__avatar img',
				)
			),
			'CONTENT' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Author Content',
					'selector' => '.wp-block-post-author__content',
				)
			),
			'BYLINE'  => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Author Byline',
					'selector' => '.wp-block-post-author__byline',
				)
			),
			'NAME'    => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Author Name',
					'selector' => '.wp-block-post-author__name',
				)
			),
		),
	),

	'core/post-author-name'    => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Author Name',
					'selector' => '.wp-block-post-author-name',
				)
			),
		),
	),

	'core/post-terms'          => array(
		'elements' => array(
			'WRAPPER'   => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Terms Wrapper',
					'selector' => '.wp-block-post-terms',
				)
			),
			'PREFIX'    => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Terms Prefix',
					'selector' => '.wp-block-post-terms__prefix',
				)
			),
			'TERM_LINK' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Terms Link',
					'selector' => 'a',
				)
			),
			'SEPARATOR' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Terms Separator',
					'selector' => '.wp-block-post-terms__separator',
				)
			),
			'SUFFIX'    => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Terms Suffix',
					'selector' => '.wp-block-post-terms__suffix',
				)
			),
			'LINKS'     => $neuro_presets['LINKS'],
		),
	),

	'core/post-content'        => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Content Wrapper',
					'selector' => '.wp-block-post-content',
				)
			),
			'LINKS'   => $neuro_presets['LINKS'],
		),
	),

	'core/avatar'              => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Avatar Wrapper',
					'selector' => '.wp-block-avatar',
				)
			),
			'IMAGE'   => neuro_block_add_to_preset(
				$neuro_presets['IMAGE'],
				array(
					'label'    => 'Avatar Image',
					'selector' => '.wp-block-avatar__image',
				)
			),
		),
	),

	'core/loginout'            => array(
		'elements' => array(
			'WRAPPER'        => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Login/Logout Wrapper',
					'selector' => '.wp-block-loginout',
				)
			),
			'FORM'           => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Login Form',
					'selector' => 'form',
				)
			),
			'FORM_INPUT'     => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Form Input Fields',
					'selector' => '.input',
				)
			),
			'FORM_LABEL'     => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Form Label',
					'selector' => 'label',
				)
			),
			'USERNAME'       => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Username Field',
					'selector' => '.login-username',
				)
			),
			'USERNAME_LABEL' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Username Label',
					'selector' => '.login-username label',
				)
			),
			'USERNAME_INPUT' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Username Input',
					'selector' => '.login-username input',
				)
			),
			'PASSWORD'       => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Password Field',
					'selector' => '.login-password',
				)
			),
			'PASSWORD_LABEL' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Password Label',
					'selector' => '.login-password label',
				)
			),
			'PASSWORD_INPUT' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Password Input',
					'selector' => '.login-password input',
				)
			),
			'REMEMBER'       => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Remember Me Field',
					'selector' => '.login-remember',
				)
			),
			'REMEMBER_LABEL' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Remember Me Label',
					'selector' => '.login-remember label',
				)
			),
			'REMEMBER_INPUT' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Remember Me Input',
					'selector' => '.login-remember input',
				)
			),
			'SUBMIT'         => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Submit Field Wrapper',
					'selector' => '.login-submit',
				)
			),
			'SUBMIT_BUTTON'  => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Submit Button',
					'selector' => '.login-submit input[type="submit"]',
				)
			),
			'LINKS'          => $neuro_presets['LINKS'],
		),
	),

	'core/comments'            => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comments Wrapper',
					'selector' => '.wp-block-comments',
				)
			),
			'LINKS'   => $neuro_presets['LINKS'],
		),
	),

	'core/comments-title'      => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comments Title',
					'selector' => '.wp-block-comments-title',
				)
			),
		),
	),

	'core/comment-template'    => array(
		'elements' => array(
			'WRAPPER'      => neuro_block_add_to_preset(
				$neuro_presets['LIST_WRAPPER'],
				array(
					'label'    => 'Comment Template Wrapper',
					'selector' => '.wp-block-comment-template',
				)
			),
			'COMMENT_ITEM' => neuro_block_add_to_preset(
				$neuro_presets['LIST_ITEM'],
				array(
					'label'    => 'Comment Item',
					'selector' => 'li',
				)
			),
			'LINKS'        => $neuro_presets['LINKS'],
		),
	),

	'core/comment-date'        => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Date Wrapper',
					'selector' => '.wp-block-comment-date',
				)
			),
			'TIME'    => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Date Time',
					'selector' => 'time',
				)
			),
			'LINK'    => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Date Link',
					'selector' => 'a',
				)
			),
		),
	),

	'core/comment-author-name' => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Author Name',
					'selector' => '.wp-block-comment-author-name',
				)
			),
			'LINK'    => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Author Name Link',
					'selector' => 'a',
				)
			),
		),
	),

	'core/comment-content'     => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Content',
					'selector' => '.wp-block-comment-content',
				)
			),
			'LINKS'   => $neuro_presets['LINKS'],
		),
	),

	'core/comment-reply-link'  => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Reply Link Wrapper',
					'selector' => '.wp-block-comment-reply-link',
				)
			),
			'LINK'    => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Reply Link',
					'selector' => 'a',
				)
			),
		),
	),

	'core/post-comments-form'  => array(
		'elements' => array(
			'WRAPPER'            => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Post Comments Form Wrapper',
					'selector' => '.wp-block-post-comments-form',
				)
			),
			'RESPOND'            => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Respond Section',
					'selector' => '.comment-respond',
				)
			),
			'REPLY_TITLE'        => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Reply Title',
					'selector' => '.comment-reply-title',
				)
			),
			'CANCEL_REPLY_LINK'  => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Cancel Reply Link',
					'selector' => '#cancel-comment-reply-link',
				)
			),
			'FORM'               => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Form',
					'selector' => '.comment-form',
				)
			),
			'FORM_NOTES'         => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Form Notes',
					'selector' => '.comment-notes',
				)
			),
			'FORM_FIELD'         => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Form Field',
					'selector' => '.comment-form p',
				)
			),
			'FORM_LABEL'         => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Form Label',
					'selector' => '.comment-form label',
				)
			),
			'FORM_INPUT'         => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Form Input',
					'selector' => '.comment-form input:not([type="submit"])',
				)
			),
			'FORM_TEXTAREA'      => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Form Textarea',
					'selector' => '.comment-form textarea',
				)
			),
			'FORM_COMMENT_FIELD' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Field',
					'selector' => '.comment-form-comment',
				)
			),
			'FORM_AUTHOR_FIELD'  => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Author Field',
					'selector' => '.comment-form-author',
				)
			),
			'FORM_EMAIL_FIELD'   => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Email Field',
					'selector' => '.comment-form-email',
				)
			),
			'FORM_URL_FIELD'     => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'URL Field',
					'selector' => '.comment-form-url',
				)
			),
			'FORM_COOKIES_FIELD' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Cookies Consent Field',
					'selector' => '.comment-form-cookies-consent',
				)
			),
			'FORM_SUBMIT'        => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Form Submit',
					'selector' => '.form-submit',
				)
			),
			'FORM_SUBMIT_BUTTON' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Comment Submit Button',
					'selector' => '.form-submit input[type="submit"]',
				)
			),
			'REQUIRED'           => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Required Field Indicator',
					'selector' => '.required',
				)
			),
			'LINKS'              => $neuro_presets['LINKS'],
		),
	),


);

add_filter(
	'neuro_block_supports_schema',
	function( $schema ) use ( $neuro_block_supports ) {
		return array_merge( $schema, $neuro_block_supports );
	},
	10,
	2
);
