<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$neuro_presets = apply_filters( 'neuro_element_presets', neuro_element_presets() );

$neuro_block_supports = array(
	'core/paragraph'    => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Paragraph',
					'selector' => 'p',
				)
			),
			'LINKS'   => $neuro_presets['LINKS'],
		),
	),

	'core/heading'      => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label' => 'Heading',
				)
			),
			'STRONG'  => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Strong',
					'selector' => 'strong',
				)
			),
		),
	),

	'core/quote'        => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Quote Wrapper',
					'selector' => 'blockquote',
				)
			),
			'QUOTE'   => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Quote Content',
					'selector' => 'p',
				)
			),
			'LINKS'   => $neuro_presets['LINKS'],
		),
	),

	'core/code'         => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Code Wrapper',
					'selector' => 'pre',
				)
			),
			'CODE'    => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Code',
					'selector' => 'code',
				)
			),
		),
	),

	'core/details'      => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Details Wrapper',
					'selector' => 'details',
				)
			),
			'SUMMARY' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Summary',
					'selector' => 'summary',
				)
			),
			'CONTENT' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Details Content',
					'selector' => 'p',
				)
			),
			'LINKS'   => $neuro_presets['LINKS'],
		),
	),

	'core/preformatted' => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Preformatted',
					'selector' => 'pre',
				)
			),
		),
	),

	'core/verse'        => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Verse',
					'selector' => 'pre',
				)
			),
		),
	),

	'core/list'         => array(
		'elements' => array(
			'WRAPPER'   => $neuro_presets['LIST_WRAPPER'],
			'LINKS'     => $neuro_presets['LINKS'],
			'LIST_ITEM' => $neuro_presets['LIST_ITEM'],
		),
	),

	'core/list-item'    => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array( 'parent' => '.wp-block-list' )
				// array( 'tag' => '<wrapper_tag> li' )
			),
		),
	),

	'core/pullquote'    => array(
		'elements' => array(
			'WRAPPER' => $neuro_presets['WRAPPER'],
			'QUOTE'   => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Quote',
					'selector' => 'blockquote',
				)
			),
			'CITE'    => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Cite',
					'selector' => 'cite',
				)
			),
			'LINKS'   => $neuro_presets['LINKS'],
		),
	),

	'core/table'        => array(
		'elements' => array(
			'WRAPPER' => $neuro_presets['WRAPPER'],
			'TABLE'   => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Table',
					'selector' => 'table',
				)
			),
			'THEAD'   => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Table Head',
					'selector' => 'thead',
				)
			),
			'TBODY'   => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Table Body',
					'selector' => 'tbody',
				)
			),
			'TFOOT'   => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Table Footer',
					'selector' => 'tfoot',
				)
			),
			'TR'      => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Table Row',
					'selector' => 'tr',
				)
			),
			'TH'      => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Table Header',
					'selector' => 'th',
				)
			),
			'TD'      => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Table Data',
					'selector' => 'td',
				)
			),
			'CAPTION' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Table Caption',
					'selector' => 'figcaption',
				)
			),
			'LINKS'   => $neuro_presets['LINKS'],
		),
	),


);

add_filter(
	'neuro_block_supports_schema',
	function( $schema ) use ( $neuro_block_supports ) {
		return array_merge( $schema, $neuro_block_supports );
	},
	10,
	2
);
