<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$neuro_presets = apply_filters( 'neuro_element_presets', neuro_element_presets() );

$neuro_block_supports = array(
	'core/audio'      => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['FIGURE'],
				array(
					'label'    => 'Audio Wrapper',
					'selector' => 'figure',
				)
			),
			'AUDIO'   => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Audio',
					'selector' => 'audio',
				)
			),
		),
	),

	'core/cover'      => array(
		'elements' => array(
			'WRAPPER'         => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Cover Wrapper',
					'selector' => '.wp-block-cover',
				)
			),
			'IMAGE'           => neuro_block_add_to_preset(
				$neuro_presets['IMAGE'],
				array(
					'label'    => 'Cover Image',
					'selector' => '.wp-block-cover__image-background',
				)
			),
			'BACKGROUND'      => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Cover Background',
					'selector' => '.wp-block-cover__background',
				)
			),
			'INNER_CONTAINER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Cover Inner Container',
					'selector' => '.wp-block-cover__inner-container',
				)
			),
			'LINKS'           => $neuro_presets['LINKS'],
		),
	),

	'core/file'       => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'File Wrapper',
					'selector' => '.wp-block-file',
				)
			),
			'EMBED'   => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'File Embed',
					'selector' => '.wp-block-file__embed',
				)
			),
			'LINK'    => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'File Link',
					'selector' => 'a:not(.wp-block-file__button)',
				)
			),
			'BUTTON'  => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'File Button',
					'selector' => '.wp-block-file__button',
				)
			),
		),
	),

	'core/media-text' => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Media Text Wrapper',
					'selector' => '.wp-block-media-text',
				)
			),
			'MEDIA'   => neuro_block_add_to_preset(
				$neuro_presets['FIGURE'],
				array(
					'label'    => 'Media',
					'selector' => '.wp-block-media-text__media',
				)
			),
			'IMAGE'   => neuro_block_add_to_preset(
				$neuro_presets['IMAGE'],
				array(
					'label'    => 'Media Image',
					'selector' => 'img',
				)
			),
			'CONTENT' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Media Text Content',
					'selector' => '.wp-block-media-text__content',
				)
			),
			'LINKS'   => $neuro_presets['LINKS'],
		),
	),

	'core/video'      => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['FIGURE'],
				array(
					'label'    => 'Video Wrapper',
					'selector' => 'figure',
				)
			),
			'VIDEO'   => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Video',
					'selector' => 'video',
				)
			),
		),
	),

	'core/gallery'    => array(
		'elements' => array(
			'WRAPPER'         => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER_SIMPLE'],
				array(
					'label'    => 'Gallery Wrapper',
					'selector' => '.wp-block-gallery',
				)
			),
			'FIGURE'          => neuro_block_add_to_preset(
				$neuro_presets['FIGURE'],
				array(
					'label'     => 'Figure',
					'selector'  => 'figure',
					'className' => '.wp-block-image',
				)
			),
			'IMAGE'           => neuro_block_add_to_preset(
				$neuro_presets['IMAGE'],
				array(
					'label'    => 'Image',
					'selector' => 'img',
				)
			),
			'CAPTION_WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER_SIMPLE'],
				array(
					'label'    => 'Gallery Caption Background',
					'selector' => '.wp-block-image:before',
					'tag'      => 'figure',
				)
			),
			'CAPTION'         => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Gallery Caption',
					'selector' => '.wp-element-caption',
					'tag'      => 'figcaption',
					'parent'   => 'FIGURE',
				)
			),

		),
	),


	'core/image'      => array(
		'elements' => array(
			'IMAGE'           => neuro_block_add_to_preset(
				$neuro_presets['IMAGE'],
				array(
					'label'    => 'Image',
					'selector' => 'img',
				)
			),
			'WRAPPER'         => neuro_block_add_to_preset(
				$neuro_presets['FIGURE'],
				array(
					'label' => 'Image Wrapper',
					// 'selector' => 'figure',
					'tag'   => 'figure',
				)
			),
			'CAPTION_WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER_SIMPLE'],
				array(
					'label'             => 'Image Caption Background',
					'selector'          => '.wp-block-image.wp-block-image',
					'use_wrapper_class' => true,
					'pseudo_element'    => ':before',
				)
			),
			'CAPTION'         => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Image Caption',
					'selector' => 'figcaption.wp-element-caption',
				)
			),


		),
	),
);

add_filter(
	'neuro_block_supports_schema',
	function( $schema ) use ( $neuro_block_supports ) {
		return array_merge( $schema, $neuro_block_supports );
	},
	10,
	2
);
