<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$neuro_presets = apply_filters( 'neuro_element_presets', neuro_element_presets() );

$neuro_block_supports = array(
	'core/button'    => array(
		'elements' => array(
			'BUTTON'  => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'     => 'Button',
					'className' => '.wp-block-button__link.wp-element-button',
				)
			),
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER_SIMPLE'],
				array(
					'label' => 'Button Wrapper',
					// 'selector' => '.wp-block-button',

				)
			),
		),
	),

	'core/buttons'   => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER_SIMPLE'],
				array(
					'label'    => 'Button Wrapper',
					'selector' => '.wp-block-buttons',
				)
			),
			'BUTTON'  => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'     => 'Button',
					'className' => '.wp-block-button__link',
				)
			),
		),
	),


	'core/columns'   => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Columns Wrapper',
					'selector' => '.wp-block-columns',
				)
			),
			'COLUMN'  => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Column',
					'selector' => '.wp-block-column',
				)
			),
			'LINKS'   => $neuro_presets['LINKS'],
		),
	),

	'core/spacer'    => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER_SIMPLE'],
				array(
					'label'    => 'Spacer',
					'selector' => '.wp-block-spacer',
				)
			),
		),
	),

	'core/group'     => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER'],
				array(
					'label'    => 'Group Wrapper',
					'selector' => '.wp-block-group',
				)
			),
			'LINKS'   => $neuro_presets['LINKS'],
		),
	),

	'core/separator' => array(
		'elements' => array(
			'WRAPPER' => neuro_block_add_to_preset(
				$neuro_presets['WRAPPER_SIMPLE'],
				array(
					'label'    => 'Separator',
					'selector' => '.wp-block-separator',
				)
			),
		),
	),
);

add_filter(
	'neuro_block_supports_schema',
	function( $schema ) use ( $neuro_block_supports ) {
		return array_merge( $schema, $neuro_block_supports );
	},
	10,
	2
);
