<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

require_once NEUROGENESIS_PATH . 'config/block-supports/element-presets.php';
require_once NEUROGENESIS_PATH . 'config/block-supports/core-widgets.php';
require_once NEUROGENESIS_PATH . 'config/block-supports/core-text.php';
require_once NEUROGENESIS_PATH . 'config/block-supports/core-media.php';
require_once NEUROGENESIS_PATH . 'config/block-supports/core-design.php';
require_once NEUROGENESIS_PATH . 'config/block-supports/core-theme.php';

function neuro_block_add_to_preset( $preset, array $elements ) {
	foreach ( $elements as $key => $value ) {
		$preset[ $key ] = $value;
	}
	return $preset;
}


function neuro_block_supports_schema() {
	$neuro_presets = apply_filters( 'neuro_element_presets', neuro_element_presets() );

	$schema = array(
		'__default__' => array(
			'elements' => array(
				'WRAPPER' => $neuro_presets['WRAPPER'],
				'LINKS'   => $neuro_presets['LINKS'],
			),
		),

	);

	return apply_filters( 'neuro_block_supports_schema', $schema );
}


define( 'NEUROGENESIS_BLOCK_SUPPORTS', neuro_block_supports_schema() );
