<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

add_filter(
	'body_class',
	function( $classes ) {
		return array_merge( $classes, array( NEUROGENESIS_ID ) );
	}
);

add_filter(
	'admin_body_class',
	function( $classes ) {
		return $classes . ' admin-color-neurogenesis';
	}
);



function neuro_metadata_registration( $metadata ) {
	$disabled_blocks = NEUROGENESIS_DISABLED_BLOCKS;

	if ( in_array( $metadata['name'], $disabled_blocks, true ) || ! str_starts_with( $metadata['name'], 'core/' ) ) {
		return $metadata;
	}

	$attributes = isset( $metadata['attributes'] ) ? $metadata['attributes'] : array();

	$metadata['attributes'] = array_merge(
		$attributes,
		array(
			'neuro' => array(
				'type' => 'object',
			),
		)
	);

	return $metadata;
};
add_filter( 'block_type_metadata', 'neuro_metadata_registration' );
