<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<div class="asm-dashboard">
  <div class="asm-header">
    <h1><span class="dashicons dashicons-shield-alt"></span> Protected Forms List</h1>
    <p class="asm-subtitle">Manage your form protections</p>
    <p class="asm-website-link">
      <a href="http://needsplugin.com/" target="_blank" class="asm-website-btn">
        <span class="dashicons dashicons-external"></span> Visit Needs Plugin Website
      </a>
    </p>
  </div>
  
  <div class="asm-content">
    <div class="asm-card">
      <div class="asm-card-header">
        <h2><span class="dashicons dashicons-list-view"></span> Active Protections</h2>
        <a href="<?php echo esc_url( admin_url( 'admin.php?page=no-spam-forms' ) ); ?>" class="asm-btn asm-btn-primary">
          <span class="dashicons dashicons-plus-alt"></span> Add New Protection
        </a>
      </div>
      
      <div class="asm-protections-table">
        <table class="asm-table">
          <thead>
            <tr>
              <th>Form Plugin</th>
              <th>Form Name</th>
              <th>Protected Fields</th>
              <th>Block Links</th>
              <th>Created</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody id="protections-tbody">
            <?php
            // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Local template variable
            $protections = $this->get_all_protections();
            
            if ( empty( $protections ) ) {
              // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound,WordPress.WP.I18n.TextDomainMismatch -- Local template variable (not global scope), text domain uses hyphen (required), folder name has space
              $add_link = '<a href="' . esc_url( admin_url( 'admin.php?page=no-spam-forms' ) ) . '">' . esc_html__( 'Add your first protection', 'needsplugin-formshield' ) . '</a>';
              /* translators: %s: Link to add protection */
              // phpcs:ignore WordPress.WP.I18n.MissingTranslatorsComment,WordPress.WP.I18n.TextDomainMismatch -- Translators comment exists above, text domain uses hyphen (required), folder name has space
              echo '<tr><td colspan="6" class="asm-no-data">' . wp_kses_post( sprintf( __( 'No protected forms found. %s', 'needsplugin-formshield' ), $add_link ) ) . '</td></tr>';
            } else {
              // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Local template variable
              foreach ( $protections as $protection ) {
                // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Local template variable
                $plugin_names = array(
                  'contact-form-7' => 'Contact Form 7',
                  'gravity-forms' => 'Gravity Forms',
                  'wpforms' => 'WPForms',
                  'ninja-forms' => 'Ninja Forms',
                  'forminator' => 'Forminator',
                  'fluent-forms' => 'Fluent Forms',
                  'custom' => 'Custom Form'
                );
                
                // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Local template variables
                $plugin_display = isset( $plugin_names[ $protection['form_plugin'] ] ) ? $plugin_names[ $protection['form_plugin'] ] : ucfirst( sanitize_text_field( $protection['form_plugin'] ) );
                // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Local template variable
                $field_count = count( $protection['field_protections'] );
                // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Local template variable
                $created_date = gmdate( 'M j, Y', strtotime( $protection['created_at'] ) );
                // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Local template variable
                $block_links = isset( $protection['block_links'] ) ? (bool) $protection['block_links'] : true;
                // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Local template variable
                $form_title = isset( $protection['form_title'] ) ? $protection['form_title'] : '';
                // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Local template variable
                $protection_id = isset( $protection['id'] ) ? (int) $protection['id'] : 0;
                
                echo '<tr>';
                echo '<td><span class="asm-plugin-badge">' . esc_html( $plugin_display ) . '</span></td>';
                echo '<td><strong>' . esc_html( $form_title ) . '</strong></td>';
                // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch -- Text domain uses hyphen (required), folder name has space
                printf( '<td><span class="asm-field-count">%d %s</span></td>', esc_html( $field_count ), esc_html__( 'fields', 'needsplugin-formshield' ) );
                
                // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Local template variable
                $block_links_icon = $block_links 
                  ? '<span class="dashicons dashicons-yes-alt asm-icon-success"></span>' 
                  : '<span class="dashicons dashicons-no-alt asm-icon-danger"></span>';
                echo '<td>' . wp_kses_post( $block_links_icon ) . '</td>';
                echo '<td>' . esc_html( $created_date ) . '</td>';
                echo '<td class="asm-actions">';
                
                if ( $protection_id > 0 ) {
                  printf(
                    '<button class="asm-btn asm-btn-small asm-btn-secondary edit-protection" data-id="%s" type="button">%s %s</button>',
                    esc_attr( $protection_id ),
                    wp_kses_post( '<span class="dashicons dashicons-edit"></span>' ),
                    // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch -- Text domain uses hyphen (required), folder name has space
                    esc_html__( 'Edit', 'needsplugin-formshield' )
                  );
                  printf(
                    '<button class="asm-btn asm-btn-small asm-btn-danger delete-protection" data-id="%s" type="button">%s %s</button>',
                    esc_attr( $protection_id ),
                    wp_kses_post( '<span class="dashicons dashicons-trash"></span>' ),
                    // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch -- Text domain uses hyphen (required), folder name has space
                    esc_html__( 'Delete', 'needsplugin-formshield' )
                  );
                }
                echo '</td>';
                echo '</tr>';
              }
            }
            ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- Edit Protection Modal -->
<div id="edit-protection-modal" class="asm-modal asm-hidden">
  <div class="asm-modal-content">
    <div class="asm-modal-header">
      <h3>Edit Protection</h3>
      <span class="asm-modal-close">&times;</span>
    </div>
    <div class="asm-modal-body">
      <div id="edit-form-fields">
        <!-- Fields will be loaded dynamically -->
      </div>
    </div>
    <div class="asm-modal-footer">
      <button type="button" class="asm-btn asm-btn-secondary" id="cancel-edit">Cancel</button>
      <button type="button" class="asm-btn asm-btn-success" id="update-protection">Update Protection</button>
    </div>
  </div>
</div>