<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<div class="asm-dashboard">
  <div class="asm-header">
    <h1><span class="dashicons dashicons-shield-alt"></span> NP Form Shield</h1>
    <p class="asm-subtitle">Advanced spam protection for your forms</p>
    <p class="asm-website-link">
      <a href="http://needsplugin.com/" target="_blank" class="asm-website-btn">
        <span class="dashicons dashicons-external"></span> Visit Needs Plugin Website
      </a>
    </p>
  </div>
  
  <div class="asm-content">
    <div class="asm-card asm-setup-card">
      <div class="asm-card-header">
        <h2><span class="dashicons dashicons-admin-tools"></span> Setup New Protection</h2>
        <p>Protect your forms from spam with advanced filtering</p>
      </div>
      
      <div class="asm-setup-form">
        <div class="asm-step" id="step-1">
          <h3>Step 1: Select Form Plugin</h3>
          <div class="asm-form-plugins">
            <div class="asm-plugin-grid">
              <div class="asm-plugin-card asm-free-card" data-plugin="contact-form-7">
                <div class="asm-plugin-icon">📧</div>
                <h4>Contact Form 7</h4>
                <span class="asm-plugin-status" id="cf7-status">Checking...</span>
                <div class="asm-free-badge">Free</div>
              </div>
              
              <?php 
              // All premium plugins are disabled and marked as premium
              // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Local template variable
              $premium_cards = array(
                'gravity-forms' => array('icon' => '🚀', 'name' => 'Gravity Forms', 'status_id' => 'gf-status'),
                'wpforms' => array('icon' => '📝', 'name' => 'WPForms', 'status_id' => 'wpf-status'),
                'ninja-forms' => array('icon' => '🥷', 'name' => 'Ninja Forms', 'status_id' => 'nf-status'),
                'forminator' => array('icon' => '⚡', 'name' => 'Forminator', 'status_id' => 'forminator-status'),
                'fluent-forms' => array('icon' => '💧', 'name' => 'Fluent Forms', 'status_id' => 'ff-status')
                // Custom form removed - coming soon
              );
              
              // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Local template variable
              foreach ( $premium_cards as $plugin => $data ) : 
              ?>
              <div class="asm-plugin-card asm-premium-card asm-plugin-disabled" data-plugin="<?php echo esc_attr( $plugin ); ?>">
                <div class="asm-plugin-icon"><?php echo esc_html( $data['icon'] ); ?></div>
                <h4><?php echo esc_html( $data['name'] ); ?></h4>
                <span class="asm-plugin-status" id="<?php echo esc_attr( $data['status_id'] ); ?>">Premium</span>
                <div class="asm-premium-badge">Premium</div>
              </div>
              <?php endforeach; ?>
            </div>
          </div>
        </div>
        
        <div class="asm-step asm-hidden" id="step-2">
          <h3>Step 2: Select Form</h3>
          <div class="asm-form-selector">
            <select id="asm-form-select" class="asm-select">
              <option value="">Select a form...</option>
            </select>
            <div class="asm-loading asm-hidden" id="forms-loading">
              <span class="spinner"></span> Loading forms...
            </div>
          </div>
          
          <div class="asm-step-actions">
            <button type="button" class="asm-btn asm-btn-secondary" id="back-to-step-1">← Back</button>
            <button type="button" class="asm-btn asm-btn-primary" id="continue-to-step-3" disabled>Continue →</button>
          </div>
        </div>
        
        <div class="asm-step asm-hidden" id="step-3">
          <h3>Step 3: Configure Field Protection</h3>
          <div class="asm-form-fields" id="form-fields-container">
            <!-- Fields will be loaded dynamically -->
          </div>
          
          <div class="asm-step-actions">
            <button type="button" class="asm-btn asm-btn-secondary" id="back-to-step-2">← Back</button>
            <button type="button" class="asm-btn asm-btn-success" id="save-protection">💾 Save</button>
          </div>
        </div>
      </div>
    </div>
    
    <div class="asm-stats-grid">
      <div class="asm-stat-card">
        <div class="asm-stat-icon">🛡️</div>
        <div class="asm-stat-content">
          <h3 id="protected-forms-count">0</h3>
          <p>Protected Forms List</p>
        </div>
      </div>
      
      <div class="asm-stat-card">
        <div class="asm-stat-icon">🚫</div>
        <div class="asm-stat-content">
          <h3 id="protected-fields-count">0</h3>
          <p>Protected Fields</p>
        </div>
      </div>
      
      <div class="asm-stat-card">
        <div class="asm-stat-icon">✅</div>
        <div class="asm-stat-content">
          <h3>100%</h3>
          <p>Protection Rate</p>
        </div>
      </div>
    </div>
  </div>
</div>