// Forminator Error Display Enhancement for NP Form Shield
jQuery(document).ready(function($) {
    // Enhanced error display for Forminator forms
    function enhanceForminatorErrors() {
        // Monitor for form validation errors after AJAX submission
        $(document).on('forminator:form:submit:failed', '.forminator-custom-form', function(e, response) {
            var form = $(this);
            console.log('Forminator form submission failed:', response);
            
            // Check for field-specific errors in response
            if (response && response.errors) {
                $.each(response.errors, function(fieldId, errorMessage) {
                    var fieldWrapper = form.find('[data-field="' + fieldId + '"], [name="' + fieldId + '"]').closest('.forminator-field');
                    if (fieldWrapper.length === 0) {
                        // Try alternative selectors
                        fieldWrapper = form.find('#' + fieldId).closest('.forminator-field');
                    }
                    
                    if (fieldWrapper.length > 0) {
                        // Add visual error indicators
                        fieldWrapper.addClass('forminator-has-error asm-error-field');
                        fieldWrapper.find('input, textarea, select').addClass('forminator-error-input').css({
                            'border': '2px solid #dc3232',
                            'background-color': '#ffeaea',
                            'box-shadow': '0 0 5px rgba(220, 50, 50, 0.3)'
                        });
                        
                        // Add error icon to label
                        if (!fieldWrapper.find('.asm-error-icon').length) {
                            fieldWrapper.find('label').append(' <span class="asm-error-icon" style="color: #dc3232; font-weight: bold;">⚠️</span>');
                        }
                        
                        // Style existing error message or create new one
                        var errorElement = fieldWrapper.find('.forminator-error-message');
                        if (errorElement.length === 0) {
                            fieldWrapper.append('<div class="forminator-error-message asm-custom-error">' + errorMessage + '</div>');
                            errorElement = fieldWrapper.find('.asm-custom-error');
                        }
                        
                        errorElement.css({
                            'color': '#dc3232',
                            'font-weight': 'bold',
                            'margin-top': '5px',
                            'display': 'block',
                            'font-size': '14px'
                        });
                    }
                });
            }
        });
        
        // Also check for errors after form submission attempt
        $(document).on('submit', '.forminator-custom-form', function(e) {
            var form = $(this);
            
            // Wait for potential AJAX response
            setTimeout(function() {
                // Look for any error messages that appeared
                form.find('.forminator-error-message').each(function() {
                    var errorElement = $(this);
                    var fieldWrapper = errorElement.closest('.forminator-field');
                    
                    if (errorElement.text().trim() !== '' && fieldWrapper.length > 0) {
                        // Add visual indicators
                        fieldWrapper.addClass('forminator-has-error asm-error-field');
                        fieldWrapper.find('input, textarea, select').css({
                            'border': '2px solid #dc3232',
                            'background-color': '#ffeaea',
                            'box-shadow': '0 0 5px rgba(220, 50, 50, 0.3)'
                        });
                        
                        // Add error icon
                        if (!fieldWrapper.find('.asm-error-icon').length) {
                            fieldWrapper.find('label').append(' <span class="asm-error-icon" style="color: #dc3232; font-weight: bold;">⚠️</span>');
                        }
                        
                        // Style error message
                        errorElement.css({
                            'color': '#dc3232',
                            'font-weight': 'bold',
                            'margin-top': '5px',
                            'display': 'block',
                            'font-size': '14px'
                        });
                    }
                });
            }, 500);
        });
        
        // Clear errors on input change
        $(document).on('input change', '.forminator-custom-form input, .forminator-custom-form textarea, .forminator-custom-form select', function() {
            var field = $(this).closest('.forminator-field');
            field.removeClass('forminator-has-error asm-error-field');
            $(this).css({
                'border': '',
                'background-color': '',
                'box-shadow': ''
            });
            field.find('.asm-error-icon').remove();
            field.find('.asm-custom-error').remove();
        });
    }
    
    // Initialize error enhancement
    enhanceForminatorErrors();
    
    // Re-initialize on AJAX content load
    $(document).ajaxComplete(function() {
        setTimeout(enhanceForminatorErrors, 100);
    });
});
