<?php

namespace EazyAddonsForElementor\Widgets\Renders;

if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

/**
 * Render function for EAFE_Team_Member_Widget
 *
 * @param array $settings The widget settings passed from the main widget class.
 */
function render_eafe_team_member_widget( $settings ) {
    // Ensure required settings are available
    if ( empty( $settings['name'] ) ) {
        return;
    }

    $image = !empty($settings['image']['url']) ? $settings['image']['url'] : '';
    $image_alt = !empty($settings['name']) ? $settings['name'] : '';
    $name = $settings['name'];
    $position = !empty($settings['position']) ? $settings['position'] : '';
    $description = !empty($settings['description']) ? $settings['description'] : '';
    $social_icons = !empty($settings['social_icons']) ? $settings['social_icons'] : [];
    $social_icons_position = !empty($settings['social_icons_position']) ? $settings['social_icons_position'] : 'after_description';
    $layout_style = !empty($settings['layout_style']) ? $settings['layout_style'] : 'style-1';
    $content_alignment = !empty($settings['content_alignment']) ? $settings['content_alignment'] : 'center';
    $image_effect = !empty($settings['image_effect']) ? $settings['image_effect'] : 'none';
    $use_brand_colors = !empty($settings['use_brand_colors']) ? $settings['use_brand_colors'] : 'no';
    $brand_colors_on_hover = !empty($settings['brand_colors_on_hover']) ? $settings['brand_colors_on_hover'] : 'no';
    $container_hover_animation = !empty($settings['container_hover_animation']) ? ' elementor-animation-' . $settings['container_hover_animation'] : '';

    // Create wrapper classes
    $wrapper_classes = [
        'eafe-team-member',
        'eafe-team-member-' . $layout_style,
        'eafe-team-member-align-' . $content_alignment,
        'eafe-team-member-social-' . $social_icons_position,
        $container_hover_animation
    ];

    // Add brand color classes
    if ($use_brand_colors === 'yes') {
        $wrapper_classes[] = 'eafe-team-member-brand-colors';

        if ($brand_colors_on_hover === 'yes') {
            $wrapper_classes[] = 'eafe-team-member-brand-colors-hover';
        }
    }

    // Create image classes
    $image_classes = [
        'eafe-team-member-image',
        'eafe-team-member-image-effect-' . $image_effect
    ];

    // Output the team member
    echo '<div class="' . esc_attr( implode( ' ', $wrapper_classes ) ) . '">';

    // Image
    if ( $image ) {
        echo '<div class="' . esc_attr( implode( ' ', $image_classes ) ) . '">';
        echo '<img src="' . esc_url( $image ) . '" alt="' . esc_attr( $image_alt ) . '">';

        // Social icons on overlay
        if ( $social_icons_position === 'overlay' && !empty( $social_icons ) ) {
            echo '<div class="eafe-team-member-social-icons">';
            foreach ( $social_icons as $index => $icon ) {
                $social_icon = !empty($icon['social_icon']['value']) ? $icon['social_icon']['value'] : '';
                $social_link = !empty($icon['social_link']['url']) ? $icon['social_link']['url'] : '';
                $is_external = !empty($icon['social_link']['is_external']) ? ' target="_blank"' : '';
                $nofollow = !empty($icon['social_link']['nofollow']) ? ' rel="nofollow"' : '';

                if ( $social_icon && $social_link ) {
                    $icon_class = 'eafe-team-member-social-icon';
                    $icon_name = str_replace(['fab fa-', 'fas fa-', 'far fa-'], '', $social_icon);
                    $icon_class .= ' eafe-social-icon-' . $icon_name;

                    echo '<a href="' . esc_url( $social_link ) . '" class="' . esc_attr($icon_class) . '"' . $is_external . $nofollow . '>';
                    echo '<i class="' . esc_attr( $social_icon ) . '"></i>';
                    echo '</a>';
                }
            }
            echo '</div>';
        }

        echo '</div>';
    }

    // Content
    echo '<div class="eafe-team-member-content">';

    // Name
    echo '<h3 class="eafe-team-member-name">' . esc_html( $name ) . '</h3>';

    // Social icons after name
    if ( $social_icons_position === 'after_name' && !empty( $social_icons ) ) {
        echo '<div class="eafe-team-member-social-icons">';
        foreach ( $social_icons as $index => $icon ) {
            $social_icon = !empty($icon['social_icon']['value']) ? $icon['social_icon']['value'] : '';
            $social_link = !empty($icon['social_link']['url']) ? $icon['social_link']['url'] : '';
            $is_external = !empty($icon['social_link']['is_external']) ? ' target="_blank"' : '';
            $nofollow = !empty($icon['social_link']['nofollow']) ? ' rel="nofollow"' : '';

            if ( $social_icon && $social_link ) {
                $icon_class = 'eafe-team-member-social-icon';
                $icon_name = str_replace(['fab fa-', 'fas fa-', 'far fa-'], '', $social_icon);
                $icon_class .= ' eafe-social-icon-' . $icon_name;

                echo '<a href="' . esc_url( $social_link ) . '" class="' . esc_attr($icon_class) . '"' . $is_external . $nofollow . '>';
                echo '<i class="' . esc_attr( $social_icon ) . '"></i>';
                echo '</a>';
            }
        }
        echo '</div>';
    }

    // Position
    if ( $position ) {
        echo '<div class="eafe-team-member-position">' . esc_html( $position ) . '</div>';
    }

    // Social icons after position
    if ( $social_icons_position === 'after_position' && !empty( $social_icons ) ) {
        echo '<div class="eafe-team-member-social-icons">';
        foreach ( $social_icons as $index => $icon ) {
            $social_icon = !empty($icon['social_icon']['value']) ? $icon['social_icon']['value'] : '';
            $social_link = !empty($icon['social_link']['url']) ? $icon['social_link']['url'] : '';
            $is_external = !empty($icon['social_link']['is_external']) ? ' target="_blank"' : '';
            $nofollow = !empty($icon['social_link']['nofollow']) ? ' rel="nofollow"' : '';

            if ( $social_icon && $social_link ) {
                $icon_class = 'eafe-team-member-social-icon';
                $icon_name = str_replace(['fab fa-', 'fas fa-', 'far fa-'], '', $social_icon);
                $icon_class .= ' eafe-social-icon-' . $icon_name;

                echo '<a href="' . esc_url( $social_link ) . '" class="' . esc_attr($icon_class) . '"' . $is_external . $nofollow . '>';
                echo '<i class="' . esc_attr( $social_icon ) . '"></i>';
                echo '</a>';
            }
        }
        echo '</div>';
    }

    // Description
    if ( $description ) {
        echo '<div class="eafe-team-member-description">' . wp_kses_post( $description ) . '</div>';
    }

    // Social icons after description
    if ( $social_icons_position === 'after_description' && !empty( $social_icons ) ) {
        echo '<div class="eafe-team-member-social-icons">';
        foreach ( $social_icons as $index => $icon ) {
            $social_icon = !empty($icon['social_icon']['value']) ? $icon['social_icon']['value'] : '';
            $social_link = !empty($icon['social_link']['url']) ? $icon['social_link']['url'] : '';
            $is_external = !empty($icon['social_link']['is_external']) ? ' target="_blank"' : '';
            $nofollow = !empty($icon['social_link']['nofollow']) ? ' rel="nofollow"' : '';

            if ( $social_icon && $social_link ) {
                $icon_class = 'eafe-team-member-social-icon';
                $icon_name = str_replace(['fab fa-', 'fas fa-', 'far fa-'], '', $social_icon);
                $icon_class .= ' eafe-social-icon-' . $icon_name;

                echo '<a href="' . esc_url( $social_link ) . '" class="' . esc_attr($icon_class) . '"' . $is_external . $nofollow . '>';
                echo '<i class="' . esc_attr( $social_icon ) . '"></i>';
                echo '</a>';
            }
        }
        echo '</div>';
    }

    echo '</div>'; // End content

    echo '</div>'; // End team member
}