<?php
namespace EazyAddonsForElementor\Widgets\Renders;

use Elementor\Icons_Manager;

if (!defined('ABSPATH')) exit;

function render_eafe_step_flow_widget($settings, $widget) {
    $enable_dark_mode = $settings['enable_dark_mode'] === 'yes';
    $background_effects = $settings['background_effects'] === 'yes';
    $glow_effect = $settings['glow_effect'] === 'yes';
    $layout_style = $settings['layout_style'];

    $widget->add_render_attribute('step-flow', [
        'class' => [
            'eafe-step-flow',
            'eafe-step-flow--' . $layout_style,
        ],
        'role' => 'list',
        'aria-label' => 'Feature Workflow',
    ]);

    if ($enable_dark_mode) {
        $widget->add_render_attribute('step-flow', 'class', 'eafe-step-flow-dark');
    }

    if ($background_effects) {
        $widget->add_render_attribute('step-flow', 'class', 'eafe-step-flow-with-bg');
    }

    if (!$glow_effect) {
        $widget->add_render_attribute('step-flow', 'class', 'eafe-step-flow-no-glow');
    }
    ?>

    <div <?php echo $widget->get_render_attribute_string('step-flow'); ?>>
        <?php foreach ($settings['steps_list'] as $index => $step) :
            $step_number = $step['step_number'];
            $step_title = $step['step_title'];
            $step_description = $step['step_description'];
            $step_accent_color = $step['step_accent_color'];
            $step_icon_svg = $step['step_icon_svg'];
            $icon_type = $step['icon_type'];
            $arrow_type = $step['arrow_type'];
            $arrow_svg = $step['arrow_svg'];
            $is_last = $index === count($settings['steps_list']) - 1;

            $widget->add_render_attribute('step-' . $index, [
                'class' => ['eafe-step'],
                'role' => 'listitem',
                'tabindex' => '0',
                'style' => "--step-accent-color: {$step_accent_color};",
            ]);

            $widget->add_render_attribute('arrow-' . $index, [
                'class' => ['eafe-step-arrow', 'arrow-' . $arrow_type],
            ]);
            ?>

            <article <?php echo $widget->get_render_attribute_string('step-' . $index); ?>>
                <div class="eafe-step-circle" aria-hidden="true">
                    <?php if (!$is_last && $layout_style !== 'grid') : ?>
                        <span <?php echo $widget->get_render_attribute_string('arrow-' . $index); ?>>
                            <?php
                            if ($arrow_type === 'svg') {
                                echo $arrow_svg;
                            } elseif ($arrow_type === 'symbol') {
                                echo '<span class="arrow-symbol">⟶</span>';
                            } elseif ($arrow_type === 'icon') {
                                Icons_Manager::render_icon($step['arrow_icon'], ['aria-hidden' => 'true']);
                            }
                            ?>
                        </span>
                    <?php endif; ?>

                    <div class="eafe-step-icon">
                        <?php
                        if ($icon_type === 'svg') {
                            echo $step_icon_svg;
                        } else {
                            Icons_Manager::render_icon($step['step_icon'], ['aria-hidden' => 'true']);
                        }
                        ?>
                    </div>

                    <?php if (!empty($step_number)) : ?>
                        <span class="eafe-step-badge"><?php echo esc_html($step_number); ?></span>
                    <?php endif; ?>
                </div>

                <h3 class="eafe-step-title"><?php echo esc_html($step_title); ?></h3>
                <p class="eafe-step-description"><?php echo esc_html($step_description); ?></p>
            </article>
        <?php endforeach; ?>
    </div>

    <?php
}