<?php
namespace EazyAddonsForElementor\Widgets\Renders;

use Elementor\Group_Control_Image_Size;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

function render_eafe_smart_slider_widget($settings, $slides_data, $widget)
{
    if (empty($settings['slides'])) {
        echo '<div class="eafe-no-slides"><p>' . esc_html__('No slides added.', 'nb-eazy-addons-for-elementor') . '</p></div>';
        return;
    }

    // Slider settings for data attributes
    $slider_settings = [
        'effect' => $settings['transition_effect'],
        'direction' => $settings['direction'],
        'slidesPerView' => $settings['slides_per_view'],
        'spaceBetween' => $settings['space_between'],
        'speed' => $settings['speed'],
        'autoplay' => $settings['autoplay'] === 'yes',
        'autoplaySpeed' => $settings['autoplay_speed'],
        'loop' => $settings['loop'] === 'yes',
        'mousewheel' => $settings['mousewheel'] === 'yes',
        'keyboard' => $settings['keyboard'] === 'yes',
        'arrows' => $settings['show_arrows'] === 'yes',
        'dots' => $settings['show_dots'] === 'yes',
        'pauseOnHover' => $settings['pause_on_hover'] === 'yes',
        'contentPosition' => $settings['content_position'],
        'contentAlignment' => $settings['content_alignment']
    ];

    $widget->add_render_attribute('slider', [
        'class' => 'eafe-smart-slider',
        'data-settings' => wp_json_encode($slider_settings),
    ]);
    ?>
    <div <?php $widget->print_render_attribute_string('slider'); ?>>
        <div class="swiper-wrapper">
            <?php foreach ($slides_data as $slide_data):
                $slide = $slide_data['slide'];
                $attributes = $slide_data['attributes'];
                ?>
                <div <?php echo $attributes; ?>>
                    <div class="eafe-slide-inner">
                        <?php
                        // Image or Content Slide
                        if (in_array($slide['slide_type'], ['image', 'content'])) {
                            // FIX: Use placeholder image if no image is selected
                            if (empty($slide['slide_image']['url'])) {
                                $slide['slide_image']['url'] = \Elementor\Utils::get_placeholder_image_src();
                            }

                            if (!empty($slide['slide_image']['url'])) {
                                $image_html = Group_Control_Image_Size::get_attachment_image_html($slide, 'slide_image_size', 'slide_image');
                                echo $image_html;
                            }
                        }

                        // Video Slide
                        if ($slide['slide_type'] === 'video' && !empty($slide['video_url']['url'])) {
                            $video_attributes = [
                                'class' => 'eafe-slide-video',
                                'src' => esc_url($slide['video_url']['url']),
                                'controls' => 'controls',
                            ];

                            if (!empty($slide['video_poster']['url'])) {
                                $video_attributes['poster'] = esc_url($slide['video_poster']['url']);
                            }

                            echo '<video ';
                            foreach ($video_attributes as $key => $value) {
                                echo esc_attr($key) . '="' . esc_attr($value) . '" ';
                            }
                            echo '></video>';
                        }

                        // Content Slide
                        if ($slide['slide_type'] === 'content') {
                            $content_classes = [
                                'eafe-slide-content',
                                'position-' . esc_attr($settings['content_position']),
                                'text-' . esc_attr($settings['content_alignment'])
                            ];
                            ?>
                            <div class="<?php echo esc_attr(implode(' ', $content_classes)); ?>">
                                <?php if (!empty($slide['slide_title'])): ?>
                                    <h2 class="eafe-slide-title"><?php echo esc_html($slide['slide_title']); ?></h2>
                                <?php endif; ?>

                                <?php if (!empty($slide['slide_description'])): ?>
                                    <p class="eafe-slide-description"><?php echo esc_html($slide['slide_description']); ?></p>
                                <?php endif; ?>

                                <?php if (!empty($slide['slide_button_text']) && !empty($slide['slide_button_link']['url'])):
                                    $widget->add_render_attribute('button-' . $slide['_id'], [
                                        'class' => 'eafe-slide-button',
                                        'href' => esc_url($slide['slide_button_link']['url']),
                                    ]);

                                    if ($slide['slide_button_link']['is_external']) {
                                        $widget->add_render_attribute('button-' . $slide['_id'], 'target', '_blank');
                                    }

                                    if ($slide['slide_button_link']['nofollow']) {
                                        $widget->add_render_attribute('button-' . $slide['_id'], 'rel', 'nofollow');
                                    }
                                    ?>
                                    <a <?php $widget->print_render_attribute_string('button-' . $slide['_id']); ?>>
                                        <?php echo esc_html($slide['slide_button_text']); ?>
                                    </a>
                                <?php endif; ?>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

        <?php if ($settings['show_arrows'] === 'yes'): ?>
            <div class="eafe-slider-arrows">
                <div class="eafe-slider-arrow eafe-slider-prev swiper-button-prev"></div>
                <div class="eafe-slider-arrow eafe-slider-next swiper-button-next"></div>
            </div>
        <?php endif; ?>

        <?php if ($settings['show_dots'] === 'yes'): ?>
            <div class="eafe-slider-pagination swiper-pagination"></div>
        <?php endif; ?>
    </div>
    <?php
}