<?php

namespace EazyAddonsForElementor\Widgets\Renders;

if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

/**
 * Render function for EAFE_Review_Widget
 *
 * @param array $settings The widget settings passed from the main widget class.
 */
function render_eafe_review_widget( $settings ) {
    // Ensure all required settings are available
    if ( empty( $settings['reviewer_name'] ) || empty( $settings['review_text'] ) ) {
        return; // Exit if key settings are missing
    }

    $image_url = !empty( $settings['reviewer_image']['url'] )
        ? $settings['reviewer_image']['url']
        : \Elementor\Utils::get_placeholder_image_src();

    $rating = !empty( $settings['review_rating'] ) ? (int) $settings['review_rating'] : 5;

    echo '<div class="eafe-review">';

    // Render Header with Image and Basic Info
    echo '<div class="eafe-review-header">';

    // Render Image
    echo '<div class="eafe-review-image">';
    echo '<img src="' . esc_url( $image_url ) . '" alt="' . esc_attr( $settings['reviewer_name'] ) . '">'; // phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage
    echo '</div>';

    // Render Name and Location
    echo '<div class="eafe-review-meta">';
    echo '<h4 class="eafe-review-name">' . esc_html( $settings['reviewer_name'] ) . '</h4>';

    if ( !empty( $settings['reviewer_location'] ) ) {
        echo '<p class="eafe-review-location">' . esc_html( $settings['reviewer_location'] ) . '</p>';
    }
    echo '</div>';

    echo '</div>'; // End header

    // Render Stars
    echo '<div class="eafe-review-stars">';
    for ( $i = 1; $i <= 5; $i++ ) {
        if ( $i <= $rating ) {
            echo '<span class="star filled">★</span>';
        } else {
            echo '<span class="star empty">★</span>';
        }
    }
    echo '</div>';

    // Render Review Content
    echo '<div class="eafe-review-content">';

    if ( !empty( $settings['review_title'] ) ) {
        echo '<h5 class="eafe-review-title">' . esc_html( $settings['review_title'] ) . '</h5>';
    }

    echo '<p class="eafe-review-text">' . esc_html( $settings['review_text'] ) . '</p>';

    if ( 'yes' === $settings['show_date'] && !empty( $settings['review_date'] ) ) {
        echo '<p class="eafe-review-date">' . esc_html( $settings['review_date'] ) . '</p>';
    }

    echo '</div>'; // End content

    echo '</div>'; // End review
}