<?php
namespace EazyAddonsForElementor\Widgets\Renders;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

function render_eafe_post_carousel_widget($settings)
{
    // Query arguments
    $args = [
        'post_type'      => $settings['post_type'],
        'posts_per_page' => $settings['posts_per_page'],
        'order'          => $settings['order'],
        'orderby'        => $settings['orderby'],
    ];

    // Add category filter if set
    if (!empty($settings['category'])) {
        $args['cat'] = implode(',', $settings['category']);
    }

    $query = new \WP_Query($args);

    // Carousel settings for data attributes
    $carousel_settings = [
        'slidesToShow'   => $settings['slides_to_show'],
        'slidesToScroll' => $settings['slides_to_scroll'],
        'autoplay'       => $settings['autoplay'] === 'yes',
        'autoplaySpeed'  => $settings['autoplay_speed'],
        'infinite'       => $settings['infinite'] === 'yes',
        'arrows'         => $settings['show_arrows'] === 'yes',
        'dots'           => $settings['show_dots'] === 'yes',
        'pauseOnHover'   => $settings['pause_on_hover'] === 'yes',
        'spaceBetween'   => $settings['space_between'],
    ];

    // Check if we're in the Elementor editor
    $is_editor = \Elementor\Plugin::$instance->editor->is_edit_mode();

    if ($query->have_posts()): ?>
        <div class="eafe-post-carousel<?php echo $is_editor ? ' elementor-editor-mode' : ''; ?>"
             data-settings='<?php echo json_encode($carousel_settings); ?>'>
            <div class="swiper-wrapper">
                <?php while ($query->have_posts()):
                    $query->the_post(); ?>
                    <div class="swiper-slide eafe-post-slide eafe-hover-<?php echo esc_attr($settings['hover_effect']); ?>">
                        <?php
                        // Get thumbnail URL with default fallback
                        $thumbnail_url = get_carousel_thumbnail_url($settings);

                        if ($thumbnail_url): ?>
                            <div class="eafe-post-thumbnail">
                                <a href="<?php echo $is_editor ? '#' : get_permalink(); ?>">
                                    <img src="<?php echo esc_url($thumbnail_url); ?>"
                                         alt="<?php the_title_attribute(); ?>"
                                         loading="lazy">
                                </a>
                            </div>
                        <?php endif; ?>

                        <div class="eafe-post-content">
                            <h3 class="eafe-post-title">
                                <a href="<?php echo $is_editor ? '#' : get_permalink(); ?>"><?php the_title(); ?></a>
                            </h3>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>

            <?php if ($settings['show_arrows'] === 'yes'): ?>
                <div class="eafe-carousel-arrows">
                    <div class="eafe-carousel-arrow eafe-carousel-prev swiper-button-prev"></div>
                    <div class="eafe-carousel-arrow eafe-carousel-next swiper-button-next"></div>
                </div>
            <?php endif; ?>

            <?php if ($settings['show_dots'] === 'yes'): ?>
                <div class="eafe-carousel-dots swiper-pagination"></div>
            <?php endif; ?>
        </div>

        <?php if ($is_editor): ?>
            <script>
                // Reinitialize carousel in editor mode
                jQuery(document).ready(function ($) {
                    setTimeout(function () {
                        if (typeof window.initializeCarousels === 'function') {
                            window.initializeCarousels();
                        }
                    }, 300);
                });
            </script>
        <?php endif; ?>

    <?php else: ?>
        <div class="eafe-no-posts-found">
            <p><?php _e('No posts found.', 'nb-eazy-addons-for-elementor'); ?></p>
        </div>
    <?php endif;

    wp_reset_postdata();
}

/**
 * Get thumbnail URL for carousel with default fallback
 *
 * @param array $settings Widget settings
 * @return string|false Thumbnail URL or false if no image available
 */
function get_carousel_thumbnail_url($settings) {
    $image_size = $settings['image_size'] ?? 'medium_large';

    // Try to get featured image first
    if (has_post_thumbnail()) {
        return get_the_post_thumbnail_url(get_the_ID(), $image_size);
    }

    // Check if default thumbnail is enabled and available
    if ($settings['show_default_thumbnail'] === 'yes' && !empty($settings['default_thumbnail']['url'])) {
        return $settings['default_thumbnail']['url'];
    }

    // Return false if no image is available
    return false;
}