<?php

namespace EazyAddonsForElementor\Widgets\Renders;

if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

/**
 * Render function for EAFE_Number_Widget
 *
 * @param array $settings The widget settings passed from the main widget class.
 */
function render_eafe_number_widget( $settings ) {
    // Get settings
    $number = !empty($settings['number']) ? $settings['number'] : '42';
    $number_prefix = !empty($settings['number_prefix']) ? $settings['number_prefix'] : '';
    $number_suffix = !empty($settings['number_suffix']) ? $settings['number_suffix'] : '';
    $title = !empty($settings['title']) ? $settings['title'] : '';
    $description = !empty($settings['description']) ? $settings['description'] : '';
    $number_style = !empty($settings['number_style']) ? $settings['number_style'] : 'style-1';
    $prefix_suffix_position = !empty($settings['prefix_suffix_position']) ? $settings['prefix_suffix_position'] : 'inline';
    $alignment = !empty($settings['alignment']) ? $settings['alignment'] : 'center';

    // Create wrapper classes
    $wrapper_classes = [
        'eafe-number-container',
        'eafe-number-style-' . $number_style,
        'eafe-number-ps-' . $prefix_suffix_position,
        'eafe-align-' . $alignment,
    ];

    // Output the number widget
    echo '<div class="' . esc_attr( implode( ' ', $wrapper_classes ) ) . '">';

    // Prefix (above position)
    if ($number_prefix && $prefix_suffix_position === 'above') {
        echo '<div class="eafe-number-prefix eafe-number-prefix-above">' . esc_html($number_prefix) . '</div>';
    }

    // Number container
    echo '<div class="eafe-number-wrapper">';

    // Prefix (inline position)
    if ($number_prefix && $prefix_suffix_position === 'inline') {
        echo '<span class="eafe-number-prefix eafe-number-prefix-inline">' . esc_html($number_prefix) . '</span>';
    }

    // The number itself
    echo '<div class="eafe-number">' . esc_html($number) . '</div>';

    // Suffix (inline position)
    if ($number_suffix && $prefix_suffix_position === 'inline') {
        echo '<span class="eafe-number-suffix eafe-number-suffix-inline">' . esc_html($number_suffix) . '</span>';
    }

    echo '</div>'; // End number wrapper

    // Suffix (below position)
    if ($number_suffix && $prefix_suffix_position === 'below') {
        echo '<div class="eafe-number-suffix eafe-number-suffix-below">' . esc_html($number_suffix) . '</div>';
    }

    // Title
    if ($title) {
        echo '<' . esc_attr('h3') . ' class="eafe-number-title">' . esc_html($title) . '</' . esc_attr('h3') . '>';
    }

    // Description
    if ($description) {
        echo '<div class="eafe-number-description">' . wp_kses_post($description) . '</div>';
    }

    echo '</div>'; // End container
}