<?php

namespace EazyAddonsForElementor\Widgets\Renders;

if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

/**
 * Render function for EAFE_Logo_Grid_Widget
 *
 * @param array $settings The widget settings passed from the main widget class.
 */
function render_eafe_logo_grid_widget( $settings ) {
    // Ensure we have logo items
    if ( empty( $settings['logo_items'] ) ) {
        return;
    }

    $layout_style = !empty($settings['layout_style']) ? $settings['layout_style'] : 'style-1';
    $columns = !empty($settings['columns']) ? $settings['columns'] : '4';
    $show_tooltip = !empty($settings['show_tooltip']) && $settings['show_tooltip'] === 'yes';
    $grayscale_effect = !empty($settings['grayscale_effect']) && $settings['grayscale_effect'] === 'yes';
    $hover_effect = !empty($settings['hover_effect']) ? $settings['hover_effect'] : 'grow';

    // Carousel settings
    $autoplay = !empty($settings['autoplay']) && $settings['autoplay'] === 'yes';
    $autoplay_speed = !empty($settings['autoplay_speed']) ? $settings['autoplay_speed'] : 3000;
    $loop = !empty($settings['loop']) && $settings['loop'] === 'yes';
    $show_arrows = !empty($settings['show_arrows']) && $settings['show_arrows'] === 'yes';
    $show_dots = !empty($settings['show_dots']) && $settings['show_dots'] === 'yes';

    // Create wrapper classes
    $wrapper_classes = [
        'eafe-logo-grid-container',
        'eafe-logo-grid-' . $layout_style,
        'eafe-logo-grid-columns-' . $columns,
    ];

    // Add grayscale class
    if ($grayscale_effect) {
        $wrapper_classes[] = 'eafe-logo-grid-grayscale';
    }

    // Add hover effect class for style 5
    if ($layout_style === 'style-5' && $hover_effect !== 'none') {
        $wrapper_classes[] = 'eafe-logo-hover-' . $hover_effect;
    }

    // Prepare data attributes for carousel
    $data_attributes = '';
    if ($layout_style === 'style-4') {
        $data_attributes = sprintf(
            'data-autoplay="%s" data-autoplay-speed="%d" data-loop="%s" data-show-dots="%s"',
            $autoplay ? 'yes' : 'no',
            $autoplay_speed,
            $loop ? 'yes' : 'no',
            $show_dots ? 'yes' : 'no'
        );
    }

    // Generate unique ID for this instance
    $unique_id = 'eafe-logo-grid-' . uniqid();

    // Output the logo grid
    echo '<div id="' . esc_attr($unique_id) . '" class="' . esc_attr( implode( ' ', $wrapper_classes ) ) . '" ' . $data_attributes . '>';

    if ($layout_style === 'style-4') {
        // Swiper Carousel Layout
        echo '<div class="eafe-logo-swiper swiper">';
        echo '<div class="swiper-wrapper">';

        // Process logo items for carousel
        foreach ($settings['logo_items'] as $index => $item) {
            $image_url = !empty($item['logo_image']['url']) ? $item['logo_image']['url'] : '';
            $logo_name = !empty($item['logo_name']) ? $item['logo_name'] : '';
            $link = !empty($item['logo_link']['url']) ? $item['logo_link']['url'] : '';
            $is_external = !empty($item['logo_link']['is_external']) ? ' target="_blank"' : '';
            $nofollow = !empty($item['logo_link']['nofollow']) ? ' rel="nofollow"' : '';

            // Skip if no image
            if (!$image_url) {
                continue;
            }

            // Output swiper slide
            echo '<div class="swiper-slide eafe-logo-grid-item">';

            // Logo with optional link
            if ($link) {
                echo '<a href="' . esc_url($link) . '"' . $is_external . $nofollow . ' class="eafe-logo-grid-link">';
            }

            echo '<img src="' . esc_url($image_url) . '" alt="' . esc_attr($logo_name) . '" class="eafe-logo-grid-image" loading="lazy">';

            // Tooltip
            if ($show_tooltip && $logo_name) {
                echo '<div class="eafe-logo-grid-tooltip">' . esc_html($logo_name) . '</div>';
            }

            if ($link) {
                echo '</a>';
            }

            echo '</div>'; // End swiper slide
        }

        echo '</div>'; // End swiper-wrapper

        // Swiper Navigation
        if ($show_arrows) {
            echo '<div class="swiper-button-next"></div>';
            echo '<div class="swiper-button-prev"></div>';
        }

        echo '</div>'; // End swiper container

        // Swiper Pagination
        if ($show_dots) {
            echo '<div class="swiper-pagination"></div>';
        }

    } else {
        // Standard Grid Layout
        echo '<div class="eafe-logo-grid">';

        // Process logo items for grid
        foreach ($settings['logo_items'] as $index => $item) {
            $image_url = !empty($item['logo_image']['url']) ? $item['logo_image']['url'] : '';
            $logo_name = !empty($item['logo_name']) ? $item['logo_name'] : '';
            $link = !empty($item['logo_link']['url']) ? $item['logo_link']['url'] : '';
            $is_external = !empty($item['logo_link']['is_external']) ? ' target="_blank"' : '';
            $nofollow = !empty($item['logo_link']['nofollow']) ? ' rel="nofollow"' : '';

            // Skip if no image
            if (!$image_url) {
                continue;
            }

            // Output grid item
            echo '<div class="eafe-logo-grid-item">';

            // Logo with optional link
            if ($link) {
                echo '<a href="' . esc_url($link) . '"' . $is_external . $nofollow . ' class="eafe-logo-grid-link">';
            }

            echo '<img src="' . esc_url($image_url) . '" alt="' . esc_attr($logo_name) . '" class="eafe-logo-grid-image" loading="lazy">';

            // Tooltip
            if ($show_tooltip && $logo_name) {
                echo '<div class="eafe-logo-grid-tooltip">' . esc_html($logo_name) . '</div>';
            }

            if ($link) {
                echo '</a>';
            }

            echo '</div>'; // End grid item
        }

        echo '</div>'; // End grid
    }

    echo '</div>'; // End container
}