<?php

namespace EazyAddonsForElementor\Widgets\Renders;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Render function for EAFE_Image_Comparison_Widget
 *
 * @param array $settings The widget settings passed from the main widget class.
 */
function render_eafe_image_comparison_widget($settings)
{
    // Ensure all required settings are available
    if (empty($settings['before_image']['url']) || empty($settings['after_image']['url'])) {
        return; // Exit if key settings are missing
    }

    $before_image_url  = $settings['before_image']['url'];
    $after_image_url   = $settings['after_image']['url'];
    $before_label      = !empty($settings['before_label']) ? $settings['before_label'] : __('Before', 'nb-eazy-addons-for-elementor');
    $after_label       = !empty($settings['after_label']) ? $settings['after_label'] : __('After', 'nb-eazy-addons-for-elementor');
    $show_percentage   = !empty($settings['show_percentage']) && $settings['show_percentage'] === 'yes';
    $default_position  = !empty($settings['default_position']['size']) ? $settings['default_position']['size'] : 50;
    $orientation       = !empty($settings['orientation']) ? $settings['orientation'] : 'horizontal';
    $interaction_mode  = !empty($settings['interaction_mode']) ? $settings['interaction_mode'] : 'drag';
    $hover_sensitivity = !empty($settings['hover_sensitivity']['size']) ? $settings['hover_sensitivity']['size'] : 10;
    $show_controls     = !empty($settings['show_controls']) && $settings['show_controls'] === 'yes';
    $add_caption       = !empty($settings['add_caption']) && $settings['add_caption'] === 'yes';
    $caption_text      = !empty($settings['caption_text']) ? $settings['caption_text'] : '';

    // Control buttons settings
    $show_before_button = !empty($settings['show_before_button']) && $settings['show_before_button'] === 'yes';
    $before_button_text = !empty($settings['before_button_text']) ? $settings['before_button_text'] : __('View Before', 'nb-eazy-addons-for-elementor');
    $show_after_button  = !empty($settings['show_after_button']) && $settings['show_after_button'] === 'yes';
    $after_button_text  = !empty($settings['after_button_text']) ? $settings['after_button_text'] : __('View After', 'nb-eazy-addons-for-elementor');
    $show_reset_button  = !empty($settings['show_reset_button']) && $settings['show_reset_button'] === 'yes';
    $reset_button_text  = !empty($settings['reset_button_text']) ? $settings['reset_button_text'] : __('Reset', 'nb-eazy-addons-for-elementor');

    // Generate unique ID for this widget instance
    $unique_id = 'eafe-image-comparison-' . uniqid();

    echo '<div class="eafe-image-comparison-wrapper" data-orientation="' . esc_attr($orientation) . '">';

    echo '<div class="eafe-image-comparison-container" id="' . esc_attr($unique_id) . '"
          data-position="' . esc_attr($default_position) . '"
          data-interaction="' . esc_attr($interaction_mode) . '"
          data-sensitivity="' . esc_attr($hover_sensitivity) . '">';

    echo '<img src="' . esc_url($after_image_url) . '" alt="' . esc_attr($after_label) . '">';
    echo '<div class="eafe-image-comparison-before">';
    echo '<img src="' . esc_url($before_image_url) . '" alt="' . esc_attr($before_label) . '">';
    echo '</div>';
    echo '<div class="eafe-image-comparison-handle"></div>';
    echo '<div class="eafe-badge eafe-badge-before"><i class="fas fa-arrow-left"></i> ' . esc_html($before_label) . '</div>';
    echo '<div class="eafe-badge eafe-badge-after"><i class="fas fa-arrow-right"></i> ' . esc_html($after_label) . '</div>';

    if ($show_percentage) {
        echo '<div class="eafe-percentage">' . esc_html($default_position) . '%</div>';
    }

    echo '</div>';

    // Control buttons
    if ($show_controls && ($show_before_button || $show_after_button || $show_reset_button)) {
        echo '<div class="eafe-comparison-controls">';

        if ($show_before_button) {
            echo '<button class="eafe-control-before" data-action="before">' . esc_html($before_button_text) . '</button>';
        }

        if ($show_after_button) {
            echo '<button class="eafe-control-after" data-action="after">' . esc_html($after_button_text) . '</button>';
        }

        if ($show_reset_button) {
            echo '<button class="eafe-control-reset" data-action="reset">' . esc_html($reset_button_text) . '</button>';
        }

        echo '</div>';
    }

    // Caption
    if ($add_caption && !empty($caption_text)) {
        echo '<div class="eafe-comparison-caption">' . esc_html($caption_text) . '</div>';
    }

    echo '</div>';
}
