<?php

namespace EazyAddonsForElementor\Widgets\Renders;

if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly
}

/**
 * Render function for EAFE_Gradient_Heading_Widget
 *
 * @param array $settings The widget settings passed from the main widget class.
 */
function render_eafe_gradient_heading_widget($settings)
{
  // Ensure title is available
  if (empty($settings['title'])) {
    return;
  }

  $title    = $settings['title'];
  $html_tag = !empty($settings['html_tag']) ? $settings['html_tag'] : 'h2';
  $link     = $settings['link'];

  // Create attributes for the wrapper
  $wrapper_class = 'eafe-gradient-heading';

  // Create the heading
  $heading_html = sprintf(
    '<%1$s class="eafe-gradient-heading-text">%2$s</%1$s>',
    $html_tag,
    esc_html($title)
  );

  // Add link if provided
  if (!empty($link['url'])) {
    $target   = $link['is_external'] ? ' target="_blank"' : '';
    $nofollow = $link['nofollow'] ? ' rel="nofollow"' : '';

    $heading_html = sprintf(
      '<a href="%s"%s%s>%s</a>',
      esc_url($link['url']),
      $target,
      $nofollow,
      $heading_html
    );
  }

  // Output the heading
  echo '<div class="' . esc_attr($wrapper_class) . '">';
  echo $heading_html;
  echo '</div>';
}
