<?php
namespace EazyAddonsForElementor\Widgets\Renders;

use Elementor\Icons_Manager;

if (!defined('ABSPATH')) exit;

function render_eafe_fun_counter_widget($settings, $widget) {
    $layout_preset = $settings['layout_preset'];
    $enable_animation = $settings['enable_animation'] === 'yes';
    $animation_duration = isset($settings['animation_duration']['size']) ? absint($settings['animation_duration']['size']) : 2000;
    $enable_dark_mode = $settings['enable_dark_mode'] === 'yes';
    $background_effects = $settings['background_effects'] === 'yes';

    $widget->add_render_attribute('fun-counter', [
        'class' => [
            'eafe-fun-counter',
            'eafe-fun-counter--' . esc_attr($layout_preset),
        ],
        'role' => 'list',
        'aria-label' => esc_attr__('Fun Counter Statistics', 'nb-eazy-addons-for-elementor'),
    ]);

    if ($enable_animation) {
        $widget->add_render_attribute('fun-counter', 'data-animation-duration', $animation_duration);
    }

    if ($enable_dark_mode) {
        $widget->add_render_attribute('fun-counter', 'class', 'eafe-fun-counter-dark');
    }

    if ($background_effects) {
        $widget->add_render_attribute('fun-counter', 'class', 'eafe-fun-counter-with-bg');
    }
    ?>

    <div <?php echo $widget->get_render_attribute_string('fun-counter'); ?>>
        <?php foreach ($settings['factors_list'] as $index => $factor) :
            $repeater_key = $factor['repeater_key'];
            $icon_type = isset($factor['icon_type']) ? $factor['icon_type'] : 'none';
            $start_number = isset($factor['factor_start_number']) ? absint($factor['factor_start_number']) : 0;
            $end_number = isset($factor['factor_end_number']) ? absint($factor['factor_end_number']) : 0;
            $suffix = isset($factor['factor_suffix']) ? $factor['factor_suffix'] : '';
            $title = isset($factor['factor_title']) ? $factor['factor_title'] : '';
            $accent_color = isset($factor['factor_accent_color']) ? $factor['factor_accent_color'] : '#33484e';
            $icon_color = isset($factor['factor_icon_color']) ? $factor['factor_icon_color'] : '#000000';

            // Sanitize colors
            $accent_color = sanitize_hex_color($accent_color) ?: '#33484e';
            $icon_color = sanitize_hex_color($icon_color) ?: '#000000';

            $widget->add_render_attribute($repeater_key, [
                'class' => ['eafe-factor', 'elementor-repeater-item-' . esc_attr($factor['_id'])],
                'role' => 'listitem',
                'tabindex' => '0',
                'style' => sprintf('--factor-accent-color: %s;', esc_attr($accent_color)),
            ]);

            // Add icon wrapper attribute with inline color style
            $icon_wrapper_key = 'icon-wrapper-' . $index;
            $widget->add_render_attribute($icon_wrapper_key, [
                'class' => 'eafe-factor-icon',
                'aria-hidden' => 'true',
                'style' => sprintf('color: %s; --icon-color: %s;', esc_attr($icon_color), esc_attr($icon_color)),
            ]);

            // Prepare number attributes
            $number_key = 'factor-number-' . $index;
            $widget->add_render_attribute($number_key, 'class', 'eafe-factor-number');

            if ($enable_animation) {
                $widget->add_render_attribute($number_key, [
                    'data-start' => $start_number,
                    'data-end' => $end_number,
                    'data-suffix' => esc_attr($suffix),
                    'aria-live' => 'off',
                ]);
            } else {
                $widget->add_render_attribute($number_key, [
                    'aria-label' => sprintf(
                        esc_attr__('%1$s%2$s %3$s', 'nb-eazy-addons-for-elementor'),
                        $end_number,
                        $suffix,
                        $title
                    ),
                ]);
            }
            ?>

            <article <?php echo $widget->get_render_attribute_string($repeater_key); ?>>
                <?php if ($icon_type !== 'none') : ?>
                    <div <?php echo $widget->get_render_attribute_string($icon_wrapper_key); ?>>
                        <?php
                        if ($icon_type === 'icon' && !empty($factor['factor_icon']['value'])) {
                            // Render icon with explicit color
                            Icons_Manager::render_icon(
                                $factor['factor_icon'],
                                [
                                    'aria-hidden' => 'true',
                                    'role' => 'img',
                                    'style' => 'color: ' . esc_attr($icon_color) . '; fill: ' . esc_attr($icon_color) . ';'
                                ]
                            );
                        } elseif ($icon_type === 'svg' && !empty($factor['factor_svg'])) {
                            // For custom SVG, process the SVG content
                            $svg_content = $factor['factor_svg'];

                            // Add color directly to SVG if it's a simple SVG string
                            if (strpos($svg_content, 'style=') === false && strpos($svg_content, 'fill=') === false) {
                                // Add style attribute to SVG tag
                                $svg_content = preg_replace(
                                    '/<svg([^>]*)>/',
                                    '<svg$1 style="fill: ' . esc_attr($icon_color) . '; color: ' . esc_attr($icon_color) . ';">',
                                    $svg_content
                                );
                            }

                            // Add color to all path elements if they don't have fill
                            $svg_content = preg_replace(
                                '/<path([^>]*(?!(fill|style))=([^>]*))>/',
                                '<path$1 fill="' . esc_attr($icon_color) . '">',
                                $svg_content
                            );

                            // Sanitize SVG output
                            $allowed_svg_tags = [
                                'svg' => [
                                    'class' => true,
                                    'aria-hidden' => true,
                                    'aria-labelledby' => true,
                                    'role' => true,
                                    'xmlns' => true,
                                    'width' => true,
                                    'height' => true,
                                    'viewbox' => true,
                                    'viewBox' => true,
                                    'style' => true,
                                    'fill' => true,
                                    'stroke' => true,
                                ],
                                'g' => ['fill' => true, 'style' => true, 'stroke' => true],
                                'title' => ['title' => true],
                                'path' => ['d' => true, 'fill' => true, 'style' => true, 'stroke' => true, 'stroke-width' => true],
                                'circle' => ['cx' => true, 'cy' => true, 'r' => true, 'fill' => true, 'style' => true, 'stroke' => true],
                                'rect' => ['x' => true, 'y' => true, 'width' => true, 'height' => true, 'fill' => true, 'style' => true, 'stroke' => true],
                                'polygon' => ['points' => true, 'fill' => true, 'style' => true, 'stroke' => true],
                                'line' => ['x1' => true, 'y1' => true, 'x2' => true, 'y2' => true, 'stroke' => true, 'style' => true],
                            ];
                            echo wp_kses($svg_content, $allowed_svg_tags);
                        } elseif ($icon_type === 'image' && !empty($factor['factor_image']['url'])) {
                            $image_url = esc_url($factor['factor_image']['url']);
                            $image_alt = !empty($factor['factor_image']['alt'])
                                ? esc_attr($factor['factor_image']['alt'])
                                : esc_attr($title);

                            printf(
                                '<img src="%s" alt="%s" loading="lazy">',
                                $image_url,
                                $image_alt
                            );
                        }
                        ?>
                    </div>
                <?php endif; ?>

                <div class="eafe-factor-content">
                    <div <?php echo $widget->get_render_attribute_string($number_key); ?>>
                        <?php
                        if ($enable_animation) {
                            echo esc_html($start_number . $suffix);
                        } else {
                            echo esc_html($end_number . $suffix);
                        }
                        ?>
                    </div>

                    <?php if (!empty($title)) : ?>
                        <h3 class="eafe-factor-title"><?php echo esc_html($title); ?></h3>
                    <?php endif; ?>
                </div>
            </article>
        <?php endforeach; ?>
    </div>

    <?php
}