<?php
namespace EazyAddonsForElementor\Widgets\Renders;

if (!defined('ABSPATH')) exit;

function render_eafe_card_widget($settings) {
    $card_classes = [
        'eafe-card',
        'eafe-card-' . $settings['card_style'],
        'eafe-card-hover-' . $settings['card_hover_effect'],
        'eafe-content-hover-' . $settings['content_hover_effect']
    ];

    $image_classes = [
        'eafe-card-image',
        'eafe-image-hover-' . $settings['image_hover_effect']
    ];

    $badge_classes = ['eafe-card-badge', 'eafe-card-badge-' . $settings['badge_position']];

    // Initialize variables
    $target = '';
    $nofollow = '';
    $link = '';
    $button_text = '';
    $show_button = false;
    $badge_content = '';

    if ($settings['card_type'] === 'post' && !empty($settings['post_id'])) {
        $post = get_post($settings['post_id']);
        if (!$post) return;

        $image_url = get_the_post_thumbnail_url($post->ID, 'full');
        $title = $post->post_title;
        $description = wp_trim_words($post->post_content, 20);
        $link = get_permalink($post->ID);
        $button_text = $settings['post_button_text'];
        $show_button = $settings['show_post_button'] === 'yes';

        // Post badge content
        if ($settings['show_post_badge'] === 'yes') {
            $badge_parts = [];

            if (!empty($settings['post_badge_text'])) {
                $badge_parts[] = esc_html($settings['post_badge_text']);
            }

            if ($settings['show_category'] === 'yes') {
                $categories = get_the_category($post->ID);
                if (!empty($categories)) {
                    $badge_parts[] = esc_html($categories[0]->name);
                }
            }

            $badge_content = implode(' | ', $badge_parts);
        }

    } elseif ($settings['card_type'] === 'product' && !empty($settings['product_id'])) {
        $product = wc_get_product($settings['product_id']);
        if (!$product) return;

        $image_url = get_the_post_thumbnail_url($product->get_id(), 'full');
        $title = $product->get_name();
        $description = $product->get_short_description() ?: wp_trim_words($product->get_description(), 20);
        $link = get_permalink($product->get_id());
        $show_button = $settings['show_add_to_cart'] === 'yes';

        // Product badge content
        if ($settings['show_product_badge'] === 'yes') {
            $badge_parts = [];

            if (!empty($settings['product_badge_text'])) {
                $badge_parts[] = esc_html($settings['product_badge_text']);
            }

            if ($settings['show_price'] === 'yes') {
                $badge_parts[] = $product->get_price_html();
            }

            $badge_content = implode(' | ', $badge_parts);
        }

    } else {
        // Custom card content
        $image_url = $settings['image']['url'];
        $title = $settings['title'];
        $description = $settings['description'];
        $link = $settings['link']['url'];
        $button_text = $settings['button_text'];
        $show_button = !empty($button_text);
        $badge_content = $settings['badge_text'];

        // Only set target and nofollow for custom cards
        $target = isset($settings['link']['is_external']) && $settings['link']['is_external'] ? ' target="_blank"' : '';
        $nofollow = isset($settings['link']['nofollow']) && $settings['link']['nofollow'] ? ' rel="nofollow"' : '';
    }
    ?>

    <div class="<?php echo esc_attr(implode(' ', $card_classes)); ?>">
        <?php if ($image_url) : ?>
            <div class="eafe-card-image-wrap">
                <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($title); ?>" class="<?php echo esc_attr(implode(' ', $image_classes)); ?>">
                <?php if (!empty($badge_content)) : ?>
                    <span class="<?php echo esc_attr(implode(' ', $badge_classes)); ?>"><?php echo wp_kses_post($badge_content); ?></span>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <div class="eafe-card-content">
            <?php if ($title) : ?>
                <h3 class="eafe-card-title"><?php echo esc_html($title); ?></h3>
            <?php endif; ?>

            <?php if ($description) : ?>
                <div class="eafe-card-description"><?php echo wp_kses_post($description); ?></div>
            <?php endif; ?>

            <?php if ($settings['card_type'] === 'product' && $settings['show_rating'] === 'yes' && isset($product)) : ?>
                <div class="eafe-product-rating">
                    <?php echo wc_get_rating_html($product->get_average_rating()); ?>
                </div>
            <?php endif; ?>

            <?php if ($settings['card_type'] === 'product' && $settings['show_add_to_cart'] === 'yes' && isset($product)) : ?>
                <a href="<?php echo esc_url($product->add_to_cart_url()); ?>" class="eafe-card-button add_to_cart_button">
                    <?php echo esc_html__('Add to Cart', 'woocommerce'); ?>
                </a>
            <?php elseif ($show_button && $link) : ?>
                <a href="<?php echo esc_url($link); ?>" class="eafe-card-button"<?php echo $target . $nofollow; ?>>
                    <?php echo esc_html($button_text); ?>
                </a>
            <?php endif; ?>
        </div>
    </div>

    <?php
}