<?php

namespace EazyAddonsForElementor\Widgets\Renders;

if (!defined('ABSPATH')) {
  exit;
}

function render_eafe_calendly_widget($settings)
{
  if (empty($settings['calendly_username'])) {
    echo esc_html__('Please enter your Calendly username.', 'nb-eazy-addons-for-elementor');
    return;
  }

  $hide_details = $settings['hide_event_details'] === 'true' ? 'true' : 'false';
  $event_type   = $settings['calendly_event_type'] ?? '30min';
  $height       = intval($settings['calendly_height']['size']);

  $url = sprintf(
    'https://calendly.com/%s/%s?hide_event_type_details=%s',
    esc_attr($settings['calendly_username']),
    esc_attr($event_type),
    $hide_details
  );
  ?>
  <div class="eafe-calendly-wrapper">
    <div class="calendly-inline-widget" data-url="<?php echo esc_url($url); ?>"
      style="min-width:320px;height:<?php echo esc_attr($height); ?>px;">
    </div>
    <script src="https://assets.calendly.com/assets/external/widget.js" async></script>
  </div>
  <?php
}
