<?php
namespace EazyAddonsForElementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Border;
use Elementor\Widget_Base;
use Elementor\Icons_Manager;

if (!defined('ABSPATH')) exit;

class EAFE_Step_Flow_Widget extends Widget_Base {

    public function get_name() {
        return EAFE_WIDGET_PREFIX . 'step_flow';
    }

    public function get_title() {
        return __('Step Flow', 'nb-eazy-addons-for-elementor');
    }

    public function get_icon() {
        return 'eicon-flow';
    }

    public function get_categories() {
        return ['eazy-addons-for-elementor-category'];
    }

    protected function _register_controls() {
        // Steps Content Section
        $this->start_controls_section(
            'steps_section',
            [
                'label' => __('Steps', 'nb-eazy-addons-for-elementor'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'icon_type',
            [
                'label' => __('Icon Type', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'svg',
                'options' => [
                    'svg' => __('Custom SVG', 'nb-eazy-addons-for-elementor'),
                    'icon' => __('Icon Library', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $repeater->add_control(
            'step_icon_svg',
            [
                'label' => __('Step Icon SVG', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M12 5v9"></path><path d="M8.5 9v5"></path><path d="M15.5 11v3"></path><path d="M5 13v2a4 4 0 0 0 4 4h4a5 5 0 0 0 5-5v-2a2 2 0 0 0-2-2h-1"></path></svg>',
                'description' => __('Paste SVG code for the step icon', 'nb-eazy-addons-for-elementor'),
                'condition' => [
                    'icon_type' => 'svg',
                ],
            ]
        );

        $repeater->add_control(
            'step_icon',
            [
                'label' => __('Step Icon', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'icon_type' => 'icon',
                ],
            ]
        );

        $repeater->add_control(
            'step_number',
            [
                'label' => __('Step Number', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '1',
                'placeholder' => __('Enter step number (leave empty to hide)', 'nb-eazy-addons-for-elementor'),
            ]
        );

        $repeater->add_control(
            'step_title',
            [
                'label' => __('Title', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Step Title', 'nb-eazy-addons-for-elementor'),
                'placeholder' => __('Enter step title', 'nb-eazy-addons-for-elementor'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'step_description',
            [
                'label' => __('Description', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'nb-eazy-addons-for-elementor'),
                'placeholder' => __('Enter step description', 'nb-eazy-addons-for-elementor'),
            ]
        );

        $repeater->add_control(
            'step_accent_color',
            [
                'label' => __('Accent Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#e11d48',
            ]
        );

        $repeater->add_control(
            'arrow_type',
            [
                'label' => __('Arrow Type', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'default',
                'options' => [
                    'default' => __('Default Arrow', 'nb-eazy-addons-for-elementor'),
                    'svg' => __('Custom SVG', 'nb-eazy-addons-for-elementor'),
                    'symbol' => __('Long Arrow Symbol (⟶)', 'nb-eazy-addons-for-elementor'),
                    'icon' => __('Icon Library', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $repeater->add_control(
            'arrow_svg',
            [
                'label' => __('Arrow SVG', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => '',
                'description' => __('Paste SVG code for the arrow', 'nb-eazy-addons-for-elementor'),
                'condition' => [
                    'arrow_type' => 'svg',
                ],
            ]
        );

        $repeater->add_control(
            'arrow_icon',
            [
                'label' => __('Arrow Icon', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-arrow-right',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'arrow_type' => 'icon',
                ],
            ]
        );

        $this->add_control(
            'steps_list',
            [
                'label' => __('Steps', 'nb-eazy-addons-for-elementor'),
                'type'  => Controls_Manager::REPEATER,
                'fields'=> $repeater->get_controls(),

                // Set 3 default steps here
                'default' => [
                    [
                        'icon_type'         => 'svg',
                        'step_number'       => '1',
                        'step_title'        => __('Plan', 'nb-eazy-addons-for-elementor'),
                        'step_description'  => __('Define goals and scope.', 'nb-eazy-addons-for-elementor'),
                        'step_accent_color' => '#e11d48',
                        'step_icon_svg'     => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M3 7h18M3 12h12M3 17h8"/></svg>',
                        'arrow_type'        => 'default',
                    ],
                    [
                        'icon_type'         => 'svg',
                        'step_number'       => '2',
                        'step_title'        => __('Build', 'nb-eazy-addons-for-elementor'),
                        'step_description'  => __('Implement and iterate.', 'nb-eazy-addons-for-elementor'),
                        'step_accent_color' => '#7c3aed',
                        'step_icon_svg'     => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M12 2v20M2 12h20"/></svg>',
                        'arrow_type'        => 'default',
                    ],
                    [
                        'icon_type'         => 'svg',
                        'step_number'       => '3',
                        'step_title'        => __('Launch', 'nb-eazy-addons-for-elementor'),
                        'step_description'  => __('Test, deploy, and monitor.', 'nb-eazy-addons-for-elementor'),
                        'step_accent_color' => '#0284c7',
                        'step_icon_svg'     => '<svg viewBox="0 0 24 24" aria-hidden="true"><path d="M3 12l18-8-8 18-2-8-8-2z"/></svg>',
                        'arrow_type'        => 'default',
                    ],
                ],

                'title_field' => '{{{ step_title }}}',
            ]
        );

        $this->end_controls_section();

        // Layout Section
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'nb-eazy-addons-for-elementor'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_style',
            [
                'label' => __('Layout Style', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'horizontal',
                'options' => [
                    'horizontal' => __('Horizontal', 'nb-eazy-addons-for-elementor'),
                    'vertical' => __('Vertical', 'nb-eazy-addons-for-elementor'),
                    'grid' => __('Grid', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'enable_dark_mode',
            [
                'label' => __('Enable Dark Mode', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('No', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'background_effects',
            [
                'label' => __('Background Effects', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('Hide', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'background_color',
            [
                'label' => __('Background Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => 'hsl(210 40% 98%)',
                'selectors' => [
                    '{{WRAPPER}} .eafe-step-flow-with-bg' => '--bg: {{VALUE}};',
                ],
                'condition' => [
                    'background_effects' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'step_gap',
            [
                'label' => __('Step Gap', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'vw'],
                'range' => [
                    'px' => ['min' => 10, 'max' => 100],
                    'vw' => ['min' => 1, 'max' => 10],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 36,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-step-flow' => '--step-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Style Section
        $this->start_controls_section(
            'style_section',
            [
                'label' => __('Style', 'nb-eazy-addons-for-elementor'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'circle_size',
            [
                'label' => __('Circle Size', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'vw'],
                'range' => [
                    'px' => ['min' => 80, 'max' => 200],
                    'vw' => ['min' => 10, 'max' => 30],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 140,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-step-flow' => '--circle: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __('Icon Size', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'vw'],
                'range' => [
                    'px' => ['min' => 20, 'max' => 60],
                    'vw' => ['min' => 2, 'max' => 10],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 42,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-step-circle svg, {{WRAPPER}} .eafe-step-circle i' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-step-title',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description_typography',
                'label' => __('Description Typography', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-step-description',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'circle_shadow',
                'label' => __('Circle Shadow', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-step-circle',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'circle_border',
                'label' => __('Circle Border', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-step-circle',
            ]
        );

        $this->add_control(
            'arrow_style',
            [
                'label' => __('Arrow Style', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'solid',
                'options' => [
                    'solid' => __('Solid', 'nb-eazy-addons-for-elementor'),
                    'dashed' => __('Dashed', 'nb-eazy-addons-for-elementor'),
                    'dotted' => __('Dotted', 'nb-eazy-addons-for-elementor'),
                    'none' => __('None', 'nb-eazy-addons-for-elementor'),
                ],
                'condition' => [
                    'steps_list.arrow_type' => ['default', 'symbol'],
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_length',
            [
                'label' => __('Arrow Length', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'vw'],
                'range' => [
                    'px' => ['min' => 40, 'max' => 200],
                    'vw' => ['min' => 5, 'max' => 20],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 120,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-step-flow' => '--arrow-len: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'arrow_style!' => 'none',
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_height',
            [
                'label' => __('Arrow Height', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => ['min' => 1, 'max' => 10],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 2,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-step-flow' => '--arrow-height: {{SIZE}}{{UNIT}}; --thickness: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'arrow_style!' => 'none',
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_head_size',
            [
                'label' => __('Arrow Head Size', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => ['min' => 5, 'max' => 20],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-step-flow' => '--head-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'arrow_style!' => 'none',
                    'steps_list.arrow_type' => ['default'],
                ],
            ]
        );

        $this->add_control(
            'glow_effect',
            [
                'label' => __('Glow Effect', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('Hide', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        require_once __DIR__ . '/renders/render-eafe-step-flow-widget.php';
        \EazyAddonsForElementor\Widgets\Renders\render_eafe_step_flow_widget($settings, $this);
    }
}