<?php

namespace EazyAddonsForElementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;

if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly
}

class EAFE_Social_Icons_Widget extends Widget_Base
{

  public function get_name()
  {
    return EAFE_WIDGET_PREFIX . 'social-icons';
  }

  public function get_title()
  {
    return __('Social Icons', 'nb-eazy-addons-for-elementor');
  }

  public function get_icon()
  {
    return 'eicon-social-icons';
  }

  public function get_categories()
  {
    return ['eazy-addons-for-elementor-category'];
  }

  public function get_keywords()
  {
    return ['social', 'icons', 'links', 'facebook', 'twitter', 'instagram'];
  }

  protected function _register_controls()
  {
    // Content Section - Social Icons
    $this->start_controls_section(
      'social_icons_content',
      [
        'label' => __('Social Icons', 'nb-eazy-addons-for-elementor'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );

    $repeater = new Repeater();

    $repeater->add_control(
      'social_icon',
      [
        'label'   => __('Icon', 'nb-eazy-addons-for-elementor'),
        'type'    => Controls_Manager::ICONS,
        'default' => [
          'value'   => 'fab fa-wordpress',
          'library' => 'fa-brands',
        ],
      ]
    );

    $repeater->add_control(
      'social_label',
      [
        'label'       => __('Label', 'nb-eazy-addons-for-elementor'),
        'type'        => Controls_Manager::TEXT,
        'default'     => __('Social Profile', 'nb-eazy-addons-for-elementor'),
        'placeholder' => __('Enter social media name', 'nb-eazy-addons-for-elementor'),
        'label_block' => true,
      ]
    );

    $repeater->add_control(
      'link',
      [
        'label'         => __('Link', 'nb-eazy-addons-for-elementor'),
        'type'          => Controls_Manager::URL,
        'placeholder'   => __('https://your-social-link.com', 'nb-eazy-addons-for-elementor'),
        'default'       => [
          'url' => '#',
        ],
        'show_external' => true,
      ]
    );

    // Individual Color Controls
    $repeater->add_control(
      'custom_colors',
      [
        'label'        => __('Custom Colors', 'nb-eazy-addons-for-elementor'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Custom', 'nb-eazy-addons-for-elementor'),
        'label_off'    => __('Auto', 'nb-eazy-addons-for-elementor'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );

    $repeater->add_control(
      'icon_color',
      [
        'label'     => __('Icon Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} {{CURRENT_ITEM}}.eafe-social-icon'     => 'color: {{VALUE}} !important;',
          '{{WRAPPER}} {{CURRENT_ITEM}}.eafe-social-icon svg' => 'fill: {{VALUE}} !important;',
        ],
        'condition' => [
          'custom_colors' => 'yes',
        ],
      ]
    );

    $repeater->add_control(
      'icon_bg_color',
      [
        'label'     => __('Background Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} {{CURRENT_ITEM}}.eafe-social-icon' => 'background-color: {{VALUE}} !important;',
        ],
        'condition' => [
          'custom_colors' => 'yes',
        ],
      ]
    );

    $repeater->add_control(
      'icon_border_color',
      [
        'label'     => __('Border Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} {{CURRENT_ITEM}}.eafe-social-icon' => 'border-color: {{VALUE}} !important;',
        ],
        'condition' => [
          'custom_colors' => 'yes',
          'view'          => 'framed',
        ],
      ]
    );

    $repeater->add_control(
      'icon_hover_color',
      [
        'label'     => __('Hover Icon Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} {{CURRENT_ITEM}}.eafe-social-icon:hover'     => 'color: {{VALUE}} !important;',
          '{{WRAPPER}} {{CURRENT_ITEM}}.eafe-social-icon:hover svg' => 'fill: {{VALUE}} !important;',
        ],
        'condition' => [
          'custom_colors' => 'yes',
        ],
      ]
    );

    $repeater->add_control(
      'icon_hover_bg_color',
      [
        'label'     => __('Hover Background Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} {{CURRENT_ITEM}}.eafe-social-icon:hover' => 'background-color: {{VALUE}} !important;',
        ],
        'condition' => [
          'custom_colors' => 'yes',
        ],
      ]
    );

    $repeater->add_control(
      'icon_hover_border_color',
      [
        'label'     => __('Hover Border Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} {{CURRENT_ITEM}}.eafe-social-icon:hover' => 'border-color: {{VALUE}} !important;',
        ],
        'condition' => [
          'custom_colors' => 'yes',
          'view'          => 'framed',
        ],
      ]
    );

    $this->add_control(
      'social_icon_list',
      [
        'label'       => __('Social Icons', 'nb-eazy-addons-for-elementor'),
        'type'        => Controls_Manager::REPEATER,
        'fields'      => $repeater->get_controls(),
        'default'     => [
          [
            'social_icon'         => [
              'value'   => 'fab fa-facebook-f',
              'library' => 'fa-brands',
            ],
            'social_label'        => __('Facebook', 'nb-eazy-addons-for-elementor'),
            'link'                => ['url' => 'https://facebook.com/'],
            'custom_colors'       => 'yes',
            'icon_color'          => '#1877F2',
            'icon_bg_color'       => '#1877F2',
            'icon_hover_color'    => '#ffffff',
            'icon_hover_bg_color' => '#0D5FCF',
          ],
          [
            'social_icon'         => [
              'value'   => 'fab fa-twitter',
              'library' => 'fa-brands',
            ],
            'social_label'        => __('Twitter', 'nb-eazy-addons-for-elementor'),
            'link'                => ['url' => 'https://twitter.com/'],
            'custom_colors'       => 'yes',
            'icon_color'          => '#1DA1F2',
            'icon_bg_color'       => '#1DA1F2',
            'icon_hover_color'    => '#ffffff',
            'icon_hover_bg_color' => '#0C8BD9',
          ],
          [
            'social_icon'         => [
              'value'   => 'fab fa-instagram',
              'library' => 'fa-brands',
            ],
            'social_label'        => __('Instagram', 'nb-eazy-addons-for-elementor'),
            'link'                => ['url' => 'https://instagram.com/'],
            'custom_colors'       => 'yes',
            'icon_color'          => '#E4405F',
            'icon_bg_color'       => '#E4405F',
            'icon_hover_color'    => '#ffffff',
            'icon_hover_bg_color' => '#D32A4A',
          ],
          [
            'social_icon'         => [
              'value'   => 'fab fa-linkedin-in',
              'library' => 'fa-brands',
            ],
            'social_label'        => __('LinkedIn', 'nb-eazy-addons-for-elementor'),
            'link'                => ['url' => 'https://linkedin.com/'],
            'custom_colors'       => 'yes',
            'icon_color'          => '#0A66C2',
            'icon_bg_color'       => '#0A66C2',
            'icon_hover_color'    => '#ffffff',
            'icon_hover_bg_color' => '#0855A3',
          ],
        ],
        'title_field' => '{{{ social_label }}}',
      ]
    );

    $this->add_control(
      'view',
      [
        'label'   => __('Layout', 'nb-eazy-addons-for-elementor'),
        'type'    => Controls_Manager::SELECT,
        'default' => 'default',
        'options' => [
          'default' => __('Default', 'nb-eazy-addons-for-elementor'),
          'stacked' => __('Stacked', 'nb-eazy-addons-for-elementor'),
          'framed'  => __('Framed', 'nb-eazy-addons-for-elementor'),
        ],
      ]
    );

    $this->add_control(
      'shape',
      [
        'label'     => __('Shape', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::SELECT,
        'default'   => 'circle',
        'options'   => [
          'circle'  => __('Circle', 'nb-eazy-addons-for-elementor'),
          'square'  => __('Square', 'nb-eazy-addons-for-elementor'),
          'rounded' => __('Rounded', 'nb-eazy-addons-for-elementor'),
          'none'    => __('None', 'nb-eazy-addons-for-elementor'),
        ],
        'condition' => [
          'view!' => 'default',
        ],
      ]
    );

    $this->add_control(
      'show_label',
      [
        'label'        => __('Show Label', 'nb-eazy-addons-for-elementor'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Show', 'nb-eazy-addons-for-elementor'),
        'label_off'    => __('Hide', 'nb-eazy-addons-for-elementor'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );

    $this->add_control(
      'alignment',
      [
        'label'     => __('Alignment', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::CHOOSE,
        'options'   => [
          'left'   => [
            'title' => __('Left', 'nb-eazy-addons-for-elementor'),
            'icon'  => 'eicon-text-align-left',
          ],
          'center' => [
            'title' => __('Center', 'nb-eazy-addons-for-elementor'),
            'icon'  => 'eicon-text-align-center',
          ],
          'right'  => [
            'title' => __('Right', 'nb-eazy-addons-for-elementor'),
            'icon'  => 'eicon-text-align-right',
          ],
        ],
        'default'   => 'center',
        'selectors' => [
          '{{WRAPPER}} .eafe-social-icons' => 'text-align: {{VALUE}};',
        ],
      ]
    );

    $this->end_controls_section();

    // ... rest of the style sections remain the same ...
    // Style Section - Icons
    $this->start_controls_section(
      'section_social_style',
      [
        'label' => __('Icons', 'nb-eazy-addons-for-elementor'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_responsive_control(
      'icon_size',
      [
        'label'     => __('Icon Size', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::SLIDER,
        'range'     => [
          'px' => [
            'min' => 6,
            'max' => 50,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .eafe-social-icon i'   => 'font-size: {{SIZE}}{{UNIT}};',
          '{{WRAPPER}} .eafe-social-icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'icon_padding',
      [
        'label'     => __('Padding', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::SLIDER,
        'selectors' => [
          '{{WRAPPER}} .eafe-social-icon' => 'padding: {{SIZE}}{{UNIT}};',
        ],
        'default'   => [
          'unit' => 'px',
          'size' => 10,
        ],
        'range'     => [
          'px' => [
            'min' => 0,
            'max' => 50,
          ],
        ],
        'condition' => [
          'view!' => 'default',
        ],
      ]
    );

    $this->add_responsive_control(
      'icon_spacing',
      [
        'label'     => __('Spacing', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::SLIDER,
        'range'     => [
          'px' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'default'   => [
          'size' => 10,
        ],
        'selectors' => [
          '{{WRAPPER}} .eafe-social-icons' => 'gap: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->add_group_control(
      Group_Control_Border::get_type(),
      [
        'name'      => 'image_border',
        'selector'  => '{{WRAPPER}} .eafe-social-icon',
        'condition' => [
          'view' => 'framed',
        ],
      ]
    );

    $this->add_control(
      'border_radius',
      [
        'label'      => __('Border Radius', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors'  => [
          '{{WRAPPER}} .eafe-social-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition'  => [
          'view!' => 'default',
        ],
      ]
    );

    $this->start_controls_tabs('icon_colors');

    $this->start_controls_tab(
      'icon_colors_normal',
      [
        'label' => __('Normal', 'nb-eazy-addons-for-elementor'),
      ]
    );

    $this->add_control(
      'icon_color',
      [
        'label'     => __('Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .eafe-social-icon:not(.elementor-repeater-item-*)'     => 'color: {{VALUE}};',
          '{{WRAPPER}} .eafe-social-icon:not(.elementor-repeater-item-*) svg' => 'fill: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'icon_bg_color',
      [
        'label'     => __('Background Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .eafe-social-icon:not(.elementor-repeater-item-*)' => 'background-color: {{VALUE}};',
        ],
        'condition' => [
          'view!' => 'default',
        ],
      ]
    );

    $this->end_controls_tab();

    $this->start_controls_tab(
      'icon_colors_hover',
      [
        'label' => __('Hover', 'nb-eazy-addons-for-elementor'),
      ]
    );

    $this->add_control(
      'icon_hover_color',
      [
        'label'     => __('Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .eafe-social-icon:not(.elementor-repeater-item-*):hover'     => 'color: {{VALUE}};',
          '{{WRAPPER}} .eafe-social-icon:not(.elementor-repeater-item-*):hover svg' => 'fill: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'icon_hover_bg_color',
      [
        'label'     => __('Background Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .eafe-social-icon:not(.elementor-repeater-item-*):hover' => 'background-color: {{VALUE}};',
        ],
        'condition' => [
          'view!' => 'default',
        ],
      ]
    );

    $this->add_control(
      'icon_hover_border_color',
      [
        'label'     => __('Border Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .eafe-social-icon:not(.elementor-repeater-item-*):hover' => 'border-color: {{VALUE}};',
        ],
        'condition' => [
          'view' => 'framed',
        ],
      ]
    );

    $this->end_controls_tab();

    $this->end_controls_tabs();

    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name'      => 'icon_box_shadow',
        'selector'  => '{{WRAPPER}} .eafe-social-icon',
        'condition' => [
          'view!' => 'default',
        ],
      ]
    );

    $this->end_controls_section();

    // ... rest of the style sections remain the same ...
    // Style Section - Labels
    $this->start_controls_section(
      'section_label_style',
      [
        'label'     => __('Labels', 'nb-eazy-addons-for-elementor'),
        'tab'       => Controls_Manager::TAB_STYLE,
        'condition' => [
          'show_label' => 'yes',
        ],
      ]
    );

    $this->add_control(
      'label_color',
      [
        'label'     => __('Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .eafe-social-label' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'label_hover_color',
      [
        'label'     => __('Hover Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .eafe-social-icon:hover .eafe-social-label' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'label_typography',
        'selector' => '{{WRAPPER}} .eafe-social-label',
      ]
    );

    $this->add_group_control(
      Group_Control_Text_Shadow::get_type(),
      [
        'name'     => 'label_text_shadow',
        'selector' => '{{WRAPPER}} .eafe-social-label',
      ]
    );

    $this->add_responsive_control(
      'label_spacing',
      [
        'label'     => __('Spacing', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::SLIDER,
        'range'     => [
          'px' => [
            'min' => 0,
            'max' => 50,
          ],
        ],
        'selectors' => [
          '{{WRAPPER}} .eafe-social-label' => 'margin-left: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();

    // Style Section - Container
    $this->start_controls_section(
      'section_container_style',
      [
        'label' => __('Container', 'nb-eazy-addons-for-elementor'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_responsive_control(
      'container_padding',
      [
        'label'      => __('Padding', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .eafe-social-icons' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'container_margin',
      [
        'label'      => __('Margin', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .eafe-social-icons' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'container_background',
        'types'    => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .eafe-social-icons',
      ]
    );

    $this->add_group_control(
      Group_Control_Border::get_type(),
      [
        'name'     => 'container_border',
        'selector' => '{{WRAPPER}} .eafe-social-icons',
      ]
    );

    $this->add_control(
      'container_border_radius',
      [
        'label'      => __('Border Radius', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors'  => [
          '{{WRAPPER}} .eafe-social-icons' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name'     => 'container_box_shadow',
        'selector' => '{{WRAPPER}} .eafe-social-icons',
      ]
    );

    $this->end_controls_section();
  }

  protected function render()
  {
    $settings = $this->get_settings_for_display();

    // Include the render file and call the render function
    require_once __DIR__ . '/renders/render-eafe-social-icons-widget.php';
    \EazyAddonsForElementor\Widgets\Renders\render_eafe_social_icons_widget($settings);
  }
}
