<?php

namespace EazyAddonsForElementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class EAFE_Review_Widget extends Widget_Base
{

    public function get_name()
    {
        return EAFE_WIDGET_PREFIX . 'review';
    }

    public function get_title()
    {
        return __('Review', 'nb-eazy-addons-for-elementor');
    }

    public function get_icon()
    {
        return 'eicon-review';
    }

    public function get_categories()
    {
        return ['eazy-addons-for-elementor-category'];
    }

    protected function _register_controls()
    {
        // Review Content Section
        $this->start_controls_section(
            'review_content_section',
            [
                'label' => __('Review Content', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'reviewer_image',
            [
                'label'   => __('Reviewer Image', 'nb-eazy-addons-for-elementor'),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'reviewer_name',
            [
                'label'       => __('Reviewer Name', 'nb-eazy-addons-for-elementor'),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Sarah Johnson', 'nb-eazy-addons-for-elementor'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'reviewer_location',
            [
                'label'   => __('Location/Position', 'nb-eazy-addons-for-elementor'),
                'type'    => Controls_Manager::TEXT,
                'default' => __('New York, USA', 'nb-eazy-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'review_rating',
            [
                'label'   => __('Rating', 'nb-eazy-addons-for-elementor'),
                'type'    => Controls_Manager::SELECT,
                'default' => '5',
                'options' => [
                    '1' => __('1 Star', 'nb-eazy-addons-for-elementor'),
                    '2' => __('2 Stars', 'nb-eazy-addons-for-elementor'),
                    '3' => __('3 Stars', 'nb-eazy-addons-for-elementor'),
                    '4' => __('4 Stars', 'nb-eazy-addons-for-elementor'),
                    '5' => __('5 Stars', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'review_title',
            [
                'label'       => __('Review Title', 'nb-eazy-addons-for-elementor'),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Excellent Service!', 'nb-eazy-addons-for-elementor'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'review_text',
            [
                'label'   => __('Review Text', 'nb-eazy-addons-for-elementor'),
                'type'    => Controls_Manager::TEXTAREA,
                'default' => __('Outstanding experience! The quality exceeded my expectations and the customer service was top-notch. I would definitely recommend this to anyone looking for excellent value.', 'nb-eazy-addons-for-elementor'),
                'rows'    => 5,
            ]
        );

        $this->add_control(
            'show_date',
            [
                'label' => __('Show Date', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('Hide', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'review_date',
            [
                'label'   => __('Review Date', 'nb-eazy-addons-for-elementor'),
                'type'    => Controls_Manager::TEXT,
                'default' => __('December 2024', 'nb-eazy-addons-for-elementor'),
                'condition' => [
                    'show_date' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        // Style Section - General
        $this->start_controls_section(
            'review_general_style_section',
            [
                'label' => __('General Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'background_color',
            [
                'label'     => __('Background Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .eafe-review' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label'      => __('Border Radius', 'nb-eazy-addons-for-elementor'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .eafe-review' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'box_shadow',
                'label'    => __('Box Shadow', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-review',
            ]
        );

        $this->end_controls_section();

        // Style Section - Stars
        $this->start_controls_section(
            'review_stars_style_section',
            [
                'label' => __('Stars Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'stars_color',
            [
                'label'     => __('Stars Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#ffd700',
                'selectors' => [
                    '{{WRAPPER}} .eafe-review-stars .star.filled' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'stars_empty_color',
            [
                'label'     => __('Empty Stars Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#e0e0e0',
                'selectors' => [
                    '{{WRAPPER}} .eafe-review-stars .star.empty' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'stars_size',
            [
                'label'      => __('Stars Size', 'nb-eazy-addons-for-elementor'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .eafe-review-stars .star' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Style Section - Typography
        $this->start_controls_section(
            'review_typography_style_section',
            [
                'label' => __('Typography', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'name_color',
            [
                'label'     => __('Name Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#333333',
                'selectors' => [
                    '{{WRAPPER}} .eafe-review-name' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'name_typography',
                'label'    => __('Name Typography', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-review-name',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => __('Title Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#2c3e50',
                'selectors' => [
                    '{{WRAPPER}} .eafe-review-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'label'    => __('Title Typography', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-review-title',
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label'     => __('Review Text Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#555555',
                'selectors' => [
                    '{{WRAPPER}} .eafe-review-text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'text_typography',
                'label'    => __('Review Text Typography', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-review-text',
            ]
        );

        $this->add_control(
            'meta_color',
            [
                'label'     => __('Meta Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#888888',
                'selectors' => [
                    '{{WRAPPER}} .eafe-review-location, {{WRAPPER}} .eafe-review-date' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        // Include the render file and call the render function
        require_once __DIR__ . '/renders/render-eafe-review-widget.php';
        \EazyAddonsForElementor\Widgets\Renders\render_eafe_review_widget($settings);
    }
}