<?php

namespace EazyAddonsForElementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Text_Shadow;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class EAFE_Number_Widget extends Widget_Base
{

    public function get_name()
    {
        return EAFE_WIDGET_PREFIX . 'number';
    }

    public function get_title()
    {
        return __('Number', 'nb-eazy-addons-for-elementor');
    }

    public function get_icon()
    {
        return 'eicon-counter';
    }

    public function get_categories()
    {
        return ['eazy-addons-for-elementor-category'];
    }

    public function get_keywords() {
        return [ 'number', 'counter', 'stat', 'figure', 'digit' ];
    }

    protected function _register_controls()
    {
        // Content Section
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'number',
            [
                'label'       => __('Number', 'nb-eazy-addons-for-elementor'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => '42',
                'label_block' => true,
            ]
        );

        $this->add_control(
            'number_prefix',
            [
                'label'       => __('Prefix', 'nb-eazy-addons-for-elementor'),
                'type'        => Controls_Manager::TEXT,
                'default'     => '',
                'label_block' => true,
                'placeholder' => '+',
            ]
        );

        $this->add_control(
            'number_suffix',
            [
                'label'       => __('Suffix', 'nb-eazy-addons-for-elementor'),
                'type'        => Controls_Manager::TEXT,
                'default'     => '',
                'label_block' => true,
                'placeholder' => '%',
            ]
        );

        $this->add_control(
            'title',
            [
                'label'       => __('Title', 'nb-eazy-addons-for-elementor'),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Projects Completed', 'nb-eazy-addons-for-elementor'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'description',
            [
                'label'       => __('Description', 'nb-eazy-addons-for-elementor'),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => '',
                'label_block' => true,
            ]
        );

        $this->add_responsive_control(
            'alignment',
            [
                'label' => __('Alignment', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left'   => [ 'title' => __('Left', 'nb-eazy-addons-for-elementor'),   'icon' => 'eicon-text-align-left' ],
                    'center' => [ 'title' => __('Center', 'nb-eazy-addons-for-elementor'), 'icon' => 'eicon-text-align-center' ],
                    'right'  => [ 'title' => __('Right', 'nb-eazy-addons-for-elementor'),  'icon' => 'eicon-text-align-right' ],
                ],
                'default' => 'center',
                'toggle' => true,
                'prefix_class' => 'eafe-align-%s', // Elementor adds this class to the widget wrapper
                'selectors' => [
                    '{{WRAPPER}} .eafe-number-container' => 'text-align: {{VALUE}};', // keeps text aligned too
                ],
            ]
        );


        $this->end_controls_section();

        // Style Section
        $this->start_controls_section(
            'style_section',
            [
                'label' => __('Number Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'number_style',
            [
                'label' => __('Style', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'style-1',
                'options' => [
                    'style-1' => __('Style 1 - Solid Box', 'nb-eazy-addons-for-elementor'),
                    'style-2' => __('Style 2 - Circular Outline', 'nb-eazy-addons-for-elementor'),
                    'style-3' => __('Style 3 - White Box with Shadow', 'nb-eazy-addons-for-elementor'),
                    'style-4' => __('Style 4 - Minimal', 'nb-eazy-addons-for-elementor'),
                    'style-5' => __('Style 5 - Gradient Background', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'number_size',
            [
                'label' => __('Size', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 300,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-number' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'number_style!' => 'style-4',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'number_typography',
                'label' => __('Typography', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-number',
                'fields_options' => [
                    'typography' => [ 'default' => 'custom' ],

                    'font_size' => [
                        'default' => [
                            'size' => 45,
                            'unit' => 'px',
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'number_color',
            [
                'label' => __('Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000000',
                'selectors' => [
                    '{{WRAPPER}} .eafe-number' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'number_text_shadow',
                'label' => __('Text Shadow', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-number',
            ]
        );

        // Style-1: default to SOLID color
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'number_bg_style1',
                'label' => __('Background', 'nb-eazy-addons-for-elementor'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .eafe-number',
                'fields_options' => [
                    'background' => [ 'default' => 'classic' ],
                    'color'      => [ 'default'  => '#6ec1e4' ],
                ],
                'condition' => [
                    'number_style' => 'style-1',
                ],
            ]
        );

// Style-5: default to GRADIENT
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'number_bg_style5',
                'label' => __('Background', 'nb-eazy-addons-for-elementor'),
                'types' => ['gradient', 'classic'],
                'selector' => '{{WRAPPER}} .eafe-number',
                'fields_options' => [
                    // force gradient as the default mode
                    'background'      => [ 'default' => 'gradient' ],
                    'gradient_type'   => [ 'default' => 'linear' ],
                    'gradient_angle'  => [ 'default' => [ 'unit' => 'deg', 'size' => 135 ] ],
                    // first color (stop A)
                    'color'           => [ 'default' => '#6ec1e4' ],
                    'location'        => [ 'default' => [ 'unit' => '%', 'size' => 0 ] ],
                    // second color (stop B)
                    'color_b'         => [ 'default' => '#54595f' ],
                    'location_b'      => [ 'default' => [ 'unit' => '%', 'size' => 100 ] ],
                ],
                'condition' => [
                    'number_style' => 'style-5',
                ],
            ]
        );


        $this->add_control(
            'number_border_color',
            [
                'label' => __('Border Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#6ec1e4',
                'selectors' => [
                    '{{WRAPPER}} .eafe-number' => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'number_style' => 'style-2',
                ],
            ]
        );

        $this->add_control(
            'number_border_style',
            [
                'label' => __('Border Style', 'nb-eazy-addons-for-elementor'),
                'type'  => Controls_Manager::SELECT,
                'default' => 'solid',
                'options' => [
                    'none'   => __('None', 'nb-eazy-addons-for-elementor'),
                    'solid'  => __('Solid', 'nb-eazy-addons-for-elementor'),
                    'dashed' => __('Dashed', 'nb-eazy-addons-for-elementor'),
                    'dotted' => __('Dotted', 'nb-eazy-addons-for-elementor'),
                    'double' => __('Double', 'nb-eazy-addons-for-elementor'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-number' => 'border-style: {{VALUE}};',
                ],
                'condition' => [
                    'number_style' => 'style-2',
                ],
            ]
        );

        $this->add_control(
            'number_border_width',
            [
                'label' => __('Border Width', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 20,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 3,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-number' => 'border-width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'number_style' => 'style-2',
                ],
            ]
        );

        $this->add_control(
            'number_border_radius',
            [
                'label' => __('Border Radius', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 8,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-number' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'number_style!' => ['style-2', 'style-4'],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'number_box_shadow',
                'label' => __('Box Shadow', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-number',
                'fields_options' => [
                    'box_shadow_type' => [ 'default' => 'yes' ],
                    'box_shadow' => [
                        'default' => [
                            'horizontal' => 0,
                            'vertical'   => 12,
                            'blur'       => 32,
                            'spread'     => 0,
                            'color'      => 'rgba(2, 6, 23, 0.12)',
                        ],
                    ],
                ],
                'condition' => [
                    'number_style' => 'style-3',
                ],
            ]
        );

        $this->add_responsive_control(
            'number_margin',
            [
                'label' => __('Margin', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-number' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Prefix & Suffix Style Section
        $this->start_controls_section(
            'prefix_suffix_style_section',
            [
                'label' => __('Prefix & Suffix Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'prefix_suffix_position',
            [
                'label' => __('Position', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'inline',
                'options' => [
                    'inline' => __('Inline with Number', 'nb-eazy-addons-for-elementor'),
                    'above' => __('Above Number', 'nb-eazy-addons-for-elementor'),
                    'below' => __('Below Number', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'prefix_suffix_typography',
                'label' => __('Typography', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-number-prefix, {{WRAPPER}} .eafe-number-suffix',
            ]
        );

        $this->add_control(
            'prefix_suffix_color',
            [
                'label' => __('Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#333333',
                'selectors' => [
                    '{{WRAPPER}} .eafe-number-prefix' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .eafe-number-suffix' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'prefix_spacing',
            [
                'label' => __('Prefix Spacing', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 5,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-number-prefix' => 'margin-right: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'prefix_suffix_position' => 'inline',
                ],
            ]
        );

        $this->add_control(
            'suffix_spacing',
            [
                'label' => __('Suffix Spacing', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 5,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-number-suffix' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'prefix_suffix_position' => 'inline',
                ],
            ]
        );

        $this->add_control(
            'vertical_prefix_spacing',
            [
                'label' => __('Vertical Spacing', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-number-prefix' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .eafe-number-suffix' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'prefix_suffix_position!' => 'inline',
                ],
            ]
        );

        $this->end_controls_section();

        // Title Style Section
        $this->start_controls_section(
            'title_style_section',
            [
                'label' => __('Title Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Typography', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-number-title',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#333333',
                'selectors' => [
                    '{{WRAPPER}} .eafe-number-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_spacing',
            [
                'label' => __('Spacing', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-number-title' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Description Style Section
        $this->start_controls_section(
            'description_style_section',
            [
                'label' => __('Description Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description_typography',
                'label' => __('Typography', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-number-description',
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label' => __('Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#666666',
                'selectors' => [
                    '{{WRAPPER}} .eafe-number-description' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'description_spacing',
            [
                'label' => __('Spacing', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-number-description' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Container Style Section
        $this->start_controls_section(
            'container_style_section',
            [
                'label' => __('Container Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'container_padding',
            [
                'label' => __('Padding', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-number-container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'container_margin',
            [
                'label' => __('Margin', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-number-container' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        // Include the render file and call the render function
        require_once __DIR__ . '/renders/render-eafe-number-widget.php';
        \EazyAddonsForElementor\Widgets\Renders\render_eafe_number_widget($settings);
    }
}