<?php

namespace EazyAddonsForElementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly
}

class EAFE_News_Ticker_Widget extends Widget_Base
{

  public function get_name()
  {
    return EAFE_WIDGET_PREFIX . 'news-ticker';
  }

  public function get_title()
  {
    return __('News Ticker', 'nb-eazy-addons-for-elementor');
  }

  public function get_icon()
  {
    return 'eicon-posts-ticker';
  }

  public function get_categories()
  {
    return ['eazy-addons-for-elementor-category'];
  }

  protected function _register_controls()
  {
    // Content Section - News Source
    $this->start_controls_section(
      'news_source_section',
      [
        'label' => __('News Source', 'nb-eazy-addons-for-elementor'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'news_source',
      [
        'label'   => __('News Source', 'nb-eazy-addons-for-elementor'),
        'type'    => Controls_Manager::SELECT,
        'default' => 'custom',
        'options' => [
          'custom'   => __('Custom Items', 'nb-eazy-addons-for-elementor'),
          'posts'    => __('Recent Posts', 'nb-eazy-addons-for-elementor'),
          'category' => __('Category Posts', 'nb-eazy-addons-for-elementor'),
        ],
      ]
    );

    // Custom Items Repeater
    $repeater = new Repeater();

    $repeater->add_control(
      'news_title',
      [
        'label'       => __('Title', 'nb-eazy-addons-for-elementor'),
        'type'        => Controls_Manager::TEXT,
        'default'     => __('Breaking News Item', 'nb-eazy-addons-for-elementor'),
        'label_block' => true,
      ]
    );

    $repeater->add_control(
      'news_link',
      [
        'label'         => __('Link', 'nb-eazy-addons-for-elementor'),
        'type'          => Controls_Manager::URL,
        'placeholder'   => __('https://your-link.com', 'nb-eazy-addons-for-elementor'),
        'show_external' => true,
        'default'       => [
          'url'         => '',
          'is_external' => false,
          'nofollow'    => false,
        ],
      ]
    );

    $repeater->add_control(
      'news_badge',
      [
        'label'       => __('Badge', 'nb-eazy-addons-for-elementor'),
        'type'        => Controls_Manager::TEXT,
        'placeholder' => __('HOT, NEW, LIVE', 'nb-eazy-addons-for-elementor'),
        'default'     => '',
      ]
    );

    $this->add_control(
      'custom_news_items',
      [
        'label'       => __('Custom News Items', 'nb-eazy-addons-for-elementor'),
        'type'        => Controls_Manager::REPEATER,
        'fields'      => $repeater->get_controls(),
        'default'     => [
          [
            'news_title' => __('Breaking News: Important Announcement', 'nb-eazy-addons-for-elementor'),
            'news_badge' => 'HOT',
          ],
          [
            'news_title' => __('Latest Update: New Features Released', 'nb-eazy-addons-for-elementor'),
            'news_badge' => 'NEW',
          ],
        ],
        'title_field' => '{{{ news_title }}}',
        'condition'   => [
          'news_source' => 'custom',
        ],
      ]
    );

    // Posts Settings
    $this->add_control(
      'posts_count',
      [
        'label'     => __('Number of Posts', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::NUMBER,
        'default'   => 5,
        'condition' => [
          'news_source' => ['posts', 'category'],
        ],
      ]
    );

    $this->add_control(
      'posts_category',
      [
        'label'     => __('Category', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::SELECT2,
        'options'   => $this->get_post_categories(),
        'multiple'  => false,
        'condition' => [
          'news_source' => 'category',
        ],
      ]
    );

    $this->add_control(
      'show_post_date',
      [
        'label'        => __('Show Post Date', 'nb-eazy-addons-for-elementor'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Yes', 'nb-eazy-addons-for-elementor'),
        'label_off'    => __('No', 'nb-eazy-addons-for-elementor'),
        'return_value' => 'yes',
        'default'      => 'no',
        'condition'    => [
          'news_source' => ['posts', 'category'],
        ],
      ]
    );

    $this->add_control(
      'date_format',
      [
        'label'     => __('Date Format', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::SELECT,
        'default'   => 'relative',
        'options'   => [
          'relative' => __('Relative (e.g., 2 hours ago)', 'nb-eazy-addons-for-elementor'),
          'default'  => __('Default Format', 'nb-eazy-addons-for-elementor'),
          'custom'   => __('Custom Format', 'nb-eazy-addons-for-elementor'),
        ],
        'condition' => [
          'news_source'    => ['posts', 'category'],
          'show_post_date' => 'yes',
        ],
      ]
    );

    $this->add_control(
      'custom_date_format',
      [
        'label'     => __('Custom Date Format', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::TEXT,
        'default'   => 'F j, Y',
        'condition' => [
          'news_source'    => ['posts', 'category'],
          'show_post_date' => 'yes',
          'date_format'    => 'custom',
        ],
      ]
    );

    $this->end_controls_section();

    // Content Section - Ticker Settings
    $this->start_controls_section(
      'ticker_settings_section',
      [
        'label' => __('Ticker Settings', 'nb-eazy-addons-for-elementor'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'ticker_style',
      [
        'label'   => __('Ticker Style', 'nb-eazy-addons-for-elementor'),
        'type'    => Controls_Manager::SELECT,
        'default' => 'horizontal',
        'options' => [
          'horizontal' => __('Horizontal Scroll', 'nb-eazy-addons-for-elementor'),
          'vertical'   => __('Vertical Slide', 'nb-eazy-addons-for-elementor'),
          'fade'       => __('Fade Effect', 'nb-eazy-addons-for-elementor'),
        ],
      ]
    );

    $this->add_control(
      'animation_speed',
      [
        'label'   => __('Animation Speed (ms)', 'nb-eazy-addons-for-elementor'),
        'type'    => Controls_Manager::NUMBER,
        'default' => 300,
        'min'     => 100,
        'max'     => 2000,
        'step'    => 50,
      ]
    );

    $this->add_control(
      'autoplay_speed',
      [
        'label'   => __('Autoplay Speed (ms)', 'nb-eazy-addons-for-elementor'),
        'type'    => Controls_Manager::NUMBER,
        'default' => 3000,
        'min'     => 1000,
        'max'     => 10000,
        'step'    => 500,
      ]
    );

    $this->add_control(
      'pause_on_hover',
      [
        'label'        => __('Pause on Hover', 'nb-eazy-addons-for-elementor'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Yes', 'nb-eazy-addons-for-elementor'),
        'label_off'    => __('No', 'nb-eazy-addons-for-elementor'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );

    $this->add_control(
      'show_progress_bar',
      [
        'label'        => __('Show Progress Bar', 'nb-eazy-addons-for-elementor'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Yes', 'nb-eazy-addons-for-elementor'),
        'label_off'    => __('No', 'nb-eazy-addons-for-elementor'),
        'return_value' => 'yes',
        'default'      => 'no',
        'condition'    => [
          'ticker_style' => ['vertical', 'fade'],
        ],
      ]
    );

    $this->add_control(
      'show_controls',
      [
        'label'        => __('Show Controls', 'nb-eazy-addons-for-elementor'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Yes', 'nb-eazy-addons-for-elementor'),
        'label_off'    => __('No', 'nb-eazy-addons-for-elementor'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );

    $this->add_control(
      'label_text',
      [
        'label'       => __('Label Text', 'nb-eazy-addons-for-elementor'),
        'type'        => Controls_Manager::TEXT,
        'default'     => __('Breaking News', 'nb-eazy-addons-for-elementor'),
        'placeholder' => __('Enter label text', 'nb-eazy-addons-for-elementor'),
      ]
    );

    $this->add_control(
      'label_icon',
      [
        'label'   => __('Label Icon', 'nb-eazy-addons-for-elementor'),
        'type'    => Controls_Manager::ICONS,
        'default' => [
          'value'   => 'fas fa-bolt',
          'library' => 'solid',
        ],
      ]
    );

    $this->add_control(
      'item_separator',
      [
        'label'       => __('Item Separator', 'nb-eazy-addons-for-elementor'),
        'type'        => Controls_Manager::TEXT,
        'default'     => '•',
        'placeholder' => __('Enter separator character', 'nb-eazy-addons-for-elementor'),
        'condition'   => [
          'ticker_style' => 'horizontal',
        ],
      ]
    );

    $this->end_controls_section();

    // Style Section - Ticker Container
    $this->start_controls_section(
      'ticker_container_style',
      [
        'label' => __('Ticker Container', 'nb-eazy-addons-for-elementor'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'container_background',
        'types'    => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .eafe-news-ticker',
      ]
    );

    $this->add_group_control(
      Group_Control_Border::get_type(),
      [
        'name'     => 'container_border',
        'selector' => '{{WRAPPER}} .eafe-news-ticker',
      ]
    );

    $this->add_control(
      'container_border_radius',
      [
        'label'      => __('Border Radius', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors'  => [
          '{{WRAPPER}} .eafe-news-ticker' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name'     => 'container_box_shadow',
        'selector' => '{{WRAPPER}} .eafe-news-ticker',
      ]
    );

    $this->add_responsive_control(
      'container_padding',
      [
        'label'      => __('Padding', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .eafe-news-ticker' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'container_margin',
      [
        'label'      => __('Margin', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .eafe-news-ticker' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();

    // Style Section - Label
    $this->start_controls_section(
      'label_style_section',
      [
        'label' => __('Label', 'nb-eazy-addons-for-elementor'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_control(
      'label_background',
      [
        'label'     => __('Background Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .eafe-ticker-label' => 'background-color: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'label_text_color',
      [
        'label'     => __('Text Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .eafe-ticker-label' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'label_typography',
        'selector' => '{{WRAPPER}} .eafe-ticker-label',
      ]
    );

    $this->add_responsive_control(
      'label_padding',
      [
        'label'      => __('Padding', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .eafe-ticker-label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'label_icon_color',
      [
        'label'     => __('Icon Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .eafe-ticker-label i'   => 'color: {{VALUE}};',
          '{{WRAPPER}} .eafe-ticker-label svg' => 'fill: {{VALUE}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'label_icon_spacing',
      [
        'label'      => __('Icon Spacing', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min' => 0,
            'max' => 50,
          ],
        ],
        'selectors'  => [
          '{{WRAPPER}} .eafe-ticker-label i, {{WRAPPER}} .eafe-ticker-label svg' => 'margin-right: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();

    // Style Section - News Items
    $this->start_controls_section(
      'news_items_style_section',
      [
        'label' => __('News Items', 'nb-eazy-addons-for-elementor'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_control(
      'item_text_color',
      [
        'label'     => __('Text Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .eafe-ticker-item' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'item_hover_color',
      [
        'label'     => __('Hover Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .eafe-ticker-item:hover' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'item_typography',
        'selector' => '{{WRAPPER}} .eafe-ticker-item',
      ]
    );

    $this->add_responsive_control(
      'item_spacing',
      [
        'label'      => __('Item Spacing', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors'  => [
          '{{WRAPPER}} .eafe-ticker-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
        ],
        'condition'  => [
          'ticker_style' => ['vertical', 'fade'],
        ],
      ]
    );

    $this->add_control(
      'separator_color',
      [
        'label'     => __('Separator Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .eafe-ticker-separator' => 'color: {{VALUE}};',
        ],
        'condition' => [
          'ticker_style' => 'horizontal',
        ],
      ]
    );

    $this->add_responsive_control(
      'separator_spacing',
      [
        'label'      => __('Separator Spacing', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min' => 0,
            'max' => 50,
          ],
        ],
        'selectors'  => [
          '{{WRAPPER}} .eafe-ticker-separator' => 'margin: 0 {{SIZE}}{{UNIT}};',
        ],
        'condition'  => [
          'ticker_style' => 'horizontal',
        ],
      ]
    );

    $this->end_controls_section();

    // Style Section - Badges
    $this->start_controls_section(
      'badges_style_section',
      [
        'label' => __('Badges', 'nb-eazy-addons-for-elementor'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_control(
      'badge_background',
      [
        'label'     => __('Background Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .eafe-news-badge' => 'background-color: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'badge_text_color',
      [
        'label'     => __('Text Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .eafe-news-badge' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'badge_typography',
        'selector' => '{{WRAPPER}} .eafe-news-badge',
      ]
    );

    $this->add_responsive_control(
      'badge_padding',
      [
        'label'      => __('Padding', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .eafe-news-badge' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'badge_border_radius',
      [
        'label'      => __('Border Radius', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors'  => [
          '{{WRAPPER}} .eafe-news-badge' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'badge_spacing',
      [
        'label'      => __('Spacing', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min' => 0,
            'max' => 50,
          ],
        ],
        'selectors'  => [
          '{{WRAPPER}} .eafe-news-badge' => 'margin-right: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();

    // Style Section - Controls
    $this->start_controls_section(
      'controls_style_section',
      [
        'label'     => __('Controls', 'nb-eazy-addons-for-elementor'),
        'tab'       => Controls_Manager::TAB_STYLE,
        'condition' => [
          'show_controls' => 'yes',
        ],
      ]
    );

    $this->add_control(
      'controls_color',
      [
        'label'     => __('Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .eafe-ticker-controls button' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'controls_hover_color',
      [
        'label'     => __('Hover Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .eafe-ticker-controls button:hover' => 'color: {{VALUE}};',
        ],
      ]
    );

    $this->add_control(
      'controls_background',
      [
        'label'     => __('Background Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .eafe-ticker-controls button' => 'background-color: {{VALUE}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'controls_size',
      [
        'label'      => __('Size', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min' => 10,
            'max' => 50,
          ],
        ],
        'selectors'  => [
          '{{WRAPPER}} .eafe-ticker-controls button' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();

    // Style Section - Progress Bar
    $this->start_controls_section(
      'progress_bar_style_section',
      [
        'label'     => __('Progress Bar', 'nb-eazy-addons-for-elementor'),
        'tab'       => Controls_Manager::TAB_STYLE,
        'condition' => [
          'show_progress_bar' => 'yes',
          'ticker_style'      => ['vertical', 'fade'],
        ],
      ]
    );

    $this->add_control(
      'progress_bar_color',
      [
        'label'     => __('Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .eafe-ticker-progress' => 'background-color: {{VALUE}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'progress_bar_height',
      [
        'label'      => __('Height', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min' => 1,
            'max' => 10,
          ],
        ],
        'selectors'  => [
          '{{WRAPPER}} .eafe-ticker-progress' => 'height: {{SIZE}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();
  }

  /**
   * Get post categories for select control
   */
  private function get_post_categories()
  {
    $categories = get_categories(['hide_empty' => false]);
    $options    = [];

    foreach ($categories as $category) {
      $options[$category->term_id] = $category->name;
    }

    return $options;
  }

  protected function render()
  {
    $settings = $this->get_settings_for_display();

    // Include the render file and call the render function
    require_once __DIR__ . '/renders/render-eafe-news-ticker-widget.php';
    \EazyAddonsForElementor\Widgets\Renders\render_eafe_news_ticker_widget($settings);
  }
}
