<?php

namespace EazyAddonsForElementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class EAFE_Logo_Grid_Widget extends Widget_Base
{

    public function get_name()
    {
        return EAFE_WIDGET_PREFIX . 'logo_grid';
    }

    public function get_title()
    {
        return __('Logo Grid', 'nb-eazy-addons-for-elementor');
    }

    public function get_icon()
    {
        return 'eicon-logo';
    }

    public function get_categories()
    {
        return ['eazy-addons-for-elementor-category'];
    }

    public function get_keywords() {
        return [ 'logo', 'grid', 'clients', 'brands', 'partners', 'showcase', 'carousel', 'slider' ];
    }

    public function get_style_depends() {
        return [ 'swiper', 'eafe-logo-grid' ];
    }

    public function get_script_depends() {
        return [ 'swiper', 'eafe-logo-grid' ];
    }

    protected function register_controls()
    {
        // Content Section
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_style',
            [
                'label' => __('Layout Style', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'style-1',
                'options' => [
                    'style-1' => __('Style 1 - Standard Grid', 'nb-eazy-addons-for-elementor'),
                    'style-2' => __('Style 2 - Bordered Grid', 'nb-eazy-addons-for-elementor'),
                    'style-3' => __('Style 3 - Minimal Grid', 'nb-eazy-addons-for-elementor'),
                    'style-4' => __('Style 4 - Swiper Carousel', 'nb-eazy-addons-for-elementor'),
                    'style-5' => __('Style 5 - Hover Effects', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'logo_image',
            [
                'label'   => __('Logo', 'nb-eazy-addons-for-elementor'),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'logo_name',
            [
                'label'       => __('Name', 'nb-eazy-addons-for-elementor'),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Client Name', 'nb-eazy-addons-for-elementor'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'logo_link',
            [
                'label' => __('Link', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::URL,
                'placeholder' => __('https://client-website.com', 'nb-eazy-addons-for-elementor'),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ]
        );

        $this->add_control(
            'logo_items',
            [
                'label' => __('Logo Items', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'logo_name' => __('Client 1', 'nb-eazy-addons-for-elementor'),
                    ],
                    [
                        'logo_name' => __('Client 2', 'nb-eazy-addons-for-elementor'),
                    ],
                    [
                        'logo_name' => __('Client 3', 'nb-eazy-addons-for-elementor'),
                    ],
                    [
                        'logo_name' => __('Client 4', 'nb-eazy-addons-for-elementor'),
                    ],
                    [
                        'logo_name' => __('Client 5', 'nb-eazy-addons-for-elementor'),
                    ],
                    [
                        'logo_name' => __('Client 6', 'nb-eazy-addons-for-elementor'),
                    ],
                ],
                'title_field' => '{{{ logo_name }}}',
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'logo_size',
                'default' => 'medium',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'columns',
            [
                'label' => __('Columns', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '1' => __('1 Column', 'nb-eazy-addons-for-elementor'),
                    '2' => __('2 Columns', 'nb-eazy-addons-for-elementor'),
                    '3' => __('3 Columns', 'nb-eazy-addons-for-elementor'),
                    '4' => __('4 Columns', 'nb-eazy-addons-for-elementor'),
                    '5' => __('5 Columns', 'nb-eazy-addons-for-elementor'),
                    '6' => __('6 Columns', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'show_tooltip',
            [
                'label' => __('Show Tooltip', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('Hide', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'grayscale_effect',
            [
                'label' => __('Grayscale Effect', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('No', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'layout_style!' => 'style-5',
                ],
            ]
        );

        $this->add_control(
            'hover_effect',
            [
                'label' => __('Hover Effect', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'grow',
                'options' => [
                    'none' => __('None', 'nb-eazy-addons-for-elementor'),
                    'grow' => __('Grow', 'nb-eazy-addons-for-elementor'),
                    'shrink' => __('Shrink', 'nb-eazy-addons-for-elementor'),
                    'float' => __('Float', 'nb-eazy-addons-for-elementor'),
                    'colorize' => __('Colorize', 'nb-eazy-addons-for-elementor'),
                ],
                'condition' => [
                    'layout_style' => 'style-5',
                ],
            ]
        );

        $this->end_controls_section();

        // Carousel Settings Section
        $this->start_controls_section(
            'carousel_section',
            [
                'label' => __('Carousel Settings', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_style' => 'style-4',
                ],
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => __('Autoplay', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('No', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplay_speed',
            [
                'label' => __('Autoplay Speed (ms)', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::NUMBER,
                'default' => 3000,
                'min' => 1000,
                'max' => 10000,
                'step' => 100,
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'loop',
            [
                'label' => __('Infinite Loop', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('No', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_arrows',
            [
                'label' => __('Show Navigation Arrows', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('Hide', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_dots',
            [
                'label' => __('Show Pagination Dots', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('Hide', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'slides_to_scroll',
            [
                'label' => __('Slides to Scroll', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => __('1', 'nb-eazy-addons-for-elementor'),
                    '2' => __('2', 'nb-eazy-addons-for-elementor'),
                    '3' => __('3', 'nb-eazy-addons-for-elementor'),
                    '4' => __('4', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $this->end_controls_section();

        // Grid Style Section
        $this->start_controls_section(
            'grid_style_section',
            [
                'label' => __('Grid Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'alignment',
            [
                'label' => __('Alignment', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'nb-eazy-addons-for-elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'nb-eazy-addons-for-elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'nb-eazy-addons-for-elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .eafe-logo-grid-item' => 'text-align: {{VALUE}}; justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'items_gap',
            [
                'label' => __('Items Gap', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-logo-grid' => 'gap: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .eafe-logo-swiper' => '--swiper-theme-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'item_padding',
            [
                'label' => __('Item Padding', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-logo-grid-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'label' => __('Border', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-logo-grid-item',
                'condition' => [
                    'layout_style' => 'style-2',
                ],
            ]
        );

        $this->add_control(
            'item_border_radius',
            [
                'label' => __('Border Radius', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-logo-grid-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_box_shadow',
                'label' => __('Box Shadow', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-logo-grid-item',
            ]
        );

        $this->add_control(
            'item_background',
            [
                'label' => __('Background Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .eafe-logo-grid-item' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'layout_style' => ['style-2', 'style-3'],
                ],
            ]
        );

        $this->end_controls_section();

        // Logo Style Section
        $this->start_controls_section(
            'logo_style_section',
            [
                'label' => __('Logo Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'logo_max_width',
            [
                'label' => __('Max Width', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 80,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-logo-grid-image' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'logo_opacity',
            [
                'label' => __('Opacity', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0.7,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-logo-grid-image' => 'opacity: {{SIZE}};',
                ],
                'condition' => [
                    'grayscale_effect' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'logo_hover_opacity',
            [
                'label' => __('Hover Opacity', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-logo-grid-item:hover .eafe-logo-grid-image' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->add_control(
            'logo_grayscale',
            [
                'label' => __('Grayscale', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 100,
                        'min' => 0,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-logo-grid-image' => 'filter: grayscale({{SIZE}}%);',
                ],
                'condition' => [
                    'grayscale_effect' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'logo_hover_grayscale',
            [
                'label' => __('Hover Grayscale', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 100,
                        'min' => 0,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-logo-grid-item:hover .eafe-logo-grid-image' => 'filter: grayscale({{SIZE}}%);',
                ],
                'condition' => [
                    'grayscale_effect' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        // Tooltip Style Section
        $this->start_controls_section(
            'tooltip_style_section',
            [
                'label' => __('Tooltip Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_tooltip' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'tooltip_background',
            [
                'label' => __('Background Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#333333',
                'selectors' => [
                    '{{WRAPPER}} .eafe-logo-grid-tooltip' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .eafe-logo-grid-tooltip:after' => 'border-bottom-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'tooltip_color',
            [
                'label' => __('Text Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .eafe-logo-grid-tooltip' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'tooltip_typography',
                'label' => __('Typography', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-logo-grid-tooltip',
            ]
        );

        $this->add_control(
            'tooltip_padding',
            [
                'label' => __('Padding', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-logo-grid-tooltip' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'tooltip_border_radius',
            [
                'label' => __('Border Radius', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-logo-grid-tooltip' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Carousel Navigation Style Section
        $this->start_controls_section(
            'carousel_nav_style_section',
            [
                'label' => __('Carousel Navigation', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout_style' => 'style-4',
                ],
            ]
        );

        $this->add_control(
            'arrows_color',
            [
                'label' => __('Arrows Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#333333',
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-next, {{WRAPPER}} .swiper-button-prev' => 'color: {{VALUE}} !important;',
                ],
                'condition' => [
                    'show_arrows' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'arrows_background',
            [
                'label' => __('Arrows Background', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-next, {{WRAPPER}} .swiper-button-prev' => 'background-color: {{VALUE}} !important;',
                ],
                'condition' => [
                    'show_arrows' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'arrows_hover_color',
            [
                'label' => __('Arrows Hover Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-next:hover, {{WRAPPER}} .swiper-button-prev:hover' => 'color: {{VALUE}} !important;',
                ],
                'condition' => [
                    'show_arrows' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'arrows_hover_background',
            [
                'label' => __('Arrows Hover Background', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#6ec1e4',
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-next:hover, {{WRAPPER}} .swiper-button-prev:hover' => 'background-color: {{VALUE}} !important;',
                ],
                'condition' => [
                    'show_arrows' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'dots_color',
            [
                'label' => __('Dots Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#cccccc',
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination-bullet' => 'background-color: {{VALUE}} !important;',
                ],
                'condition' => [
                    'show_dots' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'dots_active_color',
            [
                'label' => __('Active Dot Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#6ec1e4',
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination-bullet-active' => 'background-color: {{VALUE}} !important;',
                ],
                'condition' => [
                    'show_dots' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        // Container Style Section
        $this->start_controls_section(
            'container_style_section',
            [
                'label' => __('Container Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'container_padding',
            [
                'label' => __('Padding', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-logo-grid-container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'container_margin',
            [
                'label' => __('Margin', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-logo-grid-container' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        // Include the render file and call the render function
        require_once __DIR__ . '/renders/render-eafe-logo-grid-widget.php';
        \EazyAddonsForElementor\Widgets\Renders\render_eafe_logo_grid_widget($settings);
    }
}