<?php

namespace EazyAddonsForElementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class EAFE_Justified_Grid_Widget extends Widget_Base
{

    public function get_name()
    {
        return EAFE_WIDGET_PREFIX . 'justified_grid';
    }

    public function get_title()
    {
        return __('Justified Grid', 'nb-eazy-addons-for-elementor');
    }

    public function get_icon()
    {
        return 'eicon-gallery-justified';
    }

    public function get_categories()
    {
        return ['eazy-addons-for-elementor-category'];
    }

    public function get_keywords() {
        return [ 'justified', 'grid', 'gallery', 'filter', 'masonry', 'portfolio' ];
    }

    public function get_script_depends() {
        return [ 'eafe-justified-grid' ];
    }

    public function get_style_depends() {
        return [ 'eafe-justified-grid' ];
    }

    protected function _register_controls()
    {
        // Content Section
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_style',
            [
                'label' => __('Layout Style', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'style-1',
                'options' => [
                    'style-1' => __('Style 1 - Multi Category with Filter', 'nb-eazy-addons-for-elementor'),
                    'style-2' => __('Style 2 - Justified Grid without Filter', 'nb-eazy-addons-for-elementor'),
                    'style-3' => __('Style 3 - Justified Grid without Gutter', 'nb-eazy-addons-for-elementor'),
                    'style-4' => __('Style 4 - Minimal Full Width', 'nb-eazy-addons-for-elementor'),
                    'style-5' => __('Style 5 - Full Width Images', 'nb-eazy-addons-for-elementor'),
                    'style-6' => __('Style 6 - Masonry Grid', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'image',
            [
                'label'   => __('Image', 'nb-eazy-addons-for-elementor'),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label'       => __('Title', 'nb-eazy-addons-for-elementor'),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Image Title', 'nb-eazy-addons-for-elementor'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'description',
            [
                'label'       => __('Description', 'nb-eazy-addons-for-elementor'),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __('Image description text goes here', 'nb-eazy-addons-for-elementor'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'category',
            [
                'label'       => __('Category', 'nb-eazy-addons-for-elementor'),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Category 1', 'nb-eazy-addons-for-elementor'),
                'label_block' => true,
                'description' => __('Separate multiple categories with commas', 'nb-eazy-addons-for-elementor'),
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => __('Link', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'nb-eazy-addons-for-elementor'),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ]
        );

        $this->add_control(
            'gallery_items',
            [
                'label' => __('Gallery Items', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title' => __('Project 1', 'nb-eazy-addons-for-elementor'),
                        'category' => __('Design, Branding', 'nb-eazy-addons-for-elementor'),
                    ],
                    [
                        'title' => __('Project 2', 'nb-eazy-addons-for-elementor'),
                        'category' => __('Development', 'nb-eazy-addons-for-elementor'),
                    ],
                    [
                        'title' => __('Project 3', 'nb-eazy-addons-for-elementor'),
                        'category' => __('Design, Photography', 'nb-eazy-addons-for-elementor'),
                    ],
                    [
                        'title' => __('Project 4', 'nb-eazy-addons-for-elementor'),
                        'category' => __('Branding', 'nb-eazy-addons-for-elementor'),
                    ],
                    [
                        'title' => __('Project 5', 'nb-eazy-addons-for-elementor'),
                        'category' => __('Development, Photography', 'nb-eazy-addons-for-elementor'),
                    ],
                    [
                        'title' => __('Project 6', 'nb-eazy-addons-for-elementor'),
                        'category' => __('Design', 'nb-eazy-addons-for-elementor'),
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail_size',
                'default' => 'large',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'show_filter',
            [
                'label' => __('Show Filter', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('Hide', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'layout_style' => ['style-1', 'style-6'],
                ],
            ]
        );

        $this->add_control(
            'show_all_filter',
            [
                'label' => __('Show "All" Filter', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('Hide', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'layout_style' => ['style-1', 'style-6'],
                    'show_filter' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'all_filter_text',
            [
                'label' => __('"All" Filter Text', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => __('All', 'nb-eazy-addons-for-elementor'),
                'condition' => [
                    'layout_style' => ['style-1', 'style-6'],
                    'show_filter' => 'yes',
                    'show_all_filter' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'show_caption',
            [
                'label' => __('Show Caption', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('Hide', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'caption_style',
            [
                'label' => __('Caption Style', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'hover',
                'options' => [
                    'hover' => __('On Hover', 'nb-eazy-addons-for-elementor'),
                    'always' => __('Always Visible', 'nb-eazy-addons-for-elementor'),
                ],
                'condition' => [
                    'show_caption' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'image_height',
            [
                'label' => __('Image Height', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 100,
                        'max' => 800,
                        'step' => 10,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 300,
                ],
                'condition' => [
                    'layout_style' => ['style-2', 'style-3', 'style-4', 'style-5'],
                ],
            ]
        );

        $this->add_control(
            'gutter_size',
            [
                'label' => __('Gutter Size', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'condition' => [
                    'layout_style!' => 'style-3',
                ],
            ]
        );

        $this->add_control(
            'masonry_columns',
            [
                'label' => __('Masonry Columns', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => '3',
                'options' => [
                    '2' => __('2 Columns', 'nb-eazy-addons-for-elementor'),
                    '3' => __('3 Columns', 'nb-eazy-addons-for-elementor'),
                    '4' => __('4 Columns', 'nb-eazy-addons-for-elementor'),
                    '5' => __('5 Columns', 'nb-eazy-addons-for-elementor'),
                ],
                'condition' => [
                    'layout_style' => 'style-6',
                ],
            ]
        );

        $this->end_controls_section();

        // Filter Style Section
        $this->start_controls_section(
            'filter_style_section',
            [
                'label' => __('Filter Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout_style' => ['style-1', 'style-6'],
                    'show_filter' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'filter_alignment',
            [
                'label' => __('Alignment', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'nb-eazy-addons-for-elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'nb-eazy-addons-for-elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'nb-eazy-addons-for-elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .eafe-justified-grid-filter' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'filter_typography',
                'label' => __('Typography', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-justified-grid-filter button',
            ]
        );

        $this->add_control(
            'filter_spacing',
            [
                'label' => __('Spacing', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-justified-grid-filter' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'filter_item_spacing',
            [
                'label' => __('Item Spacing', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-justified-grid-filter button:not(:last-child)' => 'margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('filter_style_tabs');

        $this->start_controls_tab(
            'filter_normal',
            [
                'label' => __('Normal', 'nb-eazy-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'filter_color',
            [
                'label' => __('Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#333333',
                'selectors' => [
                    '{{WRAPPER}} .eafe-justified-grid-filter button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'filter_background',
            [
                'label' => __('Background', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => 'transparent',
                'selectors' => [
                    '{{WRAPPER}} .eafe-justified-grid-filter button' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'filter_border',
                'label' => __('Border', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-justified-grid-filter button',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'filter_hover',
            [
                'label' => __('Hover', 'nb-eazy-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'filter_color_hover',
            [
                'label' => __('Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .eafe-justified-grid-filter button:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'filter_background_hover',
            [
                'label' => __('Background', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#6ec1e4',
                'selectors' => [
                    '{{WRAPPER}} .eafe-justified-grid-filter button:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'filter_border_color_hover',
            [
                'label' => __('Border Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#6ec1e4',
                'selectors' => [
                    '{{WRAPPER}} .eafe-justified-grid-filter button:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'filter_active',
            [
                'label' => __('Active', 'nb-eazy-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'filter_color_active',
            [
                'label' => __('Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .eafe-justified-grid-filter button.active' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'filter_background_active',
            [
                'label' => __('Background', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#6ec1e4',
                'selectors' => [
                    '{{WRAPPER}} .eafe-justified-grid-filter button.active' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'filter_border_color_active',
            [
                'label' => __('Border Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#6ec1e4',
                'selectors' => [
                    '{{WRAPPER}} .eafe-justified-grid-filter button.active' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'filter_border_radius',
            [
                'label' => __('Border Radius', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-justified-grid-filter button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'filter_padding',
            [
                'label' => __('Padding', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-justified-grid-filter button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Image Style Section
        $this->start_controls_section(
            'image_style_section',
            [
                'label' => __('Image Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'image_border_radius',
            [
                'label' => __('Border Radius', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-justified-grid-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .eafe-justified-grid-item img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'layout_style!' => 'style-3',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'image_box_shadow',
                'label' => __('Box Shadow', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-justified-grid-item',
                'condition' => [
                    'layout_style!' => ['style-3', 'style-4'],
                ],
            ]
        );

        $this->add_control(
            'image_hover_effect',
            [
                'label' => __('Hover Effect', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'zoom',
                'options' => [
                    'none' => __('None', 'nb-eazy-addons-for-elementor'),
                    'zoom' => __('Zoom', 'nb-eazy-addons-for-elementor'),
                    'rotate' => __('Rotate', 'nb-eazy-addons-for-elementor'),
                    'grayscale' => __('Grayscale', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'image_opacity',
            [
                'label' => __('Opacity', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-justified-grid-item img' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->add_control(
            'image_hover_opacity',
            [
                'label' => __('Hover Opacity', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-justified-grid-item:hover img' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Caption Style Section
        $this->start_controls_section(
            'caption_style_section',
            [
                'label' => __('Caption Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_caption' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'caption_background',
            [
                'label' => __('Background', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => 'rgba(0, 0, 0, 0.7)',
                'selectors' => [
                    '{{WRAPPER}} .eafe-justified-grid-caption' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'caption_padding',
            [
                'label' => __('Padding', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-justified-grid-caption' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_style_heading',
            [
                'label' => __('Title', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .eafe-justified-grid-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Typography', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-justified-grid-title',
            ]
        );

        $this->add_control(
            'title_spacing',
            [
                'label' => __('Spacing', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-justified-grid-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'description_style_heading',
            [
                'label' => __('Description', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label' => __('Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#f0f0f0',
                'selectors' => [
                    '{{WRAPPER}} .eafe-justified-grid-description' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description_typography',
                'label' => __('Typography', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-justified-grid-description',
            ]
        );

        $this->end_controls_section();

        // Container Style Section
        $this->start_controls_section(
            'container_style_section',
            [
                'label' => __('Container Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'container_padding',
            [
                'label' => __('Padding', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-justified-grid-container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'container_margin',
            [
                'label' => __('Margin', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-justified-grid-container' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        // Include the render file and call the render function
        require_once __DIR__ . '/renders/render-eafe-justified-grid-widget.php';
        \EazyAddonsForElementor\Widgets\Renders\render_eafe_justified_grid_widget($settings);
    }
}