<?php

namespace EazyAddonsForElementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class EAFE_Image_Comparison_Widget extends Widget_Base
{

    public function get_name()
    {
        return EAFE_WIDGET_PREFIX . 'image_comparison';
    }

    public function get_title()
    {
        return __('Image Comparison', 'nb-eazy-addons-for-elementor');
    }

    public function get_icon()
    {
        return 'eicon-image-before-after';
    }

    public function get_categories()
    {
        return ['eazy-addons-for-elementor-category'];
    }

    public function get_keywords()
    {
        return ['comparison', 'before after', 'slider', 'image', 'photo'];
    }

    public function get_script_depends()
    {
        return ['eafe-image-comparison'];
    }

    protected function _register_controls()
    {
        // Image Comparison Content Section
        $this->start_controls_section(
            'image_comparison_content_section',
            [
                'label' => __('Image Comparison', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'before_image',
            [
                'label'   => __('Before Image', 'nb-eazy-addons-for-elementor'),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'after_image',
            [
                'label'   => __('After Image', 'nb-eazy-addons-for-elementor'),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'before_label',
            [
                'label'       => __('Before Label', 'nb-eazy-addons-for-elementor'),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Before', 'nb-eazy-addons-for-elementor'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'after_label',
            [
                'label'       => __('After Label', 'nb-eazy-addons-for-elementor'),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('After', 'nb-eazy-addons-for-elementor'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'show_percentage',
            [
                'label'        => __('Show Percentage', 'nb-eazy-addons-for-elementor'),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __('Show', 'nb-eazy-addons-for-elementor'),
                'label_off'    => __('Hide', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $this->add_control(
            'default_position',
            [
                'label'      => __('Default Slider Position (%)', 'nb-eazy-addons-for-elementor'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['%'],
                'range'      => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default'    => [
                    'unit' => '%',
                    'size' => 50,
                ],
            ]
        );

        $this->add_control(
            'orientation',
            [
                'label'   => __('Orientation', 'nb-eazy-addons-for-elementor'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'horizontal',
                'options' => [
                    'horizontal' => __('Horizontal', 'nb-eazy-addons-for-elementor'),
                    'vertical'   => __('Vertical', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'interaction_mode',
            [
                'label'   => __('Interaction Mode', 'nb-eazy-addons-for-elementor'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'drag',
                'options' => [
                    'drag'  => __('Drag Handle', 'nb-eazy-addons-for-elementor'),
                    'hover' => __('Hover', 'nb-eazy-addons-for-elementor'),
                    'both'  => __('Both', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'hover_sensitivity',
            [
                'label'      => __('Hover Sensitivity', 'nb-eazy-addons-for-elementor'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => 1,
                        'max' => 50,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'condition'  => [
                    'interaction_mode' => ['hover', 'both'],
                ],
            ]
        );

        $this->add_control(
            'show_controls',
            [
                'label'        => __('Show Control Buttons', 'nb-eazy-addons-for-elementor'),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __('Show', 'nb-eazy-addons-for-elementor'),
                'label_off'    => __('Hide', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $this->add_control(
            'add_caption',
            [
                'label'        => __('Add Caption', 'nb-eazy-addons-for-elementor'),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __('Yes', 'nb-eazy-addons-for-elementor'),
                'label_off'    => __('No', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );

        $this->add_control(
            'caption_text',
            [
                'label'     => __('Caption', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::TEXTAREA,
                'default'   => __('Image comparison showing the transformation', 'nb-eazy-addons-for-elementor'),
                'condition' => [
                    'add_caption' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        // Control Buttons Section
        $this->start_controls_section(
            'control_buttons_section',
            [
                'label'     => __('Control Buttons', 'nb-eazy-addons-for-elementor'),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'show_controls' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'show_before_button',
            [
                'label'        => __('Show "Before" Button', 'nb-eazy-addons-for-elementor'),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __('Show', 'nb-eazy-addons-for-elementor'),
                'label_off'    => __('Hide', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $this->add_control(
            'before_button_text',
            [
                'label'     => __('Before Button Text', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::TEXT,
                'default'   => __('View Before', 'nb-eazy-addons-for-elementor'),
                'condition' => [
                    'show_before_button' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'show_after_button',
            [
                'label'        => __('Show "After" Button', 'nb-eazy-addons-for-elementor'),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __('Show', 'nb-eazy-addons-for-elementor'),
                'label_off'    => __('Hide', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $this->add_control(
            'after_button_text',
            [
                'label'     => __('After Button Text', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::TEXT,
                'default'   => __('View After', 'nb-eazy-addons-for-elementor'),
                'condition' => [
                    'show_after_button' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'show_reset_button',
            [
                'label'        => __('Show Reset Button', 'nb-eazy-addons-for-elementor'),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __('Show', 'nb-eazy-addons-for-elementor'),
                'label_off'    => __('Hide', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $this->add_control(
            'reset_button_text',
            [
                'label'     => __('Reset Button Text', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::TEXT,
                'default'   => __('Reset', 'nb-eazy-addons-for-elementor'),
                'condition' => [
                    'show_reset_button' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        // Style Section
        $this->start_controls_section(
            'image_comparison_style_section',
            [
                'label' => __('Slider Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'handle_color',
            [
                'label'     => __('Handle Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .eafe-image-comparison-handle'         => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .eafe-image-comparison-handle::before' => 'background-color: {{VALUE}}; border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'handle_icon_color',
            [
                'label'     => __('Handle Icon Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#3498db',
                'selectors' => [
                    '{{WRAPPER}} .eafe-image-comparison-handle::after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'badge_before_color',
            [
                'label'     => __('Before Badge Background', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => 'rgba(44, 62, 80, 0.85)',
                'selectors' => [
                    '{{WRAPPER}} .eafe-badge-before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'badge_after_color',
            [
                'label'     => __('After Badge Background', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => 'rgba(231, 76, 60, 0.85)',
                'selectors' => [
                    '{{WRAPPER}} .eafe-badge-after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'badge_text_color',
            [
                'label'     => __('Badge Text Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .eafe-badge' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'percentage_color',
            [
                'label'     => __('Percentage Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .eafe-percentage' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'percentage_background',
            [
                'label'     => __('Percentage Background', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => 'rgba(0, 0, 0, 0.7)',
                'selectors' => [
                    '{{WRAPPER}} .eafe-percentage' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'box_shadow',
                'label'    => __('Box Shadow', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-image-comparison-container',
            ]
        );

        $this->add_responsive_control(
            'border_radius',
            [
                'label'      => __('Border Radius', 'nb-eazy-addons-for-elementor'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .eafe-image-comparison-container' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Control Buttons Style Section
        $this->start_controls_section(
            'control_buttons_style_section',
            [
                'label'     => __('Control Buttons Style', 'nb-eazy-addons-for-elementor'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_controls' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'buttons_alignment',
            [
                'label'     => __('Alignment', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => __('Left', 'nb-eazy-addons-for-elementor'),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'nb-eazy-addons-for-elementor'),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => __('Right', 'nb-eazy-addons-for-elementor'),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'default'   => 'center',
                'selectors' => [
                    '{{WRAPPER}} .eafe-comparison-controls' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'button_typography',
                'label'    => __('Typography', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-comparison-controls button',
            ]
        );

        $this->start_controls_tabs('control_buttons_tabs');

        $this->start_controls_tab(
            'control_buttons_normal',
            [
                'label' => __('Normal', 'nb-eazy-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'button_text_color',
            [
                'label'     => __('Text Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .eafe-comparison-controls button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_background_color',
            [
                'label'     => __('Background Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#3498db',
                'selectors' => [
                    '{{WRAPPER}} .eafe-comparison-controls button' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'control_buttons_hover',
            [
                'label' => __('Hover', 'nb-eazy-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'button_text_color_hover',
            [
                'label'     => __('Text Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .eafe-comparison-controls button:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_background_color_hover',
            [
                'label'     => __('Background Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#2980b9',
                'selectors' => [
                    '{{WRAPPER}} .eafe-comparison-controls button:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'      => 'button_border',
                'selector'  => '{{WRAPPER}} .eafe-comparison-controls button',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'button_border_radius',
            [
                'label'      => __('Border Radius', 'nb-eazy-addons-for-elementor'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .eafe-comparison-controls button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'button_box_shadow',
                'selector' => '{{WRAPPER}} .eafe-comparison-controls button',
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label'      => __('Padding', 'nb-eazy-addons-for-elementor'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .eafe-comparison-controls button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_margin',
            [
                'label'      => __('Margin', 'nb-eazy-addons-for-elementor'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .eafe-comparison-controls button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Caption Style Section
        $this->start_controls_section(
            'caption_style_section',
            [
                'label'     => __('Caption Style', 'nb-eazy-addons-for-elementor'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'add_caption' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'caption_color',
            [
                'label'     => __('Text Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#7f8c8d',
                'selectors' => [
                    '{{WRAPPER}} .eafe-comparison-caption' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'caption_typography',
                'label'    => __('Typography', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-comparison-caption',
            ]
        );

        $this->add_responsive_control(
            'caption_alignment',
            [
                'label'     => __('Alignment', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => __('Left', 'nb-eazy-addons-for-elementor'),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'nb-eazy-addons-for-elementor'),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => __('Right', 'nb-eazy-addons-for-elementor'),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'default'   => 'center',
                'selectors' => [
                    '{{WRAPPER}} .eafe-comparison-caption' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'caption_margin',
            [
                'label'      => __('Margin', 'nb-eazy-addons-for-elementor'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .eafe-comparison-caption' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        // Include the render file and call the render function
        require_once __DIR__ . '/renders/render-eafe-image-comparison-widget.php';
        \EazyAddonsForElementor\Widgets\Renders\render_eafe_image_comparison_widget($settings);
    }
}
