<?php

namespace EazyAddonsForElementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class EAFE_Icon_Box_Widget extends Widget_Base
{

    public function get_name()
    {
        return EAFE_WIDGET_PREFIX . 'icon_box';
    }

    public function get_title()
    {
        return __('Icon Box', 'nb-eazy-addons-for-elementor');
    }

    public function get_icon()
    {
        return 'eicon-icon-box';
    }

    public function get_categories()
    {
        return ['eazy-addons-for-elementor-category'];
    }

    public function get_keywords()
    {
        return ['icon', 'box', 'info', 'feature', 'service'];
    }

    protected function _register_controls()
    {
        // Template Selection Section
        $this->start_controls_section(
            'icon_box_template_section',
            [
                'label' => __('Template', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'template_style',
            [
                'label'   => __('Choose Template', 'nb-eazy-addons-for-elementor'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'template-1',
                'options' => [
                    'template-1' => __('Design 1 - Outline box with white background', 'nb-eazy-addons-for-elementor'),
                    'template-2' => __('Design 2 - Borderless background with different content color', 'nb-eazy-addons-for-elementor'),
                    'template-3' => __('Design 3 - Multicolor badge with high-level customization', 'nb-eazy-addons-for-elementor'),
                    'template-4' => __('Design 4 - Multi-color badge with offset customization', 'nb-eazy-addons-for-elementor'),
                    'template-5' => __('Design 5 - Gradient background color', 'nb-eazy-addons-for-elementor'),
                    'template-6' => __('Design 6 - Circular background and badge', 'nb-eazy-addons-for-elementor'),
                    'template-7' => __('Design 7 - Use of image as background', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $this->end_controls_section();

        // Content Section
        $this->start_controls_section(
            'icon_box_content_section',
            [
                'label' => __('Content', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'icon_type',
            [
                'label'   => __('Icon Type', 'nb-eazy-addons-for-elementor'),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'icon'  => [
                        'title' => __('Icon', 'nb-eazy-addons-for-elementor'),
                        'icon'  => 'eicon-star',
                    ],
                    'image' => [
                        'title' => __('Image', 'nb-eazy-addons-for-elementor'),
                        'icon'  => 'eicon-image',
                    ],
                ],
                'default' => 'icon',
                'toggle'  => true,
            ]
        );

        $this->add_control(
            'icon',
            [
                'label'     => __('Icon', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::ICONS,
                'default'   => [
                    'value'   => 'fas fa-star',
                    'library' => 'solid',
                ],
                'condition' => [
                    'icon_type' => 'icon',
                ],
            ]
        );

        $this->add_control(
            'icon_image',
            [
                'label'     => __('Choose Image', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::MEDIA,
                'default'   => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image',
                ],
            ]
        );

        $this->add_control(
            'icon_position',
            [
                'label'   => __('Icon Position', 'nb-eazy-addons-for-elementor'),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'top'    => [
                        'title' => __('Top', 'nb-eazy-addons-for-elementor'),
                        'icon'  => 'eicon-v-align-top',
                    ],
                    'left'   => [
                        'title' => __('Left', 'nb-eazy-addons-for-elementor'),
                        'icon'  => 'eicon-h-align-left',
                    ],
                    'right'  => [
                        'title' => __('Right', 'nb-eazy-addons-for-elementor'),
                        'icon'  => 'eicon-h-align-right',
                    ],
                    'bottom' => [
                        'title' => __('Bottom', 'nb-eazy-addons-for-elementor'),
                        'icon'  => 'eicon-v-align-bottom',
                    ],
                ],
                'default' => 'top',
                'toggle'  => false,
            ]
        );

        $this->add_control(
            'title',
            [
                'label'       => __('Title', 'nb-eazy-addons-for-elementor'),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Icon Box Title', 'nb-eazy-addons-for-elementor'),
                'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label'   => __('Title HTML Tag', 'nb-eazy-addons-for-elementor'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'h1'   => 'H1',
                    'h2'   => 'H2',
                    'h3'   => 'H3',
                    'h4'   => 'H4',
                    'h5'   => 'H5',
                    'h6'   => 'H6',
                    'div'  => 'div',
                    'span' => 'span',
                    'p'    => 'p',
                ],
                'default' => 'h3',
            ]
        );

        $this->add_control(
            'description',
            [
                'label'   => __('Description', 'nb-eazy-addons-for-elementor'),
                'type'    => Controls_Manager::TEXTAREA,
                'default' => __('Add a short description for the icon box. This text will help users understand what this feature is about.', 'nb-eazy-addons-for-elementor'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'enable_button',
            [
                'label'        => __('Enable Button', 'nb-eazy-addons-for-elementor'),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __('Yes', 'nb-eazy-addons-for-elementor'),
                'label_off'    => __('No', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label'     => __('Button Text', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::TEXT,
                'default'   => __('Learn More', 'nb-eazy-addons-for-elementor'),
                'condition' => [
                    'enable_button' => 'yes',
                ],
                'dynamic'   => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'button_url',
            [
                'label'       => __('Button URL', 'nb-eazy-addons-for-elementor'),
                'type'        => Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'nb-eazy-addons-for-elementor'),
                'default'     => [
                    'url'         => '#',
                    'is_external' => false,
                ],
                'condition'   => [
                    'enable_button' => 'yes',
                ],
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'link_entire_box',
            [
                'label'        => __('Link Entire Box', 'nb-eazy-addons-for-elementor'),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __('Yes', 'nb-eazy-addons-for-elementor'),
                'label_off'    => __('No', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default'      => 'no',
                'condition'    => [
                    'enable_button!' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'box_url',
            [
                'label'       => __('Box URL', 'nb-eazy-addons-for-elementor'),
                'type'        => Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'nb-eazy-addons-for-elementor'),
                'default'     => [
                    'url'         => '#',
                    'is_external' => false,
                ],
                'condition'   => [
                    'link_entire_box' => 'yes',
                ],
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        $this->end_controls_section();

        // Background Image Section (for template 7)
        $this->start_controls_section(
            'background_image_section',
            [
                'label'     => __('Background Image', 'nb-eazy-addons-for-elementor'),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'template_style' => 'template-7',
                ],
            ]
        );

        $this->add_control(
            'background_image',
            [
                'label'   => __('Choose Image', 'nb-eazy-addons-for-elementor'),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'background_overlay',
            [
                'label'        => __('Background Overlay', 'nb-eazy-addons-for-elementor'),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __('Yes', 'nb-eazy-addons-for-elementor'),
                'label_off'    => __('No', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $this->add_control(
            'overlay_color',
            [
                'label'     => __('Overlay Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => 'rgba(0,0,0,0.5)',
                'condition' => [
                    'background_overlay' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-icon-box.template-7::before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->register_style_controls();
    }

    protected function register_style_controls()
    {
        // Box Style Section
        $this->start_controls_section(
            'icon_box_style_section',
            [
                'label' => __('Box Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'text_align',
            [
                'label'     => __('Alignment', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => __('Left', 'nb-eazy-addons-for-elementor'),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'nb-eazy-addons-for-elementor'),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => __('Right', 'nb-eazy-addons-for-elementor'),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'default'   => 'center',
                'selectors' => [
                    '{{WRAPPER}} .eafe-icon-box' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'label'      => __('Padding', 'nb-eazy-addons-for-elementor'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'default'    => [
                    'top'      => '30',
                    'right'    => '30',
                    'bottom'   => '30',
                    'left'     => '30',
                    'unit'     => 'px',
                    'isLinked' => true,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .eafe-icon-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_margin',
            [
                'label'      => __('Margin', 'nb-eazy-addons-for-elementor'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .eafe-icon-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'box_background',
                'label'     => __('Background', 'nb-eazy-addons-for-elementor'),
                'types'     => ['classic', 'gradient'],
                'selector'  => '{{WRAPPER}} .eafe-icon-box',
                'condition' => [
                    'template_style!' => 'template-7',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'box_border',
                'label'    => __('Border', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-icon-box',
            ]
        );

        $this->add_responsive_control(
            'box_border_radius',
            [
                'label'      => __('Border Radius', 'nb-eazy-addons-for-elementor'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .eafe-icon-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'box_shadow',
                'label'    => __('Box Shadow', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-icon-box',
            ]
        );

        $this->end_controls_section();

        // Icon Style Section
        $this->start_controls_section(
            'icon_style_section',
            [
                'label' => __('Icon Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label'      => __('Icon Size', 'nb-eazy-addons-for-elementor'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range'      => [
                    'px' => [
                        'min'  => 10,
                        'max'  => 200,
                        'step' => 1,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .eafe-icon-box-icon'     => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .eafe-icon-box-icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label'     => __('Icon Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#ff6f61',
                'selectors' => [
                    '{{WRAPPER}} .eafe-icon-box-icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .eafe-icon-box-icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_background_color',
            [
                'label'     => __('Icon Background Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .eafe-icon-box-icon' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'template_style' => ['template-3', 'template-4', 'template-6'],
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_padding',
            [
                'label'      => __('Icon Padding', 'nb-eazy-addons-for-elementor'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .eafe-icon-box-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition'  => [
                    'template_style' => ['template-3', 'template-4', 'template-6'],
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_margin',
            [
                'label'      => __('Icon Margin', 'nb-eazy-addons-for-elementor'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'default'    => [
                    'bottom' => '20',
                    'unit'   => 'px',
                ],
                'selectors'  => [
                    '{{WRAPPER}} .eafe-icon-box-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Title Style Section
        $this->start_controls_section(
            'title_style_section',
            [
                'label' => __('Title Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => __('Title Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#333333',
                'selectors' => [
                    '{{WRAPPER}} .eafe-icon-box-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'label'    => __('Typography', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-icon-box-title',
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label'      => __('Title Margin', 'nb-eazy-addons-for-elementor'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'default'    => [
                    'bottom' => '15',
                    'unit'   => 'px',
                ],
                'selectors'  => [
                    '{{WRAPPER}} .eafe-icon-box-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Description Style Section
        $this->start_controls_section(
            'description_style_section',
            [
                'label' => __('Description Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label'     => __('Description Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#666666',
                'selectors' => [
                    '{{WRAPPER}} .eafe-icon-box-description' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'description_typography',
                'label'    => __('Typography', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-icon-box-description',
            ]
        );

        $this->add_responsive_control(
            'description_margin',
            [
                'label'      => __('Description Margin', 'nb-eazy-addons-for-elementor'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'default'    => [
                    'bottom' => '20',
                    'unit'   => 'px',
                ],
                'selectors'  => [
                    '{{WRAPPER}} .eafe-icon-box-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Button Style Section
        $this->start_controls_section(
            'button_style_section',
            [
                'label'     => __('Button Style', 'nb-eazy-addons-for-elementor'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'enable_button' => 'yes',
                ],
            ]
        );

        $this->start_controls_tabs('button_style_tabs');

        $this->start_controls_tab(
            'button_normal_tab',
            [
                'label' => __('Normal', 'nb-eazy-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label'     => __('Button Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .eafe-icon-box-button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_background',
            [
                'label'     => __('Button Background', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#ff6f61',
                'selectors' => [
                    '{{WRAPPER}} .eafe-icon-box-button' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_hover_tab',
            [
                'label' => __('Hover', 'nb-eazy-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'button_hover_color',
            [
                'label'     => __('Button Hover Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .eafe-icon-box-button:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_hover_background',
            [
                'label'     => __('Button Hover Background', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#e65b50',
                'selectors' => [
                    '{{WRAPPER}} .eafe-icon-box-button:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'button_typography',
                'label'     => __('Typography', 'nb-eazy-addons-for-elementor'),
                'selector'  => '{{WRAPPER}} .eafe-icon-box-button',
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label'      => __('Button Padding', 'nb-eazy-addons-for-elementor'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'default'    => [
                    'top'      => '12',
                    'right'    => '24',
                    'bottom'   => '12',
                    'left'     => '24',
                    'unit'     => 'px',
                    'isLinked' => false,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .eafe-icon-box-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_margin',
            [
                'label'      => __('Button Margin', 'nb-eazy-addons-for-elementor'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .eafe-icon-box-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'button_border',
                'label'    => __('Border', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-icon-box-button',
            ]
        );

        $this->add_responsive_control(
            'button_border_radius',
            [
                'label'      => __('Border Radius', 'nb-eazy-addons-for-elementor'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default'    => [
                    'top'      => '4',
                    'right'    => '4',
                    'bottom'   => '4',
                    'left'     => '4',
                    'unit'     => 'px',
                    'isLinked' => true,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .eafe-icon-box-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        // Include the render file and call the render function
        require_once __DIR__ . '/renders/render-eafe-icon-box-widget.php';
        \EazyAddonsForElementor\Widgets\Renders\render_eafe_icon_box_widget($settings);
    }

    protected function content_template()
    {
        ?>
        <#
        var iconHTML = '';
        if ( settings.icon_type === 'icon' && settings.icon ) {
        iconHTML = elementor.helpers.renderIcon( view, settings.icon, { 'aria-hidden': true }, 'i' , 'object' );
        }
        var target = settings.button_url.is_external ? ' target="_blank"' : '';
        var boxTarget = settings.box_url.is_external ? ' target="_blank"' : '';
        var positionClass = 'icon-position-' + settings.icon_position;
        #>

        <div class="eafe-icon-box {{ settings.template_style }} {{ positionClass }}">
            <# if ( settings.link_entire_box === 'yes' && settings.enable_button !== 'yes' ) { #>
            <a href="{{ settings.box_url.url }}"{{ boxTarget }} class="eafe-icon-box-link">
                <# } #>

                <# if ( settings.template_style === 'template-7' && settings.background_image.url ) { #>
                <div class="eafe-icon-box-bg-image" style="background-image: url({{ settings.background_image.url }});"></div>
                <# } #>

                <div class="eafe-icon-box-content">
                    <# if ( settings.icon_type === 'icon' && iconHTML.rendered ) { #>
                    <div class="eafe-icon-box-icon">
                        {{{ iconHTML.value }}}
                    </div>
                    <# } else if ( settings.icon_type === 'image' && settings.icon_image.url ) { #>
                    <div class="eafe-icon-box-icon eafe-icon-box-image">
                        <img src="{{ settings.icon_image.url }}" alt="{{ settings.title }}">
                    </div>
                    <# } #>

                    <div class="eafe-icon-box-text-content">
                        <# if ( settings.title ) { #>
                        <{{ settings.title_tag }} class="eafe-icon-box-title">{{{ settings.title }}}</{{ settings.title_tag }}>
                    <# } #>

                    <# if ( settings.description ) { #>
                    <p class="eafe-icon-box-description">{{{ settings.description }}}</p>
                    <# } #>

                    <# if ( settings.enable_button === 'yes' && settings.button_text ) { #>
                    <a href="{{ settings.button_url.url }}" class="eafe-icon-box-button"{{ target }}>
                        {{{ settings.button_text }}}
                    </a>
                    <# } #>
                </div>
        </div>

        <# if ( settings.link_entire_box === 'yes' && settings.enable_button !== 'yes' ) { #>
        </a>
        <# } #>
        </div>
        <?php
    }
}

