<?php

namespace EazyAddonsForElementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Stroke;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly
}

class EAFE_Gradient_Heading_Widget extends Widget_Base
{

  public function get_name()
  {
    return EAFE_WIDGET_PREFIX . 'gradient_heading';
  }

  public function get_title()
  {
    return __('Gradient Heading', 'nb-eazy-addons-for-elementor');
  }

  public function get_icon()
  {
    return 'eicon-t-letter';
  }

  public function get_categories()
  {
    return ['eazy-addons-for-elementor-category'];
  }

  public function get_keywords()
  {
    return ['gradient', 'heading', 'title', 'headline', 'text'];
  }

  protected function _register_controls()
  {
    // Content Section
    $this->start_controls_section(
      'content_section',
      [
        'label' => __('Content', 'nb-eazy-addons-for-elementor'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'title',
      [
        'label'       => __('Title', 'nb-eazy-addons-for-elementor'),
        'type'        => Controls_Manager::TEXT,
        'default'     => __('Gradient Heading', 'nb-eazy-addons-for-elementor'),
        'label_block' => true,
      ]
    );

    $this->add_control(
      'html_tag',
      [
        'label'   => __('HTML Tag', 'nb-eazy-addons-for-elementor'),
        'type'    => Controls_Manager::SELECT,
        'default' => 'h2',
        'options' => [
          'h1'   => __('H1', 'nb-eazy-addons-for-elementor'),
          'h2'   => __('H2', 'nb-eazy-addons-for-elementor'),
          'h3'   => __('H3', 'nb-eazy-addons-for-elementor'),
          'h4'   => __('H4', 'nb-eazy-addons-for-elementor'),
          'h5'   => __('H5', 'nb-eazy-addons-for-elementor'),
          'h6'   => __('H6', 'nb-eazy-addons-for-elementor'),
          'div'  => __('div', 'nb-eazy-addons-for-elementor'),
          'p'    => __('p', 'nb-eazy-addons-for-elementor'),
          'span' => __('span', 'nb-eazy-addons-for-elementor'),
        ],
      ]
    );

    $this->add_control(
      'link',
      [
        'label'         => __('Link', 'nb-eazy-addons-for-elementor'),
        'type'          => Controls_Manager::URL,
        'placeholder'   => __('https://your-link.com', 'nb-eazy-addons-for-elementor'),
        'show_external' => true,
        'default'       => [
          'url'         => '',
          'is_external' => false,
          'nofollow'    => false,
        ],
      ]
    );

    $this->add_responsive_control(
      'align',
      [
        'label'     => __('Alignment', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::CHOOSE,
        'options'   => [
          'left'    => [
            'title' => __('Left', 'nb-eazy-addons-for-elementor'),
            'icon'  => 'eicon-text-align-left',
          ],
          'center'  => [
            'title' => __('Center', 'nb-eazy-addons-for-elementor'),
            'icon'  => 'eicon-text-align-center',
          ],
          'right'   => [
            'title' => __('Right', 'nb-eazy-addons-for-elementor'),
            'icon'  => 'eicon-text-align-right',
          ],
          'justify' => [
            'title' => __('Justified', 'nb-eazy-addons-for-elementor'),
            'icon'  => 'eicon-text-align-justify',
          ],
        ],
        'default'   => 'center',
        'selectors' => [
          '{{WRAPPER}} .eafe-gradient-heading' => 'text-align: {{VALUE}};',
        ],
      ]
    );

    $this->end_controls_section();

    // Gradient Style Section
    $this->start_controls_section(
      'gradient_style_section',
      [
        'label' => __('Gradient Style', 'nb-eazy-addons-for-elementor'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'           => 'gradient_background',
        'label'          => __('Gradient Background', 'nb-eazy-addons-for-elementor'),
        'types'          => ['classic', 'gradient'],
        'selector'       => '{{WRAPPER}} .eafe-gradient-heading-text',
        'fields_options' => [
          'background' => [
            'default' => 'gradient',
          ],
          'color'      => [
            'default' => '#ff6b6b',
          ],
          'color_b'    => [
            'default' => '#4ecdc4',
          ],
        ],
      ]
    );

    $this->add_control(
      'gradient_angle',
      [
        'label'      => __('Gradient Angle', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['deg'],
        'range'      => [
          'deg' => [
            'min'  => 0,
            'max'  => 360,
            'step' => 1,
          ],
        ],
        'default'    => [
          'unit' => 'deg',
          'size' => 90,
        ],
        'selectors'  => [
          '{{WRAPPER}} .eafe-gradient-heading-text' => 'background: transparent; background: linear-gradient({{SIZE}}{{UNIT}}, {{gradient_background.color.VALUE}} 0%, {{gradient_background.color_b.VALUE}} 100%);',
        ],
        'condition'  => [
          'gradient_background_background' => ['gradient'],
        ],
      ]
    );

    $this->add_control(
      'background_clip',
      [
        'label'        => __('Background Clip', 'nb-eazy-addons-for-elementor'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Yes', 'nb-eazy-addons-for-elementor'),
        'label_off'    => __('No', 'nb-eazy-addons-for-elementor'),
        'return_value' => 'yes',
        'default'      => 'yes',
        'selectors'    => [
          '{{WRAPPER}} .eafe-gradient-heading-text' => '-webkit-background-clip: text; background-clip: text;',
        ],
      ]
    );

    $this->add_control(
      'text_fill_color',
      [
        'label'     => __('Text Fill Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'default'   => 'transparent',
        'selectors' => [
          '{{WRAPPER}} .eafe-gradient-heading-text' => '-webkit-text-fill-color: {{VALUE}}; color: {{VALUE}};',
        ],
        'condition' => [
          'background_clip' => 'yes',
        ],
      ]
    );

    $this->add_control(
      'text_stroke',
      [
        'label'        => __('Text Stroke', 'nb-eazy-addons-for-elementor'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Yes', 'nb-eazy-addons-for-elementor'),
        'label_off'    => __('No', 'nb-eazy-addons-for-elementor'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );

    $this->add_control(
      'text_stroke_color',
      [
        'label'     => __('Stroke Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'default'   => '#000000',
        'selectors' => [
          '{{WRAPPER}} .eafe-gradient-heading-text' => '-webkit-text-stroke-color: {{VALUE}};',
        ],
        'condition' => [
          'text_stroke' => 'yes',
        ],
      ]
    );

    $this->add_control(
      'text_stroke_width',
      [
        'label'      => __('Stroke Width', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 10,
            'step' => 0.1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 1,
        ],
        'selectors'  => [
          '{{WRAPPER}} .eafe-gradient-heading-text' => '-webkit-text-stroke-width: {{SIZE}}{{UNIT}};',
        ],
        'condition'  => [
          'text_stroke' => 'yes',
        ],
      ]
    );

    $this->end_controls_section();

    // Typography Section
    $this->start_controls_section(
      'typography_section',
      [
        'label' => __('Typography', 'nb-eazy-addons-for-elementor'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'title_typography',
        'label'    => __('Typography', 'nb-eazy-addons-for-elementor'),
        'selector' => '{{WRAPPER}} .eafe-gradient-heading-text',
      ]
    );

    $this->add_control(
      'blend_mode',
      [
        'label'     => __('Blend Mode', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::SELECT,
        'default'   => 'normal',
        'options'   => [
          'normal'      => __('Normal', 'nb-eazy-addons-for-elementor'),
          'multiply'    => __('Multiply', 'nb-eazy-addons-for-elementor'),
          'screen'      => __('Screen', 'nb-eazy-addons-for-elementor'),
          'overlay'     => __('Overlay', 'nb-eazy-addons-for-elementor'),
          'darken'      => __('Darken', 'nb-eazy-addons-for-elementor'),
          'lighten'     => __('Lighten', 'nb-eazy-addons-for-elementor'),
          'color-dodge' => __('Color Dodge', 'nb-eazy-addons-for-elementor'),
          'saturation'  => __('Saturation', 'nb-eazy-addons-for-elementor'),
          'color'       => __('Color', 'nb-eazy-addons-for-elementor'),
          'luminosity'  => __('Luminosity', 'nb-eazy-addons-for-elementor'),
        ],
        'selectors' => [
          '{{WRAPPER}} .eafe-gradient-heading-text' => 'mix-blend-mode: {{VALUE}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'text_margin',
      [
        'label'      => __('Margin', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .eafe-gradient-heading-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'text_padding',
      [
        'label'      => __('Padding', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .eafe-gradient-heading-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();

    // Background Section
    $this->start_controls_section(
      'background_section',
      [
        'label' => __('Background', 'nb-eazy-addons-for-elementor'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'heading_background',
        'label'    => __('Background', 'nb-eazy-addons-for-elementor'),
        'types'    => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .eafe-gradient-heading',
      ]
    );

    $this->add_responsive_control(
      'background_padding',
      [
        'label'      => __('Padding', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .eafe-gradient-heading' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_responsive_control(
      'background_margin',
      [
        'label'      => __('Margin', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .eafe-gradient-heading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_control(
      'border_radius',
      [
        'label'      => __('Border Radius', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors'  => [
          '{{WRAPPER}} .eafe-gradient-heading' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name'     => 'box_shadow',
        'label'    => __('Box Shadow', 'nb-eazy-addons-for-elementor'),
        'selector' => '{{WRAPPER}} .eafe-gradient-heading',
      ]
    );

    $this->end_controls_section();

    // Hover Effects Section
    $this->start_controls_section(
      'hover_effects_section',
      [
        'label' => __('Hover Effects', 'nb-eazy-addons-for-elementor'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_control(
      'hover_animation',
      [
        'label'        => __('Hover Animation', 'nb-eazy-addons-for-elementor'),
        'type'         => Controls_Manager::SELECT,
        'default'      => 'none',
        'options'      => [
          'none'         => __('None', 'nb-eazy-addons-for-elementor'),
          'grow'         => __('Grow', 'nb-eazy-addons-for-elementor'),
          'shrink'       => __('Shrink', 'nb-eazy-addons-for-elementor'),
          'pulse'        => __('Pulse', 'nb-eazy-addons-for-elementor'),
          'pulse-grow'   => __('Pulse Grow', 'nb-eazy-addons-for-elementor'),
          'pulse-shrink' => __('Pulse Shrink', 'nb-eazy-addons-for-elementor'),
          'push'         => __('Push', 'nb-eazy-addons-for-elementor'),
          'pop'          => __('Pop', 'nb-eazy-addons-for-elementor'),
          'float'        => __('Float', 'nb-eazy-addons-for-elementor'),
          'sink'         => __('Sink', 'nb-eazy-addons-for-elementor'),
          'wobble'       => __('Wobble', 'nb-eazy-addons-for-elementor'),
          'shine'        => __('Shine', 'nb-eazy-addons-for-elementor'),
        ],
        'prefix_class' => 'eafe-hover-animation-',
      ]
    );

    $this->add_control(
      'hover_gradient_change',
      [
        'label'        => __('Change Gradient on Hover', 'nb-eazy-addons-for-elementor'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Yes', 'nb-eazy-addons-for-elementor'),
        'label_off'    => __('No', 'nb-eazy-addons-for-elementor'),
        'return_value' => 'yes',
        'default'      => 'no',
      ]
    );

    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'      => 'hover_gradient_background',
        'label'     => __('Hover Gradient', 'nb-eazy-addons-for-elementor'),
        'types'     => ['classic', 'gradient'],
        'selector'  => '{{WRAPPER}} .eafe-gradient-heading:hover .eafe-gradient-heading-text',
        'condition' => [
          'hover_gradient_change' => 'yes',
        ],
      ]
    );

    $this->add_control(
      'hover_transition',
      [
        'label'      => __('Transition Duration', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['s'],
        'range'      => [
          's' => [
            'min'  => 0,
            'max'  => 3,
            'step' => 0.1,
          ],
        ],
        'default'    => [
          'unit' => 's',
          'size' => 0.3,
        ],
        'selectors'  => [
          '{{WRAPPER}} .eafe-gradient-heading-text' => 'transition: all {{SIZE}}{{UNIT}} ease;',
        ],
      ]
    );

    $this->end_controls_section();
  }

  protected function render()
  {
    $settings = $this->get_settings_for_display();

    // Include the render file and call the render function
    require_once __DIR__ . '/renders/render-eafe-gradient-heading-widget.php';
    \EazyAddonsForElementor\Widgets\Renders\render_eafe_gradient_heading_widget($settings);
  }
}
