<?php
namespace EazyAddonsForElementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
use Elementor\Widget_Base;
use Elementor\Icons_Manager;

if (!defined('ABSPATH')) exit;

class EAFE_Fun_Counter_Widget extends Widget_Base {

    public function get_name() {
        return EAFE_WIDGET_PREFIX . 'fun_counter';
    }

    public function get_title() {
        return __('Fun Counter', 'nb-eazy-addons-for-elementor');
    }

    public function get_icon() {
        return 'eicon-counter';
    }

    public function get_categories() {
        return ['eazy-addons-for-elementor-category'];
    }

    public function get_script_depends() {
        return ['eafe-fun-counter-widget'];
    }

    public function get_style_depends() {
        return ['eafe-fun-counter-widget'];
    }

    protected function _register_controls() {
        // Counters Content Section
        $this->start_controls_section(
            'factors_section',
            [
                'label' => __('Fun Counters', 'nb-eazy-addons-for-elementor'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'icon_type',
            [
                'label' => __('Icon Type', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'icon',
                'options' => [
                    'none' => __('None', 'nb-eazy-addons-for-elementor'),
                    'icon' => __('Icon Library', 'nb-eazy-addons-for-elementor'),
                    'svg' => __('Custom SVG', 'nb-eazy-addons-for-elementor'),
                    'image' => __('Image', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $repeater->add_control(
            'factor_icon',
            [
                'label' => __('Icon', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'icon_type' => 'icon',
                ],
            ]
        );

        $repeater->add_control(
            'factor_svg',
            [
                'label' => __('SVG Code', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => '',
                'placeholder' => __('Paste SVG code here', 'nb-eazy-addons-for-elementor'),
                'condition' => [
                    'icon_type' => 'svg',
                ],
            ]
        );

        $repeater->add_control(
            'factor_image',
            [
                'label' => __('Image', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => '',
                ],
                'condition' => [
                    'icon_type' => 'image',
                ],
            ]
        );

        // In the _register_controls method, update the factor_icon_color control:
        $repeater->add_control(
            'factor_icon_color',
            [
                'label' => __('Icon Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000000',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .eafe-factor-icon' => 'color: {{VALUE}}; --icon-color: {{VALUE}};',
                    '{{WRAPPER}} {{CURRENT_ITEM}} .eafe-factor-icon i' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} {{CURRENT_ITEM}} .eafe-factor-icon svg' => 'fill: {{VALUE}} !important; color: {{VALUE}} !important;',
                    '{{WRAPPER}} {{CURRENT_ITEM}} .eafe-factor-icon svg path' => 'fill: {{VALUE}} !important;',
                    '{{WRAPPER}} {{CURRENT_ITEM}} .eafe-factor-icon svg g' => 'fill: {{VALUE}} !important;',
                    '{{WRAPPER}} {{CURRENT_ITEM}} .eafe-factor-icon svg circle' => 'fill: {{VALUE}} !important;',
                    '{{WRAPPER}} {{CURRENT_ITEM}} .eafe-factor-icon svg rect' => 'fill: {{VALUE}} !important;',
                    '{{WRAPPER}} {{CURRENT_ITEM}} .eafe-factor-icon svg polygon' => 'fill: {{VALUE}} !important;',
                    '{{WRAPPER}} {{CURRENT_ITEM}} .eafe-factor-icon .eicon' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} {{CURRENT_ITEM}} .eafe-factor-icon .elementor-icon' => 'color: {{VALUE}} !important;',
                ],
                'condition' => [
                    'icon_type' => ['icon', 'svg'],
                ],
            ]
        );

        $repeater->add_control(
            'factor_start_number',
            [
                'label' => __('Start Number', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::NUMBER,
                'default' => 0,
                'min' => 0,
            ]
        );

        $repeater->add_control(
            'factor_end_number',
            [
                'label' => __('End Number', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::NUMBER,
                'default' => 100,
                'min' => 0,
            ]
        );

        $repeater->add_control(
            'factor_suffix',
            [
                'label' => __('Suffix', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => '+',
                'placeholder' => __('e.g. +, K, %', 'nb-eazy-addons-for-elementor'),
            ]
        );

        $repeater->add_control(
            'factor_title',
            [
                'label' => __('Title', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Happy Clients', 'nb-eazy-addons-for-elementor'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'factor_accent_color',
            [
                'label' => __('Accent Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#e11d48',
            ]
        );

        $this->add_control(
            'factors_list',
            [
                'label' => __('Counters', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'icon_type' => 'icon',
                        'factor_icon' => ['value' => 'fas fa-users', 'library' => 'fa-solid'],
                        'factor_icon_color' => '#e11d48',
                        'factor_start_number' => 0,
                        'factor_end_number' => 1000,
                        'factor_suffix' => '+',
                        'factor_title' => __('Happy Clients', 'nb-eazy-addons-for-elementor'),
                        'factor_accent_color' => '#e11d48',
                    ],
                    [
                        'icon_type' => 'icon',
                        'factor_icon' => ['value' => 'fas fa-trophy', 'library' => 'fa-solid'],
                        'factor_icon_color' => '#7c3aed',
                        'factor_start_number' => 0,
                        'factor_end_number' => 500,
                        'factor_suffix' => '+',
                        'factor_title' => __('Awards Won', 'nb-eazy-addons-for-elementor'),
                        'factor_accent_color' => '#7c3aed',
                    ],
                    [
                        'icon_type' => 'icon',
                        'factor_icon' => ['value' => 'fas fa-project-diagram', 'library' => 'fa-solid'],
                        'factor_icon_color' => '#0284c7',
                        'factor_start_number' => 0,
                        'factor_end_number' => 200,
                        'factor_suffix' => '+',
                        'factor_title' => __('Projects Completed', 'nb-eazy-addons-for-elementor'),
                        'factor_accent_color' => '#0284c7',
                    ],
                ],
                'title_field' => '{{{ factor_title }}}',
            ]
        );

        $this->end_controls_section();

        // Layout Section
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'nb-eazy-addons-for-elementor'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_preset',
            [
                'label' => __('Layout Preset', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'grid',
                'options' => [
                    'grid' => __('Grid', 'nb-eazy-addons-for-elementor'),
                    'horizontal' => __('Horizontal', 'nb-eazy-addons-for-elementor'),
                    'vertical' => __('Vertical', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'enable_animation',
            [
                'label' => __('Enable Animation', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('No', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'animation_duration',
            [
                'label' => __('Animation Duration (ms)', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => ['min' => 500, 'max' => 5000, 'step' => 100],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 2000,
                ],
                'condition' => [
                    'enable_animation' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'factor_gap',
            [
                'label' => __('Counter Gap', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'vw'],
                'range' => [
                    'px' => ['min' => 10, 'max' => 100],
                    'vw' => ['min' => 1, 'max' => 10],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-fun-counter' => '--factor-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'enable_dark_mode',
            [
                'label' => __('Enable Dark Mode', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('No', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'background_effects',
            [
                'label' => __('Background Effects', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('Hide', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'background_color',
            [
                'label' => __('Background Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => 'hsl(210 40% 98%)',
                'selectors' => [
                    '{{WRAPPER}} .eafe-fun-counter-with-bg' => '--bg: {{VALUE}};',
                ],
                'condition' => [
                    'background_effects' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        // Style Section
        $this->start_controls_section(
            'style_section',
            [
                'label' => __('Style', 'nb-eazy-addons-for-elementor'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __('Icon/Image Size', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => ['min' => 20, 'max' => 200],
                    '%' => ['min' => 10, 'max' => 100],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 60,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-factor-icon' => '--icon-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .eafe-factor-icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .eafe-factor-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .eafe-factor-icon img' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'number_typography',
                'label' => __('Number Typography', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-factor-number',
            ]
        );

        $this->add_control(
            'number_color',
            [
                'label' => __('Number Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000000',
                'selectors' => [
                    '{{WRAPPER}} .eafe-factor-number' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-factor-title',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000000',
                'selectors' => [
                    '{{WRAPPER}} .eafe-factor-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'factor_shadow',
                'label' => __('Box Shadow', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-factor',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'factor_border',
                'label' => __('Border', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-factor',
            ]
        );

        $this->add_responsive_control(
            'factor_padding',
            [
                'label' => __('Padding', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-factor' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        // Prepare repeater keys for each factor
        foreach ($settings['factors_list'] as $index => &$factor) {
            $factor['repeater_key'] = $this->get_repeater_setting_key('factor', 'factors_list', $index);
        }

        require_once __DIR__ . '/renders/render-eafe-fun-counter-widget.php';
        \EazyAddonsForElementor\Widgets\Renders\render_eafe_fun_counter_widget($settings, $this);
    }
}