<?php

namespace EazyAddonsForElementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Icons_Manager;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class EAFE_Dual_Button_Widget extends Widget_Base
{

    public function get_name()
    {
        return EAFE_WIDGET_PREFIX . 'dual_button';
    }

    public function get_title()
    {
        return __('Dual Button', 'nb-eazy-addons-for-elementor');
    }

    public function get_icon()
    {
        return 'eicon-dual-button';
    }

    public function get_categories()
    {
        return ['eazy-addons-for-elementor-category'];
    }

    public function get_keywords() {
        return [ 'dual', 'button', 'double', 'action', 'link' ];
    }

    /**
     * Get widget dependencies
     */
    public function get_style_depends() {
        return [
            'elementor-icons',
            'elementor-icons-fa-solid',
            'elementor-icons-fa-regular',
            'elementor-icons-fa-brands'
        ];
    }

    protected function _register_controls()
    {
        // Button 1 Content Section
        $this->start_controls_section(
            'button1_content_section',
            [
                'label' => __('Button 1', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'button1_text',
            [
                'label'       => __('Text', 'nb-eazy-addons-for-elementor'),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Button 1', 'nb-eazy-addons-for-elementor'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'button1_link',
            [
                'label' => __('Link', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'nb-eazy-addons-for-elementor'),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ]
        );

        $this->add_control(
            'button1_icon',
            [
                'label' => __('Icon', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
            ]
        );

        $this->add_control(
            'button1_icon_position',
            [
                'label' => __('Icon Position', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'before',
                'options' => [
                    'before' => __('Before Text', 'nb-eazy-addons-for-elementor'),
                    'after' => __('After Text', 'nb-eazy-addons-for-elementor'),
                ],
                'condition' => [
                    'button1_icon[value]!' => '',
                ],
            ]
        );

        $this->add_control(
            'button1_icon_spacing',
            [
                'label' => __('Icon Spacing', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-dual-button-1 .eafe-button-icon-before' => 'margin-right: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .eafe-dual-button-1 .eafe-button-icon-after' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'button1_icon[value]!' => '',
                ],
            ]
        );

        $this->end_controls_section();

        // Button 2 Content Section
        $this->start_controls_section(
            'button2_content_section',
            [
                'label' => __('Button 2', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'button2_text',
            [
                'label'       => __('Text', 'nb-eazy-addons-for-elementor'),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Button 2', 'nb-eazy-addons-for-elementor'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'button2_link',
            [
                'label' => __('Link', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'nb-eazy-addons-for-elementor'),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ]
        );

        $this->add_control(
            'button2_icon',
            [
                'label' => __('Icon', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
            ]
        );

        $this->add_control(
            'button2_icon_position',
            [
                'label' => __('Icon Position', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'after',
                'options' => [
                    'before' => __('Before Text', 'nb-eazy-addons-for-elementor'),
                    'after' => __('After Text', 'nb-eazy-addons-for-elementor'),
                ],
                'condition' => [
                    'button2_icon[value]!' => '',
                ],
            ]
        );

        $this->add_control(
            'button2_icon_spacing',
            [
                'label' => __('Icon Spacing', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-dual-button-2 .eafe-button-icon-before' => 'margin-right: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .eafe-dual-button-2 .eafe-button-icon-after' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'button2_icon[value]!' => '',
                ],
            ]
        );

        $this->end_controls_section();

        // Middle Text Section
        $this->start_controls_section(
            'middle_text_section',
            [
                'label' => __('Middle Text', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'middle_text',
            [
                'label'       => __('Text', 'nb-eazy-addons-for-elementor'),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('OR', 'nb-eazy-addons-for-elementor'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'middle_text_aria_hidden',
            [
                'label' => __('ARIA Hidden', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('No', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();

        // Layout Section
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_style',
            [
                'label' => __('Layout Style', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'horizontal',
                'options' => [
                    'horizontal' => __('Horizontal', 'nb-eazy-addons-for-elementor'),
                    'vertical' => __('Vertical', 'nb-eazy-addons-for-elementor'),
                    'split' => __('Split with Middle Text', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'button_style',
            [
                'label' => __('Button Style', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'style-1',
                'options' => [
                    'style-1' => __('Style 1 - Default', 'nb-eazy-addons-for-elementor'),
                    'style-2' => __('Style 2 - Outline', 'nb-eazy-addons-for-elementor'),
                    'style-3' => __('Style 3 - Gradient', 'nb-eazy-addons-for-elementor'),
                    'style-4' => __('Style 4 - 3D', 'nb-eazy-addons-for-elementor'),
                    'style-5' => __('Style 5 - Text', 'nb-eazy-addons-for-elementor'),
                    'style-6' => __('Style 6 - Split', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'alignment',
            [
                'label' => __('Alignment', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'nb-eazy-addons-for-elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'nb-eazy-addons-for-elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'nb-eazy-addons-for-elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
            ]
        );

        $this->add_control(
            'spacing',
            [
                'label' => __('Spacing', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [ 'px' => ['min' => 0, 'max' => 100, 'step' => 1] ],
                'default' => ['unit' => 'px', 'size' => 15],
                'selectors' => [
                    '{{WRAPPER}} .eafe-dual-button-container:not(.eafe-dual-button-style-6)' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'full_width',
            [
                'label' => __('Full Width', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('No', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->end_controls_section();

        // Button 1 Style Section
        $this->start_controls_section(
            'button1_style_section',
            [
                'label' => __('Button 1 Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button1_typography',
                'label' => __('Typography', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-dual-button-1',
            ]
        );

        $this->add_responsive_control(
            'button1_padding',
            [
                'label' => __('Padding', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'default' => [
                    'top' => 12, 'right' => 24, 'bottom' => 12, 'left' => 24,
                    'unit' => 'px', 'isLinked' => false,
                ],
                'tablet_default' => [
                    'top' => 12, 'right' => 20, 'bottom' => 12, 'left' => 20,
                    'unit' => 'px',
                ],
                'mobile_default' => [
                    'top' => 10, 'right' => 16, 'bottom' => 10, 'left' => 16,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-dual-button-1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'button1_border_radius',
            [
                'label' => __('Border Radius', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-dual-button-1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'button_style!' => 'style-6',
                ],
            ]
        );

        $this->start_controls_tabs('button1_style_tabs');

        $this->start_controls_tab(
            'button1_normal',
            [
                'label' => __('Normal', 'nb-eazy-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'button1_text_color',
            [
                'label' => __('Text Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .eafe-dual-button-1' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'button1_background',
                'label' => __('Background', 'nb-eazy-addons-for-elementor'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .eafe-dual-button-1',
                'fields_options' => [
                    'background' => [ 'default' => 'classic' ],
                    'color'      => [ 'default' => '#2563EB' ],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button1_border',
                'label' => __('Border', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-dual-button-1',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button1_box_shadow',
                'label' => __('Box Shadow', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-dual-button-1',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button1_hover',
            [
                'label' => __('Hover', 'nb-eazy-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'button1_text_color_hover',
            [
                'label' => __('Text Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .eafe-dual-button-1:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'button1_background_hover',
                'label' => __('Background', 'nb-eazy-addons-for-elementor'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .eafe-dual-button-1:hover',
                'fields_options' => [
                    'background' => [ 'default' => 'classic' ],
                    'color'      => [ 'default' => '#1D4ED8' ],
                ],
            ]
        );

        $this->add_control(
            'button1_border_color_hover',
            [
                'label' => __('Border Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .eafe-dual-button-1:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button1_box_shadow_hover',
                'label' => __('Box Shadow', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-dual-button-1:hover',
            ]
        );

        $this->add_control(
            'button1_hover_animation',
            [
                'label' => __('Hover Animation', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::HOVER_ANIMATION,
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        // Button 2 Style Section
        $this->start_controls_section(
            'button2_style_section',
            [
                'label' => __('Button 2 Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button2_typography',
                'label' => __('Typography', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-dual-button-2',
            ]
        );

        $this->add_responsive_control(
            'button2_padding',
            [
                'label' => __('Padding', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'default' => [
                    'top' => 12, 'right' => 24, 'bottom' => 12, 'left' => 24,
                    'unit' => 'px', 'isLinked' => false,
                ],
                'tablet_default' => [
                    'top' => 12, 'right' => 20, 'bottom' => 12, 'left' => 20,
                    'unit' => 'px',
                ],
                'mobile_default' => [
                    'top' => 10, 'right' => 16, 'bottom' => 10, 'left' => 16,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-dual-button-2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'button2_border_radius',
            [
                'label' => __('Border Radius', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-dual-button-2' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'button_style!' => 'style-6',
                ],
            ]
        );

        $this->start_controls_tabs('button2_style_tabs');

        $this->start_controls_tab(
            'button2_normal',
            [
                'label' => __('Normal', 'nb-eazy-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'button2_text_color',
            [
                'label' => __('Text Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .eafe-dual-button-2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'button2_background',
                'label' => __('Background', 'nb-eazy-addons-for-elementor'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .eafe-dual-button-2',
                'fields_options' => [
                    'background' => ['default' => 'classic',],
                    'color' => ['default' => '#D97706',],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button2_border',
                'label' => __('Border', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-dual-button-2',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button2_box_shadow',
                'label' => __('Box Shadow', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-dual-button-2',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button2_hover',
            [
                'label' => __('Hover', 'nb-eazy-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'button2_text_color_hover',
            [
                'label' => __('Text Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .eafe-dual-button-2:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'button2_background_hover',
                'label' => __('Background', 'nb-eazy-addons-for-elementor'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .eafe-dual-button-2:hover',
                'fields_options' => [
                    'background' => ['default' => 'classic',],
                    'color' => ['default' => '#B45309',],
                ],
            ]
        );

        $this->add_control(
            'button2_border_color_hover',
            [
                'label' => __('Border Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .eafe-dual-button-2:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button2_box_shadow_hover',
                'label' => __('Box Shadow', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-dual-button-2:hover',
            ]
        );

        $this->add_control(
            'button2_hover_animation',
            [
                'label' => __('Hover Animation', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::HOVER_ANIMATION,
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        // Middle Text Style Section
        $this->start_controls_section(
            'middle_text_style_section',
            [
                'label' => __('Middle Text Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'button_style' => 'style-6',
                ],
            ]
        );

        $this->add_control(
            'middle_text_color',
            [
                'label' => __('Text Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .eafe-dual-button-middle-text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'middle_text_background',
            [
                'label' => __('Background Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .eafe-dual-button-middle-text' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'middle_text_border_color',
            [
                'label' => __('Border Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .eafe-dual-button-middle-text::before' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'middle_text_typography',
                'label' => __('Typography', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-dual-button-middle-text',
            ]
        );

        $this->add_control(
            'middle_text_size',
            [
                'label' => __('Size', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 60,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-dual-button-middle-text' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'middle_text_ring_size',
            [
                'label' => __('Ring Size', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 20,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 8,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-dual-button-middle-text::before' => 'inset: -{{SIZE}}{{UNIT}}; border-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Container Style Section
        $this->start_controls_section(
            'container_style_section',
            [
                'label' => __('Container Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'container_border_radius',
            [
                'label' => __('Border Radius', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-dual-button-container' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'button_style' => 'style-6',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'container_box_shadow',
                'label' => __('Box Shadow', 'nb-eazy-addons-for-elementor'),
                'selector' => '{{WRAPPER}} .eafe-dual-button-container',
                'condition' => [
                    'button_style' => 'style-6',
                ],
            ]
        );

        $this->add_responsive_control(
            'container_padding',
            [
                'label' => __('Padding', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-dual-button-container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'container_margin',
            [
                'label' => __('Margin', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-dual-button-container' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        // Include the render file and call the render function
        require_once __DIR__ . '/renders/render-eafe-dual-button-widget.php';
        \EazyAddonsForElementor\Widgets\Renders\render_eafe_dual_button_widget($settings);
    }
}