<?php

namespace EazyAddonsForElementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class EAFE_Content_Toggle_Widget extends Widget_Base
{
    public function get_name()
    {
        return EAFE_WIDGET_PREFIX . 'content_toggle';
    }

    public function get_title()
    {
        return __('Content Toggle', 'nb-eazy-addons-for-elementor');
    }

    public function get_icon()
    {
        return 'eicon-toggle';
    }

    public function get_categories()
    {
        return ['eazy-addons-for-elementor-category'];
    }

    protected function _register_controls()
    {
        // Toggle Items Section
        $this->start_controls_section(
            'content_toggle_section',
            [
                'label' => __('Content Toggle', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'toggle_label',
            [
                'label'       => __('Toggle Label', 'nb-eazy-addons-for-elementor'),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Toggle Label', 'nb-eazy-addons-for-elementor'),
                'placeholder' => __('Enter toggle label', 'nb-eazy-addons-for-elementor'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'content_type',
            [
                'label' => __('Content Type', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'editor',
                'options' => [
                    'editor' => __('Editor', 'nb-eazy-addons-for-elementor'),
                    'template' => __('Saved Template', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $repeater->add_control(
            'toggle_content',
            [
                'label' => __('Toggle Content', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::WYSIWYG,
                'default' => __('Content for this toggle goes here.', 'nb-eazy-addons-for-elementor'),
                'condition' => [
                    'content_type' => 'editor',
                ],
            ]
        );

        $repeater->add_control(
            'saved_template',
            [
                'label' => __('Choose Template', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'options' => $this->get_saved_templates(),
                'condition' => [
                    'content_type' => 'template',
                ],
            ]
        );

        $this->add_control(
            'toggle_items',
            [
                'label' => __('Toggle Items', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'toggle_label' => __('Monthly', 'nb-eazy-addons-for-elementor'),
                        'toggle_content' => __('This is content for the monthly plan.', 'nb-eazy-addons-for-elementor'),
                    ],
                    [
                        'toggle_label' => __('Yearly', 'nb-eazy-addons-for-elementor'),
                        'toggle_content' => __('This is content for the yearly plan.', 'nb-eazy-addons-for-elementor'),
                    ],
                ],
                'title_field' => '{{{ toggle_label }}}',
            ]
        );

        $this->end_controls_section();

        // Style Section
        $this->start_controls_section(
            'content_toggle_style_section',
            [
                'label' => __('Style', 'nb-eazy-addons-for-elementor'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'toggle_background_color',
            [
                'label'     => __('Toggle Background Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#f5f5f5',
                'selectors' => [
                    '{{WRAPPER}} .eafe-toggle-switch' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'toggle_text_color',
            [
                'label'     => __('Toggle Text Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#333',
                'selectors' => [
                    '{{WRAPPER}} .eafe-toggle-switch button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'active_toggle_background',
            [
                'label'     => __('Active Toggle Background', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#0073e6',
                'selectors' => [
                    '{{WRAPPER}} .eafe-toggle-switch .toggle-btn[aria-expanded="true"]' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'active_toggle_text_color',
            [
                'label'     => __('Active Toggle Text Color', 'nb-eazy-addons-for-elementor'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .eafe-toggle-switch .toggle-btn[aria-expanded="true"]' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'toggle_typography',
                'selector' => '{{WRAPPER}} .eafe-toggle-switch button',
            ]
        );

        $this->add_control(
            'toggle_border_radius',
            [
                'label' => __('Border Radius', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-toggle-switch' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .eafe-toggle-switch .toggle-btn[aria-expanded="true"]' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'toggle_padding',
            [
                'label' => __('Padding', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-toggle-switch' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .eafe-toggle-switch .toggle-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    private function get_saved_templates()
    {
        $templates = \Elementor\Plugin::instance()->templates_manager->get_source('local')->get_items();
        $options = ['' => __('— Select Template —', 'nb-eazy-addons-for-elementor')];

        foreach ($templates as $template) {
            $options[$template['template_id']] = $template['title'];
        }

        return $options;
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        require_once __DIR__ . '/renders/render-eafe-content-toggle-widget.php';
        \EazyAddonsForElementor\Widgets\Renders\render_eafe_content_toggle_widget($settings);
    }
}