<?php
namespace EazyAddonsForElementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) exit;

class EAFE_Card_Widget extends Widget_Base {

    public function get_name() {
        return EAFE_WIDGET_PREFIX . 'card';
    }

    public function get_title() {
        return __('Content Card', 'nb-eazy-addons-for-elementor');
    }

    public function get_icon() {
        return 'eicon-post';
    }

    public function get_categories() {
        return ['eazy-addons-for-elementor-category'];
    }

    protected function _register_controls() {
        // Content Tab
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'nb-eazy-addons-for-elementor'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        // Prepare card type options
        $card_type_options = [
            'custom' => __('Custom Content', 'nb-eazy-addons-for-elementor'),
            'post' => __('Post', 'nb-eazy-addons-for-elementor'),
        ];

        // Add product option only if WooCommerce is active
        if (class_exists('WooCommerce')) {
            $card_type_options['product'] = __('Product', 'nb-eazy-addons-for-elementor');
        }

        $this->add_control(
            'card_type',
            [
                'label' => __('Card Type', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'custom',
                'options' => $card_type_options,
            ]
        );

        // Custom Content Controls
        $this->add_control(
            'image',
            [
                'label' => __('Image', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'card_type' => 'custom',
                ],
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Card Title', 'nb-eazy-addons-for-elementor'),
                'label_block' => true,
                'condition' => [
                    'card_type' => 'custom',
                ],
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => __('Description', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis.', 'nb-eazy-addons-for-elementor'),
                'condition' => [
                    'card_type' => 'custom',
                ],
            ]
        );

        $this->add_control(
            'badge_text',
            [
                'label' => __('Badge Text', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => __('New', 'nb-eazy-addons-for-elementor'),
                'condition' => [
                    'card_type' => 'custom',
                ],
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => __('Button Text', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Read More', 'nb-eazy-addons-for-elementor'),
                'condition' => [
                    'card_type' => 'custom',
                ],
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => __('Link', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'nb-eazy-addons-for-elementor'),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'condition' => [
                    'card_type' => 'custom',
                ],
            ]
        );

        // Post Controls
        $this->add_control(
            'post_id',
            [
                'label' => __('Select Post', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => $this->get_posts_list('post'),
                'condition' => [
                    'card_type' => 'post',
                ],
            ]
        );

        $this->add_control(
            'show_post_badge',
            [
                'label' => __('Show Badge', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('Hide', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'card_type' => 'post',
                ],
            ]
        );

        $this->add_control(
            'post_badge_text',
            [
                'label' => __('Badge Text', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => __('New', 'nb-eazy-addons-for-elementor'),
                'condition' => [
                    'card_type' => 'post',
                    'show_post_badge' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'show_category',
            [
                'label' => __('Show Category', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('Hide', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'card_type' => 'post',
                ],
            ]
        );

        $this->add_control(
            'show_post_button',
            [
                'label' => __('Show Button', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('Hide', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'card_type' => 'post',
                ],
            ]
        );

        $this->add_control(
            'post_button_text',
            [
                'label' => __('Button Text', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Read More', 'nb-eazy-addons-for-elementor'),
                'condition' => [
                    'card_type' => 'post',
                    'show_post_button' => 'yes',
                ],
            ]
        );

        // Product Controls
        $this->add_control(
            'product_id',
            [
                'label' => __('Select Product', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => $this->get_posts_list('product'),
                'condition' => [
                    'card_type' => 'product',
                ],
            ]
        );

        $this->add_control(
            'show_product_badge',
            [
                'label' => __('Show Badge', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('Hide', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'card_type' => 'product',
                ],
            ]
        );

        $this->add_control(
            'product_badge_text',
            [
                'label' => __('Badge Text', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Sale', 'nb-eazy-addons-for-elementor'),
                'condition' => [
                    'card_type' => 'product',
                    'show_product_badge' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'show_price',
            [
                'label' => __('Show Price', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('Hide', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'card_type' => 'product',
                ],
            ]
        );

        $this->add_control(
            'show_rating',
            [
                'label' => __('Show Rating', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('Hide', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'card_type' => 'product',
                ],
            ]
        );

        $this->add_control(
            'show_add_to_cart',
            [
                'label' => __('Show Add to Cart', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'nb-eazy-addons-for-elementor'),
                'label_off' => __('Hide', 'nb-eazy-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'card_type' => 'product',
                ],
            ]
        );

        $this->end_controls_section();

        // Hover Effects Section
        $this->start_controls_section(
            'hover_effects_section',
            [
                'label' => __('Hover Effects', 'nb-eazy-addons-for-elementor'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'image_hover_effect',
            [
                'label' => __('Image Hover Effect', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'zoom',
                'options' => [
                    'none' => __('None', 'nb-eazy-addons-for-elementor'),
                    'zoom' => __('Zoom', 'nb-eazy-addons-for-elementor'),
                    'fade' => __('Fade', 'nb-eazy-addons-for-elementor'),
                    'rotate' => __('Rotate', 'nb-eazy-addons-for-elementor'),
                    'blur' => __('Blur', 'nb-eazy-addons-for-elementor'),
                    'grayscale' => __('Grayscale', 'nb-eazy-addons-for-elementor'),
                    'sepia' => __('Sepia', 'nb-eazy-addons-for-elementor'),
                    'brightness' => __('Brightness', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'card_hover_effect',
            [
                'label' => __('Card Hover Effect', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'lift',
                'options' => [
                    'none' => __('None', 'nb-eazy-addons-for-elementor'),
                    'lift' => __('Lift', 'nb-eazy-addons-for-elementor'),
                    'shadow' => __('Shadow Grow', 'nb-eazy-addons-for-elementor'),
                    'slide-up' => __('Slide Up', 'nb-eazy-addons-for-elementor'),
                    'tilt' => __('Tilt', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'content_hover_effect',
            [
                'label' => __('Content Hover Effect', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'fade',
                'options' => [
                    'none' => __('None', 'nb-eazy-addons-for-elementor'),
                    'fade' => __('Fade In', 'nb-eazy-addons-for-elementor'),
                    'slide-up' => __('Slide Up', 'nb-eazy-addons-for-elementor'),
                    'slide-down' => __('Slide Down', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
            'style_section',
            [
                'label' => __('Card', 'nb-eazy-addons-for-elementor'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'card_style',
            [
                'label' => __('Card Style', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'style-1',
                'options' => [
                    'style-1' => __('Style 1', 'nb-eazy-addons-for-elementor'),
                    'style-2' => __('Style 2', 'nb-eazy-addons-for-elementor'),
                    'style-3' => __('Style 3', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'card_bg_color',
            [
                'label' => __('Background Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .eafe-card' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'card_border',
                'selector' => '{{WRAPPER}} .eafe-card',
            ]
        );

        $this->add_control(
            'card_border_radius',
            [
                'label' => __('Border Radius', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'card_box_shadow',
                'selector' => '{{WRAPPER}} .eafe-card',
            ]
        );

        $this->add_control(
            'card_padding',
            [
                'label' => __('Padding', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Image Style
        $this->start_controls_section(
            'image_style_section',
            [
                'label' => __('Image', 'nb-eazy-addons-for-elementor'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'image_border_radius',
            [
                'label' => __('Border Radius', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-card-image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'hover_effect_intensity',
            [
                'label' => __('Hover Effect Intensity', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'size' => 0.3,
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-card-image' => 'transition: all {{SIZE}}s ease;',
                ],
                'condition' => [
                    'image_hover_effect!' => 'none',
                ],
            ]
        );

        $this->add_control(
            'image_spacing',
            [
                'label' => __('Spacing', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-card-image' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Title Style
        $this->start_controls_section(
            'title_style_section',
            [
                'label' => __('Title', 'nb-eazy-addons-for-elementor'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .eafe-card-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .eafe-card-title',
            ]
        );

        $this->add_control(
            'title_spacing',
            [
                'label' => __('Spacing', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-card-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Description Style
        $this->start_controls_section(
            'description_style_section',
            [
                'label' => __('Description', 'nb-eazy-addons-for-elementor'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label' => __('Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .eafe-card-description' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description_typography',
                'selector' => '{{WRAPPER}} .eafe-card-description',
            ]
        );

        $this->add_control(
            'description_spacing',
            [
                'label' => __('Spacing', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-card-description' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Badge Style
        $this->start_controls_section(
            'badge_style_section',
            [
                'label' => __('Badge', 'nb-eazy-addons-for-elementor'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'badge_bg_color',
            [
                'label' => __('Background Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .eafe-card-badge' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'badge_text_color',
            [
                'label' => __('Text Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .eafe-card-badge' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'badge_typography',
                'selector' => '{{WRAPPER}} .eafe-card-badge',
            ]
        );

        $this->add_control(
            'badge_border_radius',
            [
                'label' => __('Border Radius', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .eafe-card-badge' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'badge_padding',
            [
                'label' => __('Padding', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-card-badge' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'badge_position',
            [
                'label' => __('Position', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::SELECT,
                'default' => 'top-right',
                'options' => [
                    'top-left' => __('Top Left', 'nb-eazy-addons-for-elementor'),
                    'top-right' => __('Top Right', 'nb-eazy-addons-for-elementor'),
                    'bottom-left' => __('Bottom Left', 'nb-eazy-addons-for-elementor'),
                    'bottom-right' => __('Bottom Right', 'nb-eazy-addons-for-elementor'),
                ],
            ]
        );

        $this->end_controls_section();

        // Button Style
        $this->start_controls_section(
            'button_style_section',
            [
                'label' => __('Button', 'nb-eazy-addons-for-elementor'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'button_bg_color',
            [
                'label' => __('Background Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .eafe-card-button' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_text_color',
            [
                'label' => __('Text Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .eafe-card-button' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .eafe-card-button',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} .eafe-card-button',
            ]
        );

        $this->add_control(
            'button_border_radius',
            [
                'label' => __('Border Radius', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-card-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'button_padding',
            [
                'label' => __('Padding', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .eafe-card-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'button_hover_bg_color',
            [
                'label' => __('Hover Background Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .eafe-card-button:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_hover_text_color',
            [
                'label' => __('Hover Text Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .eafe-card-button:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_hover_border_color',
            [
                'label' => __('Hover Border Color', 'nb-eazy-addons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .eafe-card-button:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();
    }

    private function get_posts_list($post_type = 'post') {
        $posts = get_posts([
            'post_type' => $post_type,
            'post_status' => 'publish',
            'numberposts' => -1,
        ]);

        $options = [];
        foreach ($posts as $post) {
            $options[$post->ID] = $post->post_title;
        }

        return $options;
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        require_once __DIR__ . '/renders/render-eafe-card-widget.php';
        \EazyAddonsForElementor\Widgets\Renders\render_eafe_card_widget($settings);
    }
}