<?php

namespace EazyAddonsForElementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly
}

class EAFE_Calendly_Widget extends Widget_Base
{
  public function get_name()
  {
    return EAFE_WIDGET_PREFIX . 'calendly';
  }

  public function get_title()
  {
    return __('Calendly Embed', 'nb-eazy-addons-for-elementor');
  }

  public function get_icon()
  {
    return 'eicon-calendar';
  }

  public function get_categories()
  {
    return ['eazy-addons-for-elementor-category'];
  }

  /**
   * Register widget controls
   */
  protected function _register_controls()
  {
    /**
     * ───── CONTENT TAB ─────
     */
    $this->start_controls_section(
      'calendly_content_section',
      [
        'label' => __('Calendly Settings', 'nb-eazy-addons-for-elementor'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );

    $this->add_control(
      'calendly_username',
      [
        'label'       => __('Username', 'nb-eazy-addons-for-elementor'),
        'type'        => Controls_Manager::TEXT,
        'placeholder' => __('e.g. yourname', 'nb-eazy-addons-for-elementor'),
        'label_block' => true,
      ]
    );

    $this->add_control(
      'calendly_event_type',
      [
        'label'   => __('Time Slot', 'nb-eazy-addons-for-elementor'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          '15min' => __('15 Minutes', 'nb-eazy-addons-for-elementor'),
          '30min' => __('30 Minutes', 'nb-eazy-addons-for-elementor'),
          '60min' => __('60 Minutes', 'nb-eazy-addons-for-elementor'),
        ],
        'default' => '30min',
      ]
    );

    $this->add_control(
      'hide_event_details',
      [
        'label'        => __('Hide Event Type Details', 'nb-eazy-addons-for-elementor'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Yes', 'nb-eazy-addons-for-elementor'),
        'label_off'    => __('No', 'nb-eazy-addons-for-elementor'),
        'return_value' => 'true',
        'default'      => '',
      ]
    );

    $this->add_control(
      'calendly_height',
      [
        'label'      => __('Height', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => ['min' => 300, 'max' => 1000],
        ],
        'default'    => [
          'size' => 630,
          'unit' => 'px',
        ],
      ]
    );

    $this->end_controls_section();

    /**
     * ───── STYLE TAB ─────
     */
    $this->start_controls_section(
      'calendly_style_section',
      [
        'label' => __('Container Style', 'nb-eazy-addons-for-elementor'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );

    $this->add_control(
      'background_color',
      [
        'label'     => __('Background Color', 'nb-eazy-addons-for-elementor'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .eafe-calendly-wrapper' => 'background-color: {{VALUE}};',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Border::get_type(),
      [
        'name'     => 'border',
        'label'    => __('Border', 'nb-eazy-addons-for-elementor'),
        'selector' => '{{WRAPPER}} .eafe-calendly-wrapper',
      ]
    );

    $this->add_control(
      'border_radius',
      [
        'label'      => __('Border Radius', 'nb-eazy-addons-for-elementor'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors'  => [
          '{{WRAPPER}} .eafe-calendly-wrapper' =>
            'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->add_group_control(
      \Elementor\Group_Control_Box_Shadow::get_type(),
      [
        'name'     => 'box_shadow',
        'selector' => '{{WRAPPER}} .eafe-calendly-wrapper',
      ]
    );

    $this->end_controls_section();
  }

  /**
   * Render output
   */
  protected function render()
  {
    $settings = $this->get_settings_for_display();

    require_once __DIR__ . '/renders/render-eafe-calendly-widget.php';
    \EazyAddonsForElementor\Widgets\Renders\render_eafe_calendly_widget($settings);
  }
}
