<?php

namespace EazyAddonsForElementor\Core;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class WidgetManager
{
    private $widgets_list = [];

    /**
     * Get available widgets list for admin dashboard
     */
    public static function get_widgets_for_dashboard()
    {
        $widget_files = glob(__DIR__ . '/../widgets/*.php');
        $widgets_list = [];

        foreach ($widget_files as $file) {
            $base_name = basename($file, '.php');

            // Skip if not a widget file
            if (strpos($base_name, 'EAFE_') !== 0) {
                continue;
            }

            $widget_name = strtolower(preg_replace('/([a-z])([A-Z])/', '$1-$2', $base_name));
            $widget_name = str_replace('_', '-', $widget_name);

            $title = str_replace(['EAFE_', '_Widget'], '', $base_name);
            $title = str_replace('_', ' ', $title);
            $title = preg_replace('/([a-z])([A-Z])/', '$1 $2', $title);
            $title = ucwords($title);

            $widgets_list[$widget_name] = [
                'title' => $title,
                'class' => 'EazyAddonsForElementor\\Widgets\\' . $base_name,
                'file' => $file,
                'enabled' => true
            ];
        }

        return $widgets_list;
    }

    /**
     * Check if widget is enabled in settings
     */
    public static function is_widget_enabled($widget_name)
    {
        $settings = get_option('eafe_settings', []);
        return !isset($settings['widgets'][$widget_name]) ? true : (bool) $settings['widgets'][$widget_name];
    }

    /**
     * Get widget count for statistics
     */
    public static function get_widget_count()
    {
        $widgets = self::get_widgets_for_dashboard();
        return count($widgets);
    }

    /**
     * Get enabled widget count for statistics
     */
    public static function get_enabled_widget_count()
    {
        $widgets = self::get_widgets_for_dashboard();
        $enabled_count = 0;

        foreach ($widgets as $widget_name => $widget_data) {
            if (self::is_widget_enabled($widget_name)) {
                $enabled_count++;
            }
        }

        return $enabled_count;
    }
}