<?php

/**
 * Plugin Name:       NB Eazy Addons for Elementor
 * Plugin URI:        https://wordpress.org/plugins/nb-eazy-addons-for-elementor
 * Description:       A custom Elementor widget bundle for WordPress, including creative design components and advanced UI elements.
 * Version:           1.1.1
 * Author:            Nashir Uddin
 * Author URI:        https://profiles.wordpress.org/nashirbabu/
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       nb-eazy-addons-for-elementor
 * Domain Path:       /languages
 *
 * WP Requirement & Test
 * Requires at least: 5.5
 * Tested up to: 6.8
 * Requires PHP: 7.0
 * Requires Plugins: elementor
 *
 * Elementor Test
 * Elementor tested up to: 3.29
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

// Composer autoloader
require_once __DIR__ . '/vendor/autoload.php';

// Plugin Constants
define('EAFE_URL', plugin_dir_url(__FILE__));
define('EAFE_PATH', plugin_dir_path(__FILE__));
define('EAFE_WIDGET_PREFIX', 'eafe_'); // Prefix for all widgets
define('EAFE_VERSION', '1.1.1'); // Prefix for all widgets

// Plugin Init
use EazyAddonsForElementor\Loader;

function eafe_init()
{
    $loader = new Loader();
    $loader->init();
}
add_action('plugins_loaded', 'eafe_init');
