(function($) {
    'use strict';

    const EafeStepFlowHandler = function($scope) {
        const $stepFlow = $scope.find('.eafe-step-flow');
        const layoutStyle = $stepFlow.hasClass('eafe-step-flow--vertical') ? 'vertical' :
            $stepFlow.hasClass('eafe-step-flow--grid') ? 'grid' : 'horizontal';

        // Add keyboard navigation and focus styles
        $stepFlow.find('.eafe-step').on('keydown', function(e) {
            if (e.key === 'Enter' || e.key === ' ') {
                e.preventDefault();
                $(this).trigger('click');
            }
        });

        // Click handler for interactive steps
        $stepFlow.find('.eafe-step').on('click', function() {
            // Highlight active step
            $stepFlow.find('.eafe-step').removeClass('eafe-step-active');
            $(this).addClass('eafe-step-active');
            console.log('Step clicked:', $(this).find('.eafe-step-title').text());
        });

        // Adjust layout-specific interactions
        if (layoutStyle === 'grid') {
            $stepFlow.find('.eafe-step').css('cursor', 'pointer');
        }
    };

    // Initialize with Elementor
    if (typeof elementorFrontend !== 'undefined') {
        elementorFrontend.hooks.addAction('frontend/element_ready/' + EAFE_WIDGET_PREFIX + 'step_flow.default', EafeStepFlowHandler);
    } else {
        jQuery(window).on('elementor/frontend/init', function() {
            elementorFrontend.hooks.addAction('frontend/element_ready/' + EAFE_WIDGET_PREFIX + 'step_flow.default', EafeStepFlowHandler);
        });
    }

})(jQuery);