document.addEventListener('DOMContentLoaded', function () {
  // Initialize social icons with enhanced interactions
  const socialIcons = document.querySelectorAll('.eafe-social-icons')

  socialIcons.forEach((container) => {
    const icons = container.querySelectorAll('.eafe-social-icon')

    icons.forEach((icon) => {
      // Add ripple effect on click
      icon.addEventListener('click', function (e) {
        if (this.closest('.eafe-social-no-link')) {
          e.preventDefault()
          return
        }

        // Create ripple element
        const ripple = document.createElement('span')
        const rect = this.getBoundingClientRect()
        const size = Math.max(rect.width, rect.height)
        const x = e.clientX - rect.left - size / 2
        const y = e.clientY - rect.top - size / 2

        ripple.style.cssText = `
          position: absolute;
          border-radius: 50%;
          background: rgba(255, 255, 255, 0.6);
          transform: scale(0);
          animation: ripple-animation 0.6s linear;
          width: ${size}px;
          height: ${size}px;
          left: ${x}px;
          top: ${y}px;
          pointer-events: none;
        `

        this.style.position = 'relative'
        this.style.overflow = 'hidden'
        this.appendChild(ripple)

        // Remove ripple after animation
        setTimeout(() => {
          ripple.remove()
        }, 600)
      })

      // Enhanced hover effects
      icon.addEventListener('mouseenter', function () {
        this.style.zIndex = '10'
      })

      icon.addEventListener('mouseleave', function () {
        this.style.zIndex = ''
      })
    })
  })
})

// Add ripple animation to CSS
const style = document.createElement('style')
style.textContent = `
  @keyframes ripple-animation {
    to {
      transform: scale(4);
      opacity: 0;
    }
  }
`
document.head.appendChild(style)
