document.addEventListener('DOMContentLoaded', function () {
  const bars = document.querySelectorAll('.eafe-progress-bar-fill')

  bars.forEach((bar) => {
    const width = bar.getAttribute('data-width') || bar.style.width || '0%'

    // Use global localized value or fallback to data attribute or default
    const speed =
      (typeof eafeProgressBarData !== 'undefined' &&
        eafeProgressBarData.animationSpeed) ||
      bar.getAttribute('data-speed') ||
      1000

    bar.style.width = '0'

    setTimeout(() => {
      bar.style.transition = `width ${speed}ms ease-in-out`
      bar.style.width = width
    }, 100)
  })
})
