(function($) {
    'use strict';

    // Initialize justified grid
    function initJustifiedGrid() {
        $('.eafe-justified-grid-container').each(function() {
            const container = $(this);
            const grid = container.find('.eafe-justified-grid');
            const gutter = parseInt(container.data('gutter')) || 15;
            const imageHeight = parseInt(container.data('height')) || 300;
            const columns = parseInt(container.data('columns')) || 3;
            const isMasonry = container.hasClass('eafe-justified-grid-style-6');

            // Handle masonry layout
            if (isMasonry) {
                applyMasonryLayout(container, grid, columns, gutter);

                // Reapply masonry on window resize
                $(window).on('resize', function() {
                    applyMasonryLayout(container, grid, columns, gutter);
                });
            }

            // Handle filtering for styles that support it
            if (container.hasClass('eafe-justified-grid-style-1') || container.hasClass('eafe-justified-grid-style-6')) {
                // Filter items
                container.find('.eafe-filter-button').on('click', function() {
                    const $this = $(this);
                    const filterValue = $this.attr('data-filter');

                    // Update active state
                    container.find('.eafe-filter-button').removeClass('active');
                    $this.addClass('active');

                    // Filter items
                    if (filterValue === '*') {
                        // Show all items
                        grid.find('.eafe-justified-grid-item').removeClass('hidden');
                    } else {
                        // Hide all items first
                        grid.find('.eafe-justified-grid-item').addClass('hidden');

                        // Show items that match the filter
                        grid.find(filterValue).removeClass('hidden');
                    }

                    // Reapply masonry layout after filtering
                    if (isMasonry) {
                        setTimeout(function() {
                            applyMasonryLayout(container, grid, columns, gutter);
                        }, 300);
                    }
                });
            }

            // Adjust image heights for non-masonry layouts
            if (!isMasonry && !container.hasClass('eafe-justified-grid-style-1')) {
                grid.find('.eafe-justified-grid-item img').css('height', imageHeight + 'px');
            }

            // Handle responsive images
            $(window).on('resize', function() {
                // Re-adjust heights on resize for non-masonry layouts
                if (!isMasonry && !container.hasClass('eafe-justified-grid-style-1')) {
                    grid.find('.eafe-justified-grid-item img').css('height', imageHeight + 'px');
                }
            });
        });
    }

    // Apply masonry layout using CSS columns
    function applyMasonryLayout(container, grid, columns, gutter) {
        // Reset any previous styles
        grid.css({
            'column-count': '',
            'column-gap': '',
            'width': ''
        });

        // Get container width
        const containerWidth = container.width();

        // Responsive column count
        let columnCount = columns;

        if (containerWidth < 768) {
            columnCount = 1;
        } else if (containerWidth < 1024 && columns > 3) {
            columnCount = 3;
        } else if (containerWidth < 1200 && columns > 4) {
            columnCount = 4;
        }

        // Apply masonry styles
        grid.css({
            'column-count': columnCount,
            'column-gap': gutter + 'px',
            'width': '100%'
        });

        // Style individual items
        grid.find('.eafe-justified-grid-item').css({
            'margin-bottom': gutter + 'px',
            'break-inside': 'avoid'
        });
    }

    // Initialize on document ready
    $(document).ready(function() {
        initJustifiedGrid();
    });

    // Reinitialize when Elementor editor changes
    if (window.elementor) {
        elementor.hooks.addAction('panel/open_editor/widget', function(panel, model, view) {
            if (model.attributes.widgetType === 'eafe-justified-grid') {
                setTimeout(initJustifiedGrid, 500);
            }
        });
    }

})(jQuery);