(function($) {
  $(window).on('elementor/frontend/init', function() {
    const handleToggleClick = function() {
      const container = this.closest('.eafe-content-toggle');
      const target = this.dataset.toggle;

      // Remove active class from all buttons and panels in this container
      container.querySelectorAll('.toggle-btn').forEach(btn => {
        btn.setAttribute('aria-expanded', 'false');
      });
      container.querySelectorAll('.toggle-panel').forEach(panel => {
        panel.classList.remove('active');
      });

      // Add active class to the selected button and panel
      this.setAttribute('aria-expanded', 'true');
      container.querySelector(`.toggle-panel.${target}`).classList.add('active');
    };

    // Initialize existing toggles
    const initToggles = function() {
      document.querySelectorAll('.eafe-toggle-switch .toggle-btn').forEach(button => {
        button.removeEventListener('click', handleToggleClick);
        button.addEventListener('click', handleToggleClick);
      });
    };

    // Run on page load
    initToggles();

    // Handle Elementor preview mode - reinitialize when new widgets are added
    if (typeof elementor !== 'undefined' && elementor.on) {
      elementor.on('preview:loaded', function() {
        initToggles();
      });
    }
  });
})(jQuery);