(function($) {
    $(window).on('elementor/frontend/init', function() {
        // Initialize card interactions
        $('.eafe-card').each(function() {
            const $card = $(this);

            // Handle touch devices
            $card.on('touchstart', function() {
                $card.toggleClass('touch-active');
            });
        });

        // Handle Elementor preview mode
        if (typeof elementor !== 'undefined' && elementor.on) {
            elementor.on('preview:loaded', function() {
                $('.eafe-card').off().each(function() {
                    const $card = $(this);

                    $card.on('touchstart', function() {
                        $card.toggleClass('touch-active');
                    });
                });
            });
        }
    });
})(jQuery);