<?php
if (!defined('ABSPATH')) {
    exit;
}

// Use WidgetManager for statistics
$total_widgets = count($widgets);
$enabled_widgets = \EazyAddonsForElementor\Core\WidgetManager::get_enabled_widget_count();
?>

<div class="wrap eafe-dashboard">
    <!-- Header -->
    <div class="eafe-header">
        <div class="eafe-header-content">
            <img src="<?php echo EAFE_URL . 'admin/assets/images/logo.png'; ?>" alt="Eazy Addons" class="eafe-logo" onerror="this.style.display='none'">
            <div class="eafe-header-text">
                <div class="eafe-main-title">
                    <h1><?php esc_html_e('Eazy Addons for Elementor', 'nb-eazy-addons-for-elementor'); ?></h1>
                </div>
                <div class="eafe-header-description">
                    <p><?php esc_html_e('Supercharge your Elementor with powerful widgets and features', 'nb-eazy-addons-for-elementor'); ?></p>
                </div>
            </div>
            <div class="eafe-header-badge">
                <span class="eafe-version">v<?php echo EAFE_VERSION; ?></span>
            </div>
        </div>
    </div>

    <!-- Tabs Navigation -->
    <div class="eafe-tabs">
        <nav class="eafe-tabs-nav">
            <button class="eafe-tab-button active" data-tab="overview">
                <span class="dashicons dashicons-dashboard"></span>
                <?php esc_html_e('Overview', 'nb-eazy-addons-for-elementor'); ?>
            </button>
            <button class="eafe-tab-button" data-tab="widgets">
                <span class="dashicons dashicons-admin-appearance"></span>
                <?php esc_html_e('Widgets', 'nb-eazy-addons-for-elementor'); ?>
                <span class="eafe-badge"><?php echo $total_widgets; ?></span>
            </button>
            <button class="eafe-tab-button" data-tab="support">
                <span class="dashicons dashicons-sos"></span>
                <?php esc_html_e('Support', 'nb-eazy-addons-for-elementor'); ?>
            </button>
        </nav>

        <div class="eafe-tabs-content">
            <!-- Overview Tab -->
            <div class="eafe-tab-pane active" id="overview-tab">
                <div class="eafe-stats-grid">
                    <div class="eafe-stat-card">
                        <div class="eafe-stat-icon">
                            <span class="dashicons dashicons-admin-appearance"></span>
                        </div>
                        <div class="eafe-stat-content">
                            <h3><?php echo $total_widgets; ?></h3>
                            <p><?php esc_html_e('Total Widgets', 'nb-eazy-addons-for-elementor'); ?></p>
                        </div>
                    </div>
                    <div class="eafe-stat-card">
                        <div class="eafe-stat-icon">
                            <span class="dashicons dashicons-yes"></span>
                        </div>
                        <div class="eafe-stat-content">
                            <h3><?php echo $enabled_widgets; ?></h3>
                            <p><?php esc_html_e('Active Widgets', 'nb-eazy-addons-for-elementor'); ?></p>
                        </div>
                    </div>
                    <div class="eafe-stat-card">
                        <div class="eafe-stat-icon">
                            <span class="dashicons dashicons-wordpress"></span>
                        </div>
                        <div class="eafe-stat-content">
                            <h3>v<?php echo EAFE_VERSION; ?></h3>
                            <p><?php esc_html_e('Plugin Version', 'nb-eazy-addons-for-elementor'); ?></p>
                        </div>
                    </div>
                    <div class="eafe-stat-card">
                        <div class="eafe-stat-icon">
                            <span class="dashicons dashicons-elementor"><i class="eicon-elementor"></i></span>
                        </div>
                        <div class="eafe-stat-content">
                            <h3><?php echo defined('ELEMENTOR_VERSION') ? ELEMENTOR_VERSION : 'Not Active'; ?></h3>
                            <p><?php esc_html_e('Elementor Version', 'nb-eazy-addons-for-elementor'); ?></p>
                        </div>
                    </div>
                </div>

                <div class="eafe-overview-content">
                    <div class="eafe-welcome-card">
                        <h2><?php esc_html_e('Welcome to Eazy Addons!', 'nb-eazy-addons-for-elementor'); ?></h2>
                        <p><?php esc_html_e('Thank you for choosing Eazy Addons for Elementor. This plugin provides a collection of powerful widgets to enhance your Elementor page building experience.', 'nb-eazy-addons-for-elementor'); ?></p>

                        <div class="eafe-quick-actions">
                            <a href="#widgets-tab" class="eafe-quick-action-button" data-tab="widgets">
                                <span class="dashicons dashicons-admin-appearance"></span>
                                <?php esc_html_e('Manage Widgets', 'nb-eazy-addons-for-elementor'); ?>
                            </a>
                            <a href="#" target="_blank" class="eafe-quick-action-button">
                                <span class="dashicons dashicons-book"></span>
                                <?php esc_html_e('View Documentation', 'nb-eazy-addons-for-elementor'); ?>
                            </a>
                            <a href="https://wordpress.org/support/plugin/nb-eazy-addons-for-elementor" target="_blank" class="eafe-quick-action-button">
                                <span class="dashicons dashicons-sos"></span>
                                <?php esc_html_e('Get Support', 'nb-eazy-addons-for-elementor'); ?>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Widgets Tab -->
            <div class="eafe-tab-pane" id="widgets-tab">
                <div class="eafe-widgets-control">
                    <div class="eafe-widgets-header">
                        <h2><?php esc_html_e('Widgets Management', 'nb-eazy-addons-for-elementor'); ?></h2>
                        <p><?php esc_html_e('Enable or disable specific widgets. Disabled widgets will not appear in Elementor editor.', 'nb-eazy-addons-for-elementor'); ?></p>

                        <?php if ($total_widgets > 0): ?>
                            <div class="eafe-bulk-actions">
                                <button type="button" class="button eafe-bulk-enable">
                                    <?php esc_html_e('Enable All', 'nb-eazy-addons-for-elementor'); ?>
                                </button>
                                <button type="button" class="button eafe-bulk-disable">
                                    <?php esc_html_e('Disable All', 'nb-eazy-addons-for-elementor'); ?>
                                </button>
                            </div>
                        <?php else: ?>
                            <div class="notice notice-warning">
                                <p><?php esc_html_e('No widgets found. Please check your widgets directory.', 'nb-eazy-addons-for-elementor'); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>

                    <?php if ($total_widgets > 0): ?>
                        <div class="eafe-widgets-grid">
                            <?php foreach ($widgets as $widget_slug => $widget_data): ?>
                                <div class="eafe-widget-card">
                                    <div class="eafe-widget-info">
                                        <h4><?php echo esc_html($widget_data['title']); ?></h4>
                                        <p class="eafe-widget-slug"><?php echo esc_html($widget_slug); ?></p>
                                    </div>
                                    <label class="eafe-switch">
                                        <input type="checkbox"
                                               name="widgets[<?php echo esc_attr($widget_slug); ?>]"
                                               value="1"
                                            <?php checked(isset($settings['widgets'][$widget_slug]) ? $settings['widgets'][$widget_slug] : true); ?>
                                               class="eafe-widget-toggle">
                                        <span class="eafe-slider"></span>
                                    </label>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Support Tab -->
            <div class="eafe-tab-pane" id="support-tab">
                <div class="eafe-support-grid">
                    <div class="eafe-support-card">
                        <h3><span class="dashicons dashicons-book"></span> <?php esc_html_e('Documentation', 'nb-eazy-addons-for-elementor'); ?></h3>
                        <p><?php esc_html_e('Comprehensive guides and tutorials to help you get the most out of Eazy Addons.', 'nb-eazy-addons-for-elementor'); ?></p>
                        <a href="#" target="_blank" class="button">
                            <?php esc_html_e('View Documentation', 'nb-eazy-addons-for-elementor'); ?>
                        </a>
                    </div>

                    <div class="eafe-support-card">
                        <h3><span class="dashicons dashicons-sos"></span> <?php esc_html_e('Support Forum', 'nb-eazy-addons-for-elementor'); ?></h3>
                        <p><?php esc_html_e('Get help from our support team and community members.', 'nb-eazy-addons-for-elementor'); ?></p>
                        <a href="https://wordpress.org/support/plugin/nb-eazy-addons-for-elementor" target="_blank" class="button">
                            <?php esc_html_e('Get Support', 'nb-eazy-addons-for-elementor'); ?>
                        </a>
                    </div>

                    <div class="eafe-support-card">
                        <h3><span class="dashicons dashicons-email"></span> <?php esc_html_e('Contact Us', 'nb-eazy-addons-for-elementor'); ?></h3>
                        <p><?php esc_html_e('Need direct help? Reach out to our support team.', 'nb-eazy-addons-for-elementor'); ?></p>
                        <a href="mailto:support@eazyaddons.com" class="button">
                            <?php esc_html_e('Email Support', 'nb-eazy-addons-for-elementor'); ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Save Button -->
    <div class="eafe-save-section">
        <button type="button" class="button button-primary button-large eafe-save-settings">
            <span class="eafe-save-text"><?php esc_html_e('Save Settings', 'nb-eazy-addons-for-elementor'); ?></span>
            <span class="eafe-saving-text" style="display: none;">
                <span class="dashicons dashicons-update spin"></span>
                <?php esc_html_e('Saving...', 'nb-eazy-addons-for-elementor'); ?>
            </span>
        </button>
        <div class="eafe-save-message"></div>
    </div>
</div>