(function () {
	'use strict';

	var ignoreHashChangeUntil = 0;

	function prefersReducedMotion() {
		return !!(window.matchMedia && window.matchMedia('(prefers-reduced-motion: reduce)').matches);
	}

	function getScrollOffset() {
		var o = 0;
		if (window.NanoTOC && window.NanoTOC.scrollOffset != null) {
			o = parseInt(window.NanoTOC.scrollOffset, 10);
			if (isNaN(o)) o = 0;
		}
		if (o < 0) o = 0;

		var adminBar = document.getElementById('wpadminbar');
		if (adminBar && adminBar.getBoundingClientRect) {
			var r = adminBar.getBoundingClientRect();
			if (r && r.height) {
				o += Math.round(r.height);
			}
		}

		return o;
	}

	function safeScrollTo(top, behavior) {
		try {
			window.scrollTo({ top: top, left: 0, behavior: behavior });
		} catch (err) {
			window.scrollTo(0, top);
		}
	}

	function scheduleOffsetCorrection(el, offset, behavior) {
		if (!el || !el.getBoundingClientRect) return;
		var runs = behavior === 'smooth' ? 2 : 1;
		var delays = behavior === 'smooth' ? [180, 520] : [60];
		for (var i = 0; i < runs; i++) {
			(function (d) {
				setTimeout(function () {
					if (!document.body.contains(el)) return;
					var rect = el.getBoundingClientRect();
					if (!rect) return;
					var delta = rect.top - offset;
					if (Math.abs(delta) < 2) return;
					var y = (window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0);
					var top = y + delta;
					if (top < 0) top = 0;
					safeScrollTo(top, behavior);
				}, d);
			})(delays[i]);
		}
	}

	function scrollToHash(hash, behavior) {
		if (!hash || hash.length < 2) return false;
		var id = hash.charAt(0) === '#' ? hash.slice(1) : hash;
		var el = document.getElementById(id);
		if (!el) return false;

		var offset = getScrollOffset();
		var rect = el.getBoundingClientRect();
		var y = (window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0);
		var top = rect.top + y - offset;
		if (top < 0) top = 0;

		safeScrollTo(top, behavior);
		scheduleOffsetCorrection(el, offset, behavior);

		return true;
	}

	function getBehavior() {
		if (prefersReducedMotion()) return 'auto';
		if (window.NanoTOC && window.NanoTOC.smoothScroll === 0) return 'auto';
		return 'smooth';
	}

	function onClick(e) {
		var a = e.target && e.target.closest ? e.target.closest('.nanotoc a[href^="#"]') : null;
		if (!a) return;

		var hash = a.getAttribute('href');
		if (!hash || hash.length < 2) return;

		e.preventDefault();
		if (e.stopImmediatePropagation) e.stopImmediatePropagation();
		if (e.stopPropagation) e.stopPropagation();
		var behavior = getBehavior();
		if (!scrollToHash(hash, behavior)) return;
		ignoreHashChangeUntil = Date.now() + 1200;

		if (history && history.pushState) {
			history.pushState(null, '', hash);
		}
	}

	function correctInitialHash() {
		if (!location || !location.hash) return;
		scrollToHash(location.hash, 'auto');
		setTimeout(function () {
			scrollToHash(location.hash, 'auto');
		}, 250);
	}

	document.addEventListener('click', onClick, true);
	document.addEventListener('DOMContentLoaded', correctInitialHash, false);
	window.addEventListener('load', correctInitialHash, false);
	window.addEventListener('hashchange', function () {
		if (Date.now() < ignoreHashChangeUntil) return;
		var behavior = getBehavior();
		scrollToHash(location.hash, behavior);
	}, false);
})();
