<?php
defined( 'ABSPATH' ) || exit;
if ( !function_exists('expandops_shared_verify_ajax_action') ) 
{
    function expandops_shared_verify_ajax_action( string $action ): bool
    {
        if( 
            !defined('DOING_AJAX') || 
            !DOING_AJAX 
        ){
            return false; 
        }
        if( $action === '' )
        {
            return false; 
        }
        if ( 
            !isset($_REQUEST['_wpnonce']) || 
            !wp_verify_nonce( sanitize_text_field(wp_unslash($_REQUEST['_wpnonce'])), $action ) 
        ){
            return false; 
        }
        return true;
    }
}
if ( !function_exists('expandops_shared_timestamp') ) 
{
    function expandops_shared_timestamp(): string
    {
        return  date_i18n('H:i:s \o\n d/m/Y', strtotime( current_time('mysql') ));
    }
}