<?php
/*
 * Plugin Name:       Nanomailer for AWS SES
 * Plugin URI:        https://expandops.dev/wordpress-plugins/nanomailer-for-aws-ses
 * Description:       A lightweight, easy-to-use plugin that integrates WP with Amazon Web Services (AWS) Simple Email Service (SES) to improve email delivery.
 * Version:           1.0.0
 * Requires at least: 5.8
 * Requires PHP:      8.0
 * Author:            ExpandOps
 * Author URI:        https://expandops.dev
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 */
defined( 'ABSPATH' ) || exit;
require 'shared/functions/expandops-functions.php';
require 'app/autoload.php';
if( !class_exists( 'ExpandOps\AAAFoundation\Classes\V1\Builder', false) )
{
    require 'lib/autoload.php';
}
require 'app/bootstrap.php';
register_uninstall_hook( __FILE__, 'expandops_nanomailer_uninstall' );
function expandops_nanomailer_uninstall()
{
    delete_option( 'expandops_nanomailer' );
    delete_site_option( 'expandops_nanomailer' );
}