<?php
namespace ExpandOps\AAAFoundation\Init\V1;
defined( 'ABSPATH' ) || exit;
use ExpandOps\AAAFoundation\Init\V1\ParentMenuPage;
use ExpandOps\AAAFoundation\Init\V1\RemoveParentSubmenuPage;
use ExpandOps\AAAFoundation\Classes\V1\BaseLog;
class AdminMenuEvent
{
    private static $parent_menu_title;
    private static $parent_menu_slug;
    public static function register( $parent_menu_title, $parent_menu_slug, $remove_parent_submenu_page = true )
    {
        if( !$parent_menu_title || !$parent_menu_slug )
        {
            BaseLog::error('Both $parent_menu_title and $parent_menu_slug must be provided.');
            throw new \InvalidArgumentException('Both $parent_menu_title and $parent_menu_slug must be provided.');
        }
        self::$parent_menu_title = $parent_menu_title;
        self::$parent_menu_slug = $parent_menu_slug;
        add_action( 'admin_menu', array( __CLASS__, 'parentMenuPageCb' ), 1); 
        if( $remove_parent_submenu_page )
        {
            add_action( 'admin_menu', array( __CLASS__, 'removeParentSubmenuPageCb' ), 99 ); 
        }
    } 
    public static function parentMenuPageCb()
    {
        ParentMenuPage::handle( self::$parent_menu_title, self::$parent_menu_slug );
    } 
    public static function removeParentSubmenuPageCb( )
    {
        RemoveParentSubmenuPage::handle( self::$parent_menu_slug );
    } 
} 