<?php
namespace ExpandOps\AAAFoundation\Init\V1;
defined( 'ABSPATH' ) || exit;
use ExpandOps\AAAFoundation\Init\V1\EnqueueStyles;
use ExpandOps\AAAFoundation\Classes\V1\BaseLog;
class AdminEnqueueScriptsEvent
{
    private static $plugin_url;
    private static $plugin_version;
    public static function register( $plugin_url, $plugin_version )
    {
        if( !$plugin_url || !$plugin_version )
        {
            BaseLog::error('Both $plugin_url and $plugin_version must be provided.');
            throw new \InvalidArgumentException('Both $plugin_url and $plugin_version must be provided.');
        }
        self::$plugin_url = $plugin_url;
        self::$plugin_version = $plugin_version;
        add_action( 'admin_enqueue_scripts', array( __CLASS__, 'enqueueSharedStylesScriptsCb' ) );
    } 
    public static function enqueueSharedStylesScriptsCb()
    {
        EnqueueStyles::handle( self::$plugin_url, self::$plugin_version);
    } 
} 